/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Push2PayBillValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            Object[] targetBillIds = TmcBotpHelper.getTargetBillIds((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill");
            if (EmptyUtil.isEmpty((Object[])targetBillIds)) continue;
            QFilter filter = new QFilter("id", "in", (Object)targetBillIds).and("billstatus", "not in", Arrays.asList("G", "F"));
            DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"billno", (QFilter[])filter.toArray());
            if (paybills.isEmpty()) continue;
            String billnos = paybills.stream().map(p -> p.getString("billno")).collect(Collectors.joining(","));
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u4ed8\u6b3e\u5904\u7406\u5355\u636e:%s\u3002", (String)"Push2PayBillValidator_1", (String)"tmc-cim-business", (Object[])new Object[]{billnos}));
        }
    }
}

