/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuesort");
        selector.add("sourcebillid");
        selector.add("lastrevenuedate");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<DynamicObject> revBills = Arrays.stream(dataEntity).map(r -> r.getDataEntity()).collect(Collectors.toList());
        Map idToBillMap = DepositHelper.getDepositId2BillMap((DynamicObject[])revBills.toArray(new DynamicObject[0]));
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject revenue = extData.getDataEntity();
            this.validateForReleaseAudit(extData, revenue);
            this.validateLastRevenueDate(extData, revenue, idToBillMap);
        }
    }

    private void validateForReleaseAudit(ExtendedDataEntity extData, DynamicObject revenue) {
        Map variables = this.getOption().getVariables();
        if (variables.containsKey("fromReleaseAudit")) {
            return;
        }
        if (variables.containsKey("const_operate_var")) {
            return;
        }
        String revenueSort = revenue.getString("revenuesort");
        if (RevenueSortEnum.redeem_revenue.getValue().equals(revenueSort)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"DptRevenueAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        } else if (RevenueSortEnum.redeposit_revenue.getValue().equals(revenueSort)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7eed\u5b58\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"DptRevenueAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateLastRevenueDate(ExtendedDataEntity extData, DynamicObject revenue, Map<Long, DynamicObject> idToBillMap) {
        DynamicObject depositBill = idToBillMap.get(revenue.getLong("sourcebillid"));
        if (EmptyUtil.isEmpty((DynamicObject)depositBill) || EmptyUtil.isEmpty((Object)depositBill.getDate("lastrevenuedate"))) {
            return;
        }
        if (EmptyUtil.isNoEmpty((Object)revenue.getDate("lastrevenuedate")) && depositBill.getDate("lastrevenuedate").compareTo(revenue.getDate("lastrevenuedate")) != 0 && !revenue.getBoolean("isinit")) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5\u671f\u5df2\u53d8\u66f4\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u751f\u6210\u5b58\u6b3e\u6536\u76ca\u5904\u7406\u5355\u3002", (String)"DptRevenueSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

