/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("lastrevenuedate");
        selector.add("revenuesort");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<DynamicObject> revBills = Arrays.stream(dataEntity).map(r -> r.getDataEntity()).collect(Collectors.toList());
        Map idToBillMap = DepositHelper.getDepositId2BillMap((DynamicObject[])revBills.toArray(new DynamicObject[0]));
        for (ExtendedDataEntity extData : dataEntity) {
            boolean isSame;
            DynamicObject revenue = extData.getDataEntity();
            DynamicObject depositBill = (DynamicObject)idToBillMap.get(revenue.getLong("sourcebillid"));
            if (EmptyUtil.isEmpty((DynamicObject)depositBill)) continue;
            Date depositLastRevDate = depositBill.getDate("lastrevenuedate");
            Date revenueLastRevDate = revenue.getDate("lastrevenuedate");
            boolean bl = isSame = EmptyUtil.isEmpty((Object)depositLastRevDate) && EmptyUtil.isEmpty((Object)revenueLastRevDate) || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositLastRevDate, revenueLastRevDate}) && depositLastRevDate.compareTo(revenueLastRevDate) == 0;
            if (!isSame && !revenue.getBoolean("isinit")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5\u671f\u5df2\u53d8\u66f4\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u751f\u6210\u5b58\u6b3e\u6536\u76ca\u5904\u7406\u5355\u3002", (String)"DptRevenueSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateRevenueSave(extData, revenue, depositBill);
            this.validateExistPreIntBill(extData, depositBill);
        }
    }

    private void validateRevenueSave(ExtendedDataEntity extData, DynamicObject revenue, DynamicObject depositBill) {
        if (RevenueSortEnum.redeem_revenue.getValue().equals(revenue.getString("revenuesort")) || RevenueSortEnum.redeposit_revenue.getValue().equals(revenue.getString("revenuesort"))) {
            QFilter qFilter = new QFilter("sourcebillid", "=", depositBill.getPkValue());
            qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("id", "!=", revenue.getPkValue()));
            boolean exists = QueryServiceHelper.exists((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter});
            if (!exists) {
                return;
            }
            if (RevenueSortEnum.redeem_revenue.getValue().equals(revenue.getString("revenuesort"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355\uff0c\u8bf7\u5148\u5220\u9664\u6216\u5ba1\u6838\u3002", (String)"DptRevenueSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6e90\u5b58\u6b3e\u5355\u5b58\u5728\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355\uff0c\u8bf7\u5148\u5220\u9664\u6216\u5ba1\u6838\u3002", (String)"DptRevenueSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateExistPreIntBill(ExtendedDataEntity extData, DynamicObject depositBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", depositBill.getPkValue());
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        qFilter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        DynamicObjectCollection preInts = QueryServiceHelper.query((String)"cim_depositpreint", (String)"billno", (QFilter[])new QFilter[]{qFilter}, (String)"");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)preInts)) {
            List intPreBillList = preInts.stream().map(r -> r.getString("billno")).collect(Collectors.toList());
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u9884\u63d0\u5355\u3010%s\u3011\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u5220\u9664\u3002", (String)"DptRevenueSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[]{String.join((CharSequence)",", intPreBillList)}));
        }
    }
}

