/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuesort");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map opMap = this.getOption().getVariables();
        boolean isNotFromRelaseAudit = EmptyUtil.isEmpty((String)((String)opMap.get("fromReleaseAudit")));
        List<ExtendedDataEntity> dataEntities = new ArrayList<ExtendedDataEntity>(dataEntity.length);
        dataEntities.addAll(Arrays.asList(dataEntity));
        dataEntities = this.validateConfirm(dataEntities);
        dataEntities = this.validateDownBill(dataEntities);
        if (isNotFromRelaseAudit) {
            ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
            for (ExtendedDataEntity extData : dataEntities) {
                DynamicObject revenue;
                if (!this.validateIsReleaseRevenue(extData, revenue = extData.getDataEntity())) continue;
                if (revenue.getBoolean("isinit") && EmptyUtil.isEmpty((String)((String)opMap.get("pass_isinit_validate")))) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u6536\u76ca\u5355\uff0c\u53ea\u80fd\u5728\u5b58\u6b3e\u521d\u59cb\u5316\u5355\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"DptRevenueUnAuditValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
                    continue;
                }
                dataEntityList.add(extData);
            }
            dataEntities = this.validateIsLastRevenue(dataEntityList);
        }
    }

    private List<ExtendedDataEntity> validateConfirm(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List billIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map targetBillIdMap = BusinessHelper.getTargetBillIdMap((String)"cim_dptrevenue", billIds, null);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject revenueBill = dataEntity.getDataEntity();
            Map targetEntityMap = (Map)targetBillIdMap.get(revenueBill.getLong("id"));
            if (targetEntityMap == null || !targetEntityMap.containsKey("ifm_bizdealbill_deposit")) {
                dataEntityList.add(dataEntity);
                continue;
            }
            Set idSets = (Set)targetEntityMap.get("ifm_bizdealbill_deposit");
            DynamicObjectCollection bizDealBills = QueryServiceHelper.query((String)"ifm_bizdealbill_deposit", (String)"id,bizstatus", (QFilter[])new QFilter("id", "in", (Object)idSets).toArray(), (String)"createtime desc");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)bizDealBills)) {
                dataEntityList.add(dataEntity);
                continue;
            }
            String bizStatus = ((DynamicObject)bizDealBills.get(0)).getString("bizstatus");
            if (!StringUtils.equals((CharSequence)bizStatus, (CharSequence)"D")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u5355\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u5f85\u53d7\u7406\u6216\u5df2\u53d7\u7406\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DptRevenueUnAuditValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateDownBill(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List dataEntitys = dataEntities.stream().filter(d -> DepositHelper.isSettleBill((DynamicObject)d.getDataEntity())).collect(Collectors.toList());
        if (!dataEntitys.isEmpty()) {
            dataEntityList.addAll(dataEntitys);
        }
        List notSettleList = dataEntities.stream().filter(d -> !DepositHelper.isSettleBill((DynamicObject)d.getDataEntity())).collect(Collectors.toList());
        List billIds = notSettleList.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map msgMap = BusinessHelper.checkDirtTargetBills((String)"cim_dptrevenue", billIds, null);
        for (ExtendedDataEntity dataEntity : notSettleList) {
            String msg = (String)msgMap.get(dataEntity.getDataEntity().getLong("id"));
            if (EmptyUtil.isNoEmpty((String)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean validateIsReleaseRevenue(ExtendedDataEntity extData, DynamicObject revenue) {
        String revenueSort = revenue.getString("revenuesort");
        if (RevenueSortEnum.redeem_revenue.getValue().equals(revenueSort)) {
            String ignoreRevenue = this.getOption().getVariables().getOrDefault("ignorerevenue", "");
            if (EmptyUtil.isEmpty((String)ignoreRevenue)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DptRevenueUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                return false;
            }
        } else if (RevenueSortEnum.redeposit_revenue.getValue().equals(revenueSort)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7eed\u5b58\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DptRevenueUnAuditValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<ExtendedDataEntity> validateIsLastRevenue(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map opMap = this.getOption().getVariables();
        Set sourceBillIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sourcebillid", "in", sourceBillIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection revenues = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"id,loanbillno,sourcebillid,createtime", (QFilter[])qFilter.toArray());
        Map<Long, DynamicObject> lastRevenueMap = revenues.stream().collect(Collectors.toMap(d -> d.getLong("sourcebillid"), Function.identity(), BinaryOperator.maxBy(Comparator.comparing(d -> d.getDate("createtime")))));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject revenueBill = dataEntity.getDataEntity();
            long sourceBillId = revenueBill.getLong("sourcebillid");
            DynamicObject lastRevenue = lastRevenueMap.get(sourceBillId);
            if (lastRevenue != null && lastRevenue.getLong("id") != revenueBill.getLong("id")) {
                if (EmptyUtil.isNoEmpty((String)((String)opMap.get("fromBatch")))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u5355%s\u7684\u6536\u76ca\u5355\u4e0d\u662f\u6700\u540e\u4e00\u5f20\u6536\u76ca\u5355\uff0c\u8bf7\u6839\u636e\u751f\u6210\u7684\u987a\u5e8f\u5012\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"DptRevenueUnAuditValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]), lastRevenue.getString("loanbillno")));
                    continue;
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6536\u76ca\u5355\u4e0d\u662f\u6700\u540e\u4e00\u5f20\u6536\u76ca\u5355\uff0c\u8bf7\u6839\u636e\u751f\u6210\u7684\u987a\u5e8f\u5012\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"DptRevenueUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }
}

