/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.finsubscribe;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class FinSubscribePush2RevenueValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("endinstdate");
        sic.add("revenueproject");
        sic.add("valuedate");
        sic.add("expiredate");
        sic.add("surplusamount");
        sic.add("surpluscopies");
        sic.add("billstatus");
        sic.add("finservicestatus");
        sic.add("redeemway");
        sic.add("tradechannel");
        sic.add("revenue_entry");
        sic.add("revenuestate");
        sic.add("revenuedate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus")) || FinServiceStatusEnum.subscribe_end.getValue().equals(bill.getString("finservicestatus"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u7406\u8d22\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u7ed3\u6e05\u201d\uff0c\u65b9\u53ef\u8fdb\u884c\u6536\u76ca\u64cd\u4f5c\u3002", (String)"FinSubscribeAutoRevenueValidator_04", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (RedeemWayEnum.copies_redeem.getValue().equals(bill.getString("redeemway"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53ea\u6709\u8d4e\u56de\u65b9\u5f0f\u4e3a\u91d1\u989d\u8d4e\u56de\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u6536\u76ca\u64cd\u4f5c\u3002", (String)"FinSubscribeAutoRevenueValidator_05", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (TradeChannelEnum.ONLINE.getValue().equals(bill.getString("tradechannel")) && !FinServiceStatusEnum.subscribe_done.getValue().equals(bill.getString("finservicestatus"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u53ea\u6709\u5df2\u7533\u8d2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u8fdb\u884c\u6536\u76ca\u64cd\u4f5c\u3002", (String)"FinSubscribeAutoRevenueValidator_06", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            BigDecimal surplusamount = bill.getBigDecimal("surplusamount");
            int surpluscopies = bill.getInt("surpluscopies");
            if (surplusamount.compareTo(BigDecimal.ZERO) == 0 && surpluscopies == 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7406\u8d22\u7533\u8d2d\u5355\u7684\u5269\u4f59\u91d1\u989d\u548c\u5269\u4f59\u4efd\u989d\u90fd\u4e3a0\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"FinSubscribeAutoRevenueValidator_02", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            QFilter finbillnoFilter = new QFilter("finbillno", "=", bill.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_revenue.getValue(), (QFilter[])new QFilter[]{finbillnoFilter, statusFilter});
            if (!exists) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7406\u8d22\u7533\u8d2d\u5355\u5df2\u5b58\u5728\u975e\u5ba1\u6838\u72b6\u6001\u7684\u6536\u76ca\u5355\u3002", (String)"FinSubscribeAutoRevenueValidator_03", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

