/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.finsubscribe;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinUpdateStatusSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("sourcetype");
        sid.add("sourcebillid");
        sid.add("entrys");
        sid.add("statusnew");
        sid.add("bebankstatus");
        sid.add("reason");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String sourceType = info.getString("sourcetype");
            Long sourceId = info.getLong("sourcebillid");
            DynamicObject targetBill = TmcDataServiceHelper.loadSingle((Object)sourceId, (String)sourceType);
            String errMsg = this.canUpdateState(targetBill);
            if (errMsg != null) {
                this.addErrorMessage(data, errMsg);
                continue;
            }
            DynamicObjectCollection currEntries = info.getDynamicObjectCollection("entrys");
            List updatedRecList = currEntries.stream().filter(o -> !Objects.equals(o.get("statusnew"), o.get("bebankstatus"))).collect(Collectors.toList());
            boolean has2TFRec = updatedRecList.stream().anyMatch(o -> Objects.equals(o.get("statusnew"), BebankStatusEnum.TF.getValue()));
            int size = updatedRecList.size();
            if (size == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u72b6\u6001\u53d8\u5316, \u8bf7\u4fee\u6539\u540e\u5728\u63d0\u4ea4\u3002", (String)"FinUpdateStatusSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            boolean reason = updatedRecList.stream().anyMatch(o -> EmptyUtil.isEmpty((String)o.getString("reason")));
            if (reason) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4fee\u6539\u539f\u56e0\u201d\u5b57\u6bb5\u3002", (String)"FinUpdateStatusSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            if (has2TFRec) continue;
        }
    }

    private String canUpdateState(DynamicObject targetBill) {
        Object billStatus = targetBill.get("billstatus");
        if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u4fee\u6539\u5355\u636e\u72b6\u6001\u3002", (String)"FinUpdateStatusSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]);
        }
        Object[] validStatusArr = new Object[]{BebankStatusEnum.TS.getValue(), BebankStatusEnum.TF.getValue(), BebankStatusEnum.NC.getValue()};
        String beBankStatus = targetBill.getString("bebankstatus");
        if (!Arrays.asList(validStatusArr).contains(beBankStatus)) {
            return ResManager.loadKDString((String)"\u7406\u8d22\u529e\u7406\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u3001\u4ea4\u6613\u5931\u8d25\u3001\u4ea4\u6613\u672a\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u4fee\u6539\u5355\u636e\u72b6\u6001\u3002", (String)"FinUpdateStatusSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]);
        }
        boolean isUpdatingStatus = this.isUpdatingStatus(targetBill);
        if (isUpdatingStatus) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5305\u542b\u672a\u5b8c\u6210\u7684\u4fee\u6539\u7406\u8d22\u529e\u7406\u72b6\u6001\u5355\u3002\u8bf7\u5148\u5b8c\u6210\u4fee\u6539\u72b6\u6001\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FinUpdateStatusSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean isUpdatingStatus(DynamicObject sourceBill) {
        boolean isUpdatingStatus = sourceBill.getBoolean("isupdatingstatus");
        if (!isUpdatingStatus) {
            return false;
        }
        QFilter submitFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "=", sourceBill.getPkValue());
        QFilter sourceBillTypeFilter = new QFilter("sourcetype", "=", (Object)sourceBill.getDataEntityType().getName());
        return TmcDataServiceHelper.exists((String)"cim_finupdatestat", (QFilter[])new QFilter[]{submitFilter, sourceBillTypeFilter, sourceBillIdFilter});
    }
}

