/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.init;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeInitHistoryUpdateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("isinit");
        selector.add("handredeemamt");
        selector.add("handlastredeemdate");
        selector.add("handrevenueamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject initBill = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)initBill.getString("billstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"FinSubscribeInitHistoryUpdateValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!initBill.getBoolean("isinit")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u6807\u8bc6\u4e3a\u662f\u7684\u5355\u636e\u3002", (String)"FinSubscribeInitHistoryUpdateValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)initBill.getBigDecimal("handredeemamt")) && EmptyUtil.isNoEmpty((Object)initBill.getDate("handlastredeemdate"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5355\u5df2\u8865\u5f55\u8fc7\u521d\u59cb\u5316\u8d4e\u56de\u5355\u3002", (String)"FinSubscribeInitHistoryUpdateValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)initBill.getBigDecimal("handrevenueamt"))) continue;
            QFilter qFilter = new QFilter("finbillno", "=", initBill.getPkValue());
            qFilter.and(new QFilter("isinit", "=", (Object)Boolean.TRUE));
            boolean exists = QueryServiceHelper.exists((String)"cim_revenue", (QFilter[])new QFilter[]{qFilter});
            if (!exists) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5355\u5df2\u8865\u5f55\u8fc7\u521d\u59cb\u5316\u6536\u76ca\u5355\u3002", (String)"FinSubscribeInitHistoryUpdateValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

