/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.profitscheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cim.common.enums.ProfitCycleEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class ProfitSchemeSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("period");
        selector.add("month");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<Object> selectMonths = new ArrayList(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject profitScheme = extendedDataEntity.getDataEntity();
            String profitCycle = profitScheme.getString("period");
            String interestMonths = profitScheme.getString("month");
            selectMonths = Arrays.asList(interestMonths.split(",")).stream().filter(v -> !StringUtils.isBlank((CharSequence)v)).map(Integer::valueOf).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(selectMonths)) {
                Collections.sort(selectMonths);
            }
            if (StringUtils.equals((CharSequence)ProfitCycleEnum.YEAR.getType(), (CharSequence)profitCycle)) {
                if (CollectionUtils.isEmpty(selectMonths) || selectMonths.size() != 1) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", (String)"ProfitSchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]), 1));
                }
            } else if (StringUtils.equals((CharSequence)ProfitCycleEnum.HALFYEAR.getType(), (CharSequence)profitCycle)) {
                if (CollectionUtils.isEmpty(selectMonths) || selectMonths.size() != 2) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", (String)"ProfitSchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]), 2));
                    continue;
                }
                if ((Integer)selectMonths.get(0) > 6 || (Integer)selectMonths.get(1) < 7) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u4e0a\u534a\u5e74\u4e0b\u534a\u5e74\u5404\u9009\u4e00\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", (String)"ProfitSchemeSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            } else if (StringUtils.equals((CharSequence)ProfitCycleEnum.QUARTER.getType(), (CharSequence)profitCycle)) {
                if (CollectionUtils.isEmpty(selectMonths) || selectMonths.size() != 4) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", (String)"ProfitSchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]), 4));
                    continue;
                }
                if ((Integer)selectMonths.get(0) > 3 || (Integer)selectMonths.get(1) < 4 || (Integer)selectMonths.get(1) > 6 || (Integer)selectMonths.get(2) < 7 || (Integer)selectMonths.get(2) > 9 || (Integer)selectMonths.get(3) < 10) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6bcf\u4e2a\u5b63\u5ea6\u9009\u62e9\u4e00\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", (String)"ProfitSchemeSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            } else if (StringUtils.equals((CharSequence)ProfitCycleEnum.MONTH.getType(), (CharSequence)profitCycle) && (CollectionUtils.isEmpty(selectMonths) || selectMonths.size() != 12)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", (String)"ProfitSchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]), 12));
            }
            if (!ProfitCycleEnum.isDay((String)profitCycle) || profitScheme.getInt("days") != 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5929\u6570\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"ProfitSchemeSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

