/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.redeem;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.SupermarketCardEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillSubmitValidator
extends AbstractTmcBizOppValidator {
    private static final Log LOG = LogFactory.getLog(RedeemBillSubmitValidator.class);

    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("finbillno");
        sid.add("redeemdate");
        sid.add("isrevenue");
        sid.add("redeemway");
        sid.add("realrevenue");
        sid.add("copies");
        sid.add("amount");
        sid.add("iopv");
        sid.add("isrenewal");
        sid.add("renewalamount");
        sid.add("renewalcopies");
        sid.add("renewaliopv");
        sid.add("isinit");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String purchaseDate;
            Map checkEndDate;
            String lastEndIntDate;
            DynamicObject redeem = dataEntity.getDataEntity();
            boolean isRevenue = redeem.getBoolean("isrevenue");
            boolean isRenewal = redeem.getBoolean("isrenewal");
            String redeemWay = redeem.getString("redeemway");
            String tradeChannel = redeem.getString("tradechannel");
            DynamicObject finBillF7 = redeem.getDynamicObject("finbillno");
            boolean isinit = redeem.getBoolean("isinit");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                BigDecimal amount = redeem.getBigDecimal("amount");
                if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d4e\u56de\u91d1\u989d\"\u3002", (String)"RedeemBillSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)redeem.getBigDecimal("realrevenue")) && isRevenue && !TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u5b9e\u9645\u6536\u76ca\"\u3002", (String)"RedeemBillSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (isRenewal && EmptyUtil.isEmpty((BigDecimal)redeem.getBigDecimal("renewalamount"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u7406\u8d22\u7eed\u671f\u91d1\u989d\"\u3002", (String)"RedeemBillSubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (!isinit && amount.compareTo(finBillF7.getBigDecimal("surplusamount")) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d4e\u56de\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7533\u8d2d\u5355\u7684\u5269\u4f59\u91d1\u989d\u3002", (String)"RedeemBillSubmitValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
                BigDecimal iopv;
                BigDecimal copies = redeem.getBigDecimal("copies");
                if (EmptyUtil.isEmpty((BigDecimal)copies)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d4e\u56de\u4efd\u6570\"\u3002", (String)"RedeemBillSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)(iopv = redeem.getBigDecimal("iopv"))) && !TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u5355\u4f4d\u51c0\u503c\"\u3002", (String)"RedeemBillSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (isRenewal && EmptyUtil.isEmpty((BigDecimal)redeem.getBigDecimal("renewalcopies"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u7eed\u671f\u8d2d\u4e70\u4efd\u6570\"\u3002", (String)"RedeemBillSubmitValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (isRenewal && EmptyUtil.isEmpty((BigDecimal)redeem.getBigDecimal("renewaliopv"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u7eed\u671f\u5355\u4f4d\u51c0\u503c\"\u3002", (String)"RedeemBillSubmitValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (!isinit && copies.compareTo(finBillF7.getBigDecimal("surpluscopies")) > 0 && !TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d4e\u56de\u4efd\u6570\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7533\u8d2d\u5355\u7684\u5269\u4f59\u4efd\u6570\u3002", (String)"RedeemBillSubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            Date redeemDate = redeem.getDate("redeemdate");
            String checkRedDate = RedeemBillHelper.checkLastRedeemDate((Object)finBillF7.getPkValue(), (Date)redeemDate);
            if (EmptyUtil.isNoEmpty((String)checkRedDate)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u4e00\u6b21\u7684\u8d4e\u56de\u65e5\u671f[%s]\u3002", (String)"RedeemBillSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]), checkRedDate));
            }
            if (EmptyUtil.isNoEmpty((String)(lastEndIntDate = (String)(checkEndDate = RedeemBillHelper.checkLastEndIntDate((Object)finBillF7.getPkValue(), (Date)redeemDate)).get("lastEndIntDate")))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u5355\u7684\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5%s\u3002", (String)"RedeemBillSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]), lastEndIntDate));
            }
            if (EmptyUtil.isNoEmpty((String)(purchaseDate = (String)checkEndDate.get("purchaseDate")))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u5355\u7684\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u7533\u8d2d\u65e5\u671f%s\u3002", (String)"RedeemBillSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]), purchaseDate));
            }
            QFilter idFilter = new QFilter("finbillno", "=", finBillF7.getPkValue());
            idFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            idFilter.and("id", "!=", redeem.getPkValue());
            QFilter beBankFilter = new QFilter("finbillno", "=", finBillF7.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and("bebankstatus", "not in", (Object)new String[]{BebankStatusEnum.TF.getValue(), BebankStatusEnum.TS.getValue()});
            QFilter redeemFilter = idFilter.copy().or(beBankFilter);
            boolean existsRed = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])redeemFilter.toArray());
            if (existsRed) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u8d4e\u56de\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"RedeemBillSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (isRevenue) {
                QFilter submitFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
                boolean existsSubmitRev = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_revenue.getValue(), (QFilter[])idFilter.and(submitFilter).toArray());
                if (existsSubmitRev) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u6536\u76ca\u8bb0\u5f55\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"RedeemBillSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                QFilter saveFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
                boolean existsSaveRev = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_revenue.getValue(), (QFilter[])idFilter.and(saveFilter).toArray());
                if (existsSaveRev) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8d4e\u56de\u5355\u5b58\u5728\u5176\u5b83\u6682\u5b58\u72b6\u6001\u7684\u6536\u76ca\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\u5f53\u524d\u8d4e\u56de\u5355\uff1f", (String)"RedeemBillSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]), ErrorLevel.Warning);
                }
            }
            this.validateRedeemAmtWhenPrdExist(redeem, dataEntity);
        }
    }

    private void validateRedeemAmtWhenPrdExist(DynamicObject redeem, ExtendedDataEntity dataEntity) {
        Optional<DynamicObject> prdOption = Optional.ofNullable(redeem.getDynamicObject("finbillno")).map(r -> r.getDynamicObject("product"));
        if (prdOption.isPresent()) {
            DynamicObject product = prdOption.get();
            DynamicObject productBill = TmcDataServiceHelper.loadSingle((Object)product.getPkValue(), (String)"cim_supermarket", (String)"bankcate,prdcardid");
            Long bankCateId = Optional.ofNullable(productBill.getDynamicObject("bankcate")).map(r -> r.getLong("id")).orElse(0L);
            String cardEntity = SupermarketCardEnum.getCardEntity((Long)bankCateId);
            if (EmptyUtil.isEmpty((String)cardEntity)) {
                return;
            }
            DynamicObject prdCardBill = TmcDataServiceHelper.loadSingle((String)cardEntity, (String)SuperMarketHelper.getCardPropByEntityWhenRedeem((String)cardEntity), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)productBill.getLong("prdcardid"))});
            BigDecimal redeemAmt = redeem.getBigDecimal("amount");
            if (StringUtils.equals((CharSequence)"cim_market_icbc", (CharSequence)cardEntity)) {
                BigDecimal minRedeemAmt = prdCardBill.getBigDecimal("icbc_mincopy");
                if (redeemAmt.compareTo(minRedeemAmt) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u201c\u5355\u7b14\u8d4e\u56de\u6700\u4f4e\u91d1\u989d\u201d\u3002", (String)"RedeemBillSubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            } else if (StringUtils.equals((CharSequence)"cim_market_cmb", (CharSequence)cardEntity)) {
                BigDecimal redeemFloor = prdCardBill.getBigDecimal("cmb_redeemfloor");
                BigDecimal redeemCeil = prdCardBill.getBigDecimal("cmb_redeemceil");
                if (redeemAmt.compareTo(redeemFloor) < 0 || redeemAmt.compareTo(redeemCeil) > 0) {
                    LOG.info("\u8d4e\u56de\u91d1\u989d\uff1a{},\u8d4e\u56de\u4e0a\u9650\uff1a{}\uff0c\u8d4e\u56de\u4e0b\u9650\uff1a{}", new Object[]{redeemAmt, redeemCeil, redeemFloor});
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8d4e\u56de\u91d1\u989d\u201d\u5fc5\u987b\u5728\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u201c\u8d4e\u56de\u4e0b\u9650\u201d\u4e0e\u201c\u8d4e\u56de\u4e0a\u9650\u201d\u4e4b\u95f4\u3002", (String)"RedeemBillSubmitValidator_10", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            } else if (StringUtils.equals((CharSequence)"cim_market_abc", (CharSequence)cardEntity)) {
                BigDecimal redeemFloor = prdCardBill.getBigDecimal("abc_redeemminamt");
                BigDecimal redeemCeil = prdCardBill.getBigDecimal("abc_redeemmaxamt");
                if (redeemAmt.compareTo(redeemFloor) < 0 || redeemAmt.compareTo(redeemCeil) > 0) {
                    LOG.info("\u8d4e\u56de\u91d1\u989d\uff1a{},\u8d4e\u56de\u4e0a\u9650\uff1a{}\uff0c\u8d4e\u56de\u4e0b\u9650\uff1a{}", new Object[]{redeemAmt, redeemCeil, redeemFloor});
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8d4e\u56de\u91d1\u989d\u201d\u5fc5\u987b\u5728\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u201c\u8d4e\u56de\u8d77\u70b9\u91d1\u989d\u201d\u4e0e\u201c\u8d4e\u56de\u6700\u9ad8\u91d1\u989d\u201d\u4e4b\u95f4\u3002", (String)"RedeemBillSubmitValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
        }
    }
}

