/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.redeem;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("finbillno");
        sid.add("count");
        sid.add("isrevenue");
        sid.add("id");
        sid.add("isrenewal");
        sid.add("bebankstatus");
        sid.add("isresubmit");
        sid.add("ispushrev");
        sid.add("isinit");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isRenewal;
            DynamicObject targetBill;
            boolean isResubmit;
            DynamicObject redeem = dataEntity.getDataEntity();
            String beBankStatus = redeem.getString("bebankstatus");
            if (EmptyUtil.isNoEmpty((String)beBankStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u94f6\u4f01\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (isResubmit = redeem.getBoolean("isresubmit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u91cd\u63d0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            int count = redeem.getInt("count");
            DynamicObject finBillF7 = redeem.getDynamicObject("finbillno");
            QFilter qFilter = new QFilter("finbillno", "=", finBillF7.getPkValue());
            qFilter.and("count", ">", (Object)count);
            boolean exists = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])qFilter.toArray());
            if (exists) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u8d4e\u56de\uff0c\u8bf7\u6309\u7167\u65f6\u95f4\u987a\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(targetBill = TmcBotpHelper.getTargetBill((String)CimEntityEnum.cim_redeem.getValue(), (Object)redeem.getPkValue(), (String)CimEntityEnum.cas_recbill.getValue())))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u6536\u6b3e\u5355\u5173\u8054\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u505a\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            boolean isRevenue = redeem.getBoolean("isrevenue");
            boolean isPushRev = redeem.getBoolean("ispushrev");
            if (isRevenue && isPushRev) {
                QFilter filter = new QFilter("redeemid", "=", (Object)redeem.getLong("id"));
                List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)CimEntityEnum.cim_revenue.getValue(), (QFilter[])new QFilter[]{filter}, (String)"", (int)-1);
                if (EmptyUtil.isNoEmpty((Object)revenueIds)) {
                    DynamicObject revBill = TmcDataServiceHelper.loadSingle(revenueIds.get(0), (String)CimEntityEnum.cim_revenue.getValue());
                    String checkRev = RedeemBillHelper.checkIsLastRevenue((Object)finBillF7.getPkValue(), (DynamicObject)revBill, (String)"revenue");
                    if (EmptyUtil.isNoEmpty((String)checkRev)) {
                        this.addErrorMessage(dataEntity, checkRev);
                    }
                }
            }
            if (isRenewal = redeem.getBoolean("isrenewal")) {
                Map botpMap;
                Object[] downbillIds;
                QFilter finFilter = new QFilter("sourbillno", "=", (Object)finBillF7.getString("number"));
                finFilter.and("isrenewal", "=", (Object)"1");
                DynamicObject finBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"id", (QFilter[])finFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)finBill) && (downbillIds = (botpMap = BFTrackerServiceHelper.findTargetBills((String)CimEntityEnum.cim_finsubscribe.getValue(), (Long[])new Long[]{finBill.getLong("id")})).entrySet().stream().filter(o -> !CimEntityEnum.cim_finsubscribe.getValue().equals(o.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray()).length > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7eed\u671f\u7684\u7406\u8d22\u7533\u8d2d\u5355\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"RedeemBillUnAuditValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            Map opMap = this.getOption().getVariables();
            if (!redeem.getBoolean("isinit") || !EmptyUtil.isEmpty((String)((String)opMap.get("pass_isinit_validate")))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u8d4e\u56de\u5355\uff0c\u53ea\u80fd\u5728\u7533\u8d2d\u521d\u59cb\u5316\u5355\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

