/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.revenue;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.PushRecBillVerifyHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillPushRecValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuesort");
        selector.add("billstatus");
        selector.add("ispushrec");
        selector.add("combineinst");
        selector.add("amount");
        selector.add("isinit");
        selector.add("redeemid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extData : extendedDataEntities) {
            DynamicObject revenueBill = extData.getDataEntity();
            String errMsg = PushRecBillVerifyHelper.verifyRevenueBill((DynamicObject)revenueBill);
            if (EmptyUtil.isNoEmpty((String)errMsg)) {
                this.addErrorMessage(extData, errMsg);
            }
            if (!revenueBill.getBoolean("ispushrec")) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u751f\u6210\u6536\u6b3e\u5355\u7684\u6536\u76ca\u5355\u624d\u53ef\u4ee5\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"RevenueBillPushRecValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

