/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.revenue;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("expiredate");
        sid.add("revenuestartdate");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finbillNoF7;
            DynamicObject revenue = dataEntity.getDataEntity();
            Date expireDate = revenue.getDate("expiredate");
            Date revenueStartDate = revenue.getDate("revenuestartdate");
            Map variables = this.getOption().getVariables();
            if (variables.containsKey("redeemDate")) {
                String redeemDate = (String)variables.get("redeemDate");
                expireDate = DateUtils.stringToDate((String)redeemDate, (String)"yyyy-MM-dd");
            }
            if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)revenueStartDate) && expireDate.compareTo(revenueStartDate) <= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5230\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u3002", (String)"RevenueBillSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(finbillNoF7 = revenue.getDynamicObject("finbillno")))) continue;
            QFilter qFilter = new QFilter("finbillno", "=", finbillNoF7.getPkValue());
            QFilter submitFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
            DynamicObject submitRev = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_revenue.getValue(), (String)"billno", (QFilter[])qFilter.and(submitFilter).toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)submitRev)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355%s\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u64a4\u9500\u3002", (String)"RevenueBillSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[]{submitRev.getString("billno")}));
        }
    }
}

