/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.scheme;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSchemeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        this.validateFinApply(dataEntity);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String redeemWay;
            DynamicObject finScheme = extendedDataEntity.getDataEntity();
            StringJoiner nullFeilds = new StringJoiner("\u3001");
            if (EmptyUtil.isEmpty((BigDecimal)finScheme.getBigDecimal("amount"))) {
                nullFeilds.add(ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d", (String)"FinApplySubmitValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)(redeemWay = finScheme.getString("redeemway")), (CharSequence)RedeemWayEnum.amount_redeem.getValue()) && EmptyUtil.isEmpty((BigDecimal)finScheme.getBigDecimal("planrevenue"))) {
                nullFeilds.add(ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u6536\u76ca\u7387\uff08%\uff09\u201d", (String)"FinApplySubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (null == finScheme.getBigDecimal("redeempattern")) {
                nullFeilds.add(ResManager.loadKDString((String)"\u201c\u8d4e\u56de\u6a21\u5f0f\u201d", (String)"FinSchemeSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (nullFeilds.length() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"FinApplySubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]), nullFeilds.toString()));
        }
    }

    private void validateFinApply(ExtendedDataEntity[] dataEntity) {
        String operateParam = this.getOption().getVariables().getOrDefault("fromfinapply", null);
        if (EmptyUtil.isNoEmpty((String)operateParam)) {
            return;
        }
        Object[] schemeIds = Arrays.stream(dataEntity).map(v -> v.getDataEntity().getPkValue()).toArray();
        DynamicObject[] finSchemeSFromDB = TmcDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_finscheme"));
        Map<Object, DynamicObject> finSchemeMap = Arrays.stream(finSchemeSFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject finScheme = extendedDataEntity.getDataEntity();
            DynamicObject finApply = finScheme.getDynamicObject("finapply");
            if (EmptyUtil.isEmpty((DynamicObject)finApply)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7406\u8d22\u7533\u8bf7\u5355\u3002", (String)"FinSchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject finSchemeFromDB = finSchemeMap.get(finScheme.getPkValue());
            if (EmptyUtil.isNoEmpty((DynamicObject)finSchemeFromDB) && StringUtils.equals((CharSequence)finSchemeFromDB.getDynamicObject("finapply").getString("number"), (CharSequence)finApply.getString("number"))) continue;
            if (StringUtils.equals((CharSequence)finApply.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7406\u8d22\u65b9\u6848\u53ea\u80fd\u5173\u8054\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u7406\u8d22\u7533\u8bf7\u5355\u3002", (String)"FinSchemeSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (finApply.getBoolean("inquiry")) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7406\u8d22\u65b9\u6848\u53ea\u80fd\u5173\u8054\u5f00\u542f\u7406\u8d22\u8be2\u4ef7\u7684\u7406\u8d22\u7533\u8bf7\u5355\u3002", (String)"FinSchemeSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

