/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.enums;

import java.util.Arrays;
import java.util.List;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum ProfitCycleEnum {
    YEAR("year", "12", new MultiLangEnumBridge("\u5e74", "ProfitCycleEnum_0", "tmc-cim-common")),
    HALFYEAR("halfyear", "6,12", new MultiLangEnumBridge("\u534a\u5e74", "ProfitCycleEnum_1", "tmc-cim-common")),
    QUARTER("quarter", "3,6,9,12", new MultiLangEnumBridge("\u5b63\u5ea6", "ProfitCycleEnum_2", "tmc-cim-common")),
    MONTH("month", "1,2,3,4,5,6,7,8,9,10,11,12", new MultiLangEnumBridge("\u6708", "ProfitCycleEnum_3", "tmc-cim-common")),
    TOYEAR("toyear", null, new MultiLangEnumBridge("\u5bf9\u5e74", "ProfitCycleEnum_4", "tmc-cim-common")),
    TOQUARTER("toquarter", null, new MultiLangEnumBridge("\u5bf9\u5b63", "ProfitCycleEnum_7", "tmc-cim-common")),
    TOMONTH("tomonth", null, new MultiLangEnumBridge("\u5bf9\u6708", "ProfitCycleEnum_5", "tmc-cim-common")),
    TOHALFYEAR("tohalfyear", null, new MultiLangEnumBridge("\u5bf9\u534a\u5e74", "ProfitCycleEnum_8", "tmc-cim-common")),
    ENDINTEREST("endinterest", null, new MultiLangEnumBridge("\u5230\u671f\u4e00\u6b21\u7ed3\u606f", "ProfitCycleEnum_6", "tmc-cim-common")),
    DAY("day", null, new MultiLangEnumBridge("\u5929", "ProfitCycleEnum_9", "tmc-cim-common")),
    CUSTOM("custom", null, new MultiLangEnumBridge("\u81ea\u5b9a\u4e49\u6536\u76ca\u65e5", "ProfitCycleEnum_10", "tmc-cim-common"));

    private String type;
    private String defValue;
    private MultiLangEnumBridge bridge;

    private ProfitCycleEnum(String type, String defValue, MultiLangEnumBridge bridge) {
        this.type = type;
        this.defValue = defValue;
        this.bridge = bridge;
    }

    public String getType() {
        return this.type;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static String getDefValueByType(String type) {
        for (ProfitCycleEnum profitCycle : ProfitCycleEnum.values()) {
            if (!profitCycle.getType().equals(type)) continue;
            return profitCycle.getDefValue();
        }
        return null;
    }

    public static String getName(String value) {
        return Arrays.stream(ProfitCycleEnum.values()).filter(d -> d.type.equals(value)).map(ProfitCycleEnum::getName).findFirst().orElse(null);
    }

    public static ProfitCycleEnum getEnumByValue(String value) {
        return Arrays.stream(ProfitCycleEnum.values()).filter(d -> d.type.equals(value)).findFirst().orElse(null);
    }

    public static boolean isCycle(String value) {
        return ProfitCycleEnum.isYear(value) || ProfitCycleEnum.isHalfYear(value) || ProfitCycleEnum.isQuarter(value) || ProfitCycleEnum.isMonth(value);
    }

    public static boolean isToCycle(String value) {
        return ProfitCycleEnum.isToYear(value) || ProfitCycleEnum.isToQuarter(value) || ProfitCycleEnum.isToMonth(value) || ProfitCycleEnum.isToHalfYear(value);
    }

    public static boolean isYear(String value) {
        return YEAR.getType().equals(value);
    }

    public static boolean isHalfYear(String value) {
        return HALFYEAR.getType().equals(value);
    }

    public static boolean isQuarter(String value) {
        return QUARTER.getType().equals(value);
    }

    public static boolean isMonth(String value) {
        return MONTH.getType().equals(value);
    }

    public static boolean isToYear(String value) {
        return TOYEAR.getType().equals(value);
    }

    public static boolean isToQuarter(String value) {
        return TOQUARTER.getType().equals(value);
    }

    public static boolean isToMonth(String value) {
        return TOMONTH.getType().equals(value);
    }

    public static boolean isToHalfYear(String value) {
        return TOHALFYEAR.getType().equals(value);
    }

    public static boolean isEndinterest(String value) {
        return ENDINTEREST.getType().equals(value);
    }

    public static boolean isDay(String value) {
        return DAY.getType().equals(value);
    }

    public static boolean isCustom(String value) {
        return CUSTOM.getType().equals(value);
    }

    public static boolean isShowMonthDay(String value) {
        List<String> list = Arrays.asList(YEAR.getType(), HALFYEAR.getType(), QUARTER.getType(), MONTH.getType());
        return list.contains(value);
    }
}

