/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessHelper {
    public static String checkDirtTargetBills(String entityName, Long billId) {
        return BusinessHelper.checkDirtTargetBills(entityName, billId, null);
    }

    public static Map<Long, Map<String, Set<Long>>> getTargetBillIdMap(String entityName, List<Long> billIds, Set<String> excludeEntityNames) {
        return TmcBotpHelper.getDirtTargetBillIdMap((String)entityName, billIds, excludeEntityNames, null);
    }

    public static Map<Long, String> checkDirtTargetBills(String entityName, List<Long> billIds, Map<String, QFilter> filterMap) {
        HashSet<String> excludeEntityNames = new HashSet<String>(Arrays.asList("ifm_transhandlebill", "ifm_rectransbill"));
        return BusinessHelper.checkDirtTargetBills(entityName, billIds, excludeEntityNames, filterMap);
    }

    public static Map<Long, String> checkDirtTargetBills(String entityName, List<Long> billIds, Set<String> excludeEntityNames, Map<String, QFilter> filterMap) {
        Map targetBillNoMap = TmcBotpHelper.getDirtTargetBillNoMap((String)entityName, billIds, excludeEntityNames, null, filterMap);
        return TmcBotpHelper.getTargetBillMsgMap((Map)targetBillNoMap);
    }

    public static String checkDirtTargetBills(String entityName, Long billId, Map<String, QFilter> filterMap) {
        Map<Long, String> map = BusinessHelper.checkDirtTargetBills(entityName, Collections.singletonList(billId), filterMap);
        return Optional.ofNullable(map.get(billId)).orElse("");
    }

    public static String checkTargetBills(String entityName, Long billId) {
        StringBuilder msg = new StringBuilder();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billId});
        if (botpMap != null && botpMap.size() > 0) {
            for (Map.Entry entry : botpMap.entrySet()) {
                String existBillsMsg = BusinessHelper.findExistBillsMsg((String)entry.getKey(), (HashSet)entry.getValue(), null);
                msg.append(existBillsMsg);
            }
        }
        if (msg.length() > 0) {
            msg.insert(0, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"BusinessHelper_0", (String)"tmc-cim-common", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static String checkTargetBillsExcludeSaveStat(String entityName, Long billId) {
        StringBuilder msg = new StringBuilder();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billId});
        if (botpMap != null && botpMap.size() > 0) {
            for (Map.Entry entry : botpMap.entrySet()) {
                String downStreamEntity = (String)entry.getKey();
                String existBillsMsg = "";
                existBillsMsg = "cim_release".equals(downStreamEntity) || "cim_noticerelease".equals(downStreamEntity) ? BusinessHelper.findExistBillsMsgExcludeSaveStat(downStreamEntity, (HashSet)entry.getValue(), null) : BusinessHelper.findExistBillsMsg((String)entry.getKey(), (HashSet)entry.getValue(), null);
                msg.append(existBillsMsg);
            }
        }
        if (msg.length() > 0) {
            msg.insert(0, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"BusinessHelper_0", (String)"tmc-cim-common", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    private static String findExistBillsMsg(String targetEntityName, HashSet<Long> targetBillIds, QFilter filter) {
        DynamicObjectCollection query;
        QFilter qFilters = new QFilter("id", "in", targetBillIds);
        if (EmptyUtil.isNoEmpty((Object)filter)) {
            qFilters.and(filter);
        }
        if ((query = QueryServiceHelper.query((String)targetEntityName, (String)"billno", (QFilter[])new QFilter[]{qFilters})) == null || query.size() <= 0) {
            return "";
        }
        List billnos = query.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        String targetBillName = CimEntityEnum.getName(targetEntityName);
        return String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e[%2$s]\uff1b", (String)"BusinessHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }

    private static String findExistBillsMsgExcludeSaveStat(String targetEntityName, HashSet<Long> targetBillIds, QFilter filter) {
        DynamicObjectCollection query;
        QFilter qFilters = new QFilter("id", "in", targetBillIds);
        if (EmptyUtil.isNoEmpty((Object)filter)) {
            qFilters.and(filter);
        }
        if ((query = QueryServiceHelper.query((String)targetEntityName, (String)"billno,billstatus", (QFilter[])new QFilter[]{qFilters})) == null || query.size() <= 0) {
            return "";
        }
        List billnos = query.stream().filter(r -> !BillStatusEnum.SAVE.getValue().equals(r.getString("billstatus"))).map(v -> v.getString("billno")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(billnos)) {
            return "";
        }
        String targetBillName = CimEntityEnum.getName(targetEntityName);
        return String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e[%2$s]\uff1b", (String)"BusinessHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }

    public static void deleteAttachment(DynamicObject[] dataEntities, String targetEntity) {
        for (DynamicObject initBill : dataEntities) {
            AttachmentServiceHelper.remove((String)targetEntity, (Object)initBill.getLong("id"));
            if (!"ifm_deposit".equals(targetEntity) && !"ifm_notice_deposit".equals(targetEntity)) continue;
            String opSideEntity = "ifm_notice_deposit".equals(targetEntity) ? "cim_noticedeposit" : "cim_deposit";
            AttachmentServiceHelper.remove((String)opSideEntity, (Object)initBill.getLong("id"));
        }
    }

    public static void addAttachments(DynamicObject[] dataEntities, String targetEntity) {
        for (DynamicObject initBill : dataEntities) {
            TmcAttachmentHelper.setAttachments((DynamicObject)initBill, (String)targetEntity, (Long)initBill.getLong("id"), (String)"attachmentpanel", (String)"attachmentpanel");
            if (!"ifm_deposit".equals(targetEntity) && !"ifm_notice_deposit".equals(targetEntity)) continue;
            String opSideEntity = "ifm_notice_deposit".equals(targetEntity) ? "cim_noticedeposit" : "cim_deposit";
            TmcAttachmentHelper.setAttachments((DynamicObject)initBill, (String)opSideEntity, (Long)initBill.getLong("id"), (String)"attachmentpanel", (String)"attachmentpanel");
        }
    }
}

