/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cim.common.bean.RateAdjustBean;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CimRateAdjustHelper {
    public static void updateRateAdjustList(DynamicObject finBill, Map<String, String> operationVariable) {
        DynamicObjectCollection rateAdjustEntry = finBill.getDynamicObjectCollection("rateadjust_entry");
        if (!"true".equals(operationVariable.get("hand"))) {
            rateAdjustEntry.clear();
        }
        List<Object> rateAdjustList = new ArrayList(10);
        if (CollectionUtils.isEmpty((Collection)rateAdjustEntry)) {
            rateAdjustList = CimRateAdjustHelper.getRateAdjustList(finBill);
        }
        if (EmptyUtil.isNoEmpty(rateAdjustList)) {
            rateAdjustEntry.clear();
            int seq = 1;
            rateAdjustList = CimRateAdjustHelper.updateEffectDateByRateResetAdjustRule(finBill, rateAdjustList);
            rateAdjustList.sort(Comparator.comparing(RateAdjustBean::getEffectDate));
            for (RateAdjustBean rateAdjustBean : rateAdjustList) {
                DynamicObject rateAdjustEntryDo = rateAdjustEntry.addNew();
                rateAdjustEntryDo.set("seq", (Object)seq++);
                rateAdjustEntryDo.set("ra_confirmdate", (Object)rateAdjustBean.getConfirmDate());
                rateAdjustEntryDo.set("ra_effectdate", (Object)rateAdjustBean.getEffectDate());
                rateAdjustEntryDo.set("ra_yearrate", (Object)rateAdjustBean.getYearRate());
                rateAdjustEntryDo.set("ra_remark", (Object)rateAdjustBean.getRemark());
                rateAdjustEntryDo.set("ra_modifier", (Object)rateAdjustBean.getModifier());
                rateAdjustEntryDo.set("ra_modifydate", (Object)rateAdjustBean.getModifyDate());
            }
        }
    }

    private static List<RateAdjustBean> getRateAdjustList(DynamicObject finBill) {
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(10);
        Date actStartIntDate = RevenueCalcHelper.getStartIntDate(finBill);
        CimRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(actStartIntDate, actStartIntDate, finBill.getBigDecimal("planrevenue")));
        return rateAdjustBeanList;
    }

    private static void definListAdd(List<RateAdjustBean> rateAdjustBeanList, RateAdjustBean needAddObj) {
        List theSameRateAdjusts;
        if (EmptyUtil.isNoEmpty(rateAdjustBeanList) && EmptyUtil.isNoEmpty(theSameRateAdjusts = rateAdjustBeanList.stream().filter(o -> o.getEffectDate().compareTo(needAddObj.getEffectDate()) == 0).collect(Collectors.toList()))) {
            rateAdjustBeanList.removeAll(theSameRateAdjusts);
        }
        rateAdjustBeanList.add(needAddObj);
    }

    private static List<RateAdjustBean> updateEffectDateByRateResetAdjustRule(DynamicObject finBill, List<RateAdjustBean> rateAdjustList) {
        DynamicObject productFactory = finBill.getDynamicObject("productfactory");
        if (productFactory == null) {
            return rateAdjustList;
        }
        String rateResetRule = productFactory.getString("rateresetadjustrule");
        if (EmptyUtil.isBlank((CharSequence)rateResetRule) || AdjustMethodEnum.no_adjust.getValue().equals(rateResetRule)) {
            return rateAdjustList;
        }
        DynamicObjectCollection workCalendars = finBill.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendars)) {
            return rateAdjustList;
        }
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)rateResetRule);
        for (RateAdjustBean rateAdjustBean : rateAdjustList) {
            Date confirmDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)rateAdjustBean.getConfirmDate(), (AdjustMethodEnum)adjustMethod);
            rateAdjustBean.setConfirmDate(confirmDate);
        }
        return rateAdjustList;
    }
}

