/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import org.apache.commons.lang3.tuple.Triple;

public class DepositInitHelper {
    public static Triple<String, String, String> getEntityTriple(String currentEntity) {
        Triple entityTriple;
        switch (currentEntity) {
            case "cim_noticedeposit_init": {
                entityTriple = Triple.of((Object)"cim_noticedeposit", (Object)"cim_noticerelease", (Object)"cim_dptrevenue");
                break;
            }
            case "ifm_deposit_init": {
                entityTriple = Triple.of((Object)"ifm_deposit", (Object)"ifm_release", (Object)"ifm_dptrevenue");
                break;
            }
            case "ifm_noticedeposit_init": {
                entityTriple = Triple.of((Object)"ifm_notice_deposit", (Object)"ifm_notice_release", (Object)"ifm_dptrevenue");
                break;
            }
            default: {
                entityTriple = Triple.of((Object)"cim_deposit", (Object)"cim_release", (Object)"cim_dptrevenue");
            }
        }
        return entityTriple;
    }

    public static void setReleaseInitBill(DynamicObject releaseBill, DynamicObject depositBill, Date handRedeemDate, String currentDepositEntity) {
        releaseBill.set("redeemdate", (Object)handRedeemDate);
        releaseBill.set("accountdate", (Object)handRedeemDate);
        BigDecimal handRedeemAmt = depositBill.getBigDecimal("handredeemamt");
        releaseBill.set("amount", (Object)handRedeemAmt);
        releaseBill.set("totalamount", (Object)handRedeemAmt);
        releaseBill.set("realrevenue", null);
        releaseBill.set("isrevenue", (Object)Boolean.FALSE);
        releaseBill.set("combineinst", (Object)Boolean.FALSE);
        releaseBill.set("isinit", (Object)Boolean.TRUE);
        String releaseType = "cim_noticedeposit".equals(currentDepositEntity) || "ifm_notice_deposit".equals(currentDepositEntity) ? ReleaseTypeEnum.agreeon.getValue() : (handRedeemDate.compareTo(depositBill.getDate("expiredate")) < 0 ? ReleaseTypeEnum.inadvance.getValue() : ReleaseTypeEnum.expire.getValue());
        releaseBill.set("releasetype", (Object)releaseType);
    }

    public static List<Object> setRevenueInitBill(DynamicObject depositBill, BigDecimal handRevenueAmt, String revenueEntity, OperateOption option) {
        option.setVariableValue("WF", "TRUE");
        option.setVariableValue("from_init_bill", "true");
        option.setVariableValue("revenuesort", RevenueSortEnum.revenue.getValue());
        option.setVariableValue("actpreinstamt", handRevenueAmt.toString());
        Date bizDate = DateUtils.getNextDay((Date)depositBill.getDate("handlastrevenuedate"), (int)1);
        option.setVariableValue("bizdate", DateUtils.formatString((Date)bizDate, (String)"yyyyMMdd"));
        TmcOperateServiceHelper.execOperate((String)"push2revenue", (String)depositBill.getDynamicObjectType().getName(), (Object[])new Object[]{depositBill.getPkValue()}, (OperateOption)option);
        QFilter qFilter = new QFilter("sourcebillid", "=", depositBill.getPkValue());
        return QueryServiceHelper.queryPrimaryKeys((String)revenueEntity, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
    }
}

