/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeDetail;

public class FinSubscribeHelper {
    private static final Log LOG = LogFactory.getLog(FinSubscribeHelper.class);

    public static BigDecimal getApplyLastCopies(DynamicObject applyBill) {
        BigDecimal addCopies = BigDecimal.ZERO;
        Long[] subscribeIds = TmcBotpHelper.getTargetBillIds((String)"cim_finapply", (Object)applyBill.getPkValue(), (String)"cim_finsubscribe");
        DynamicObjectCollection subscribeBills = QueryServiceHelper.query((String)"cim_finsubscribe", (String)"buycopies,redeemway", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)subscribeIds), new QFilter("finservicestatus", "!=", (Object)FinServiceStatusEnum.subscribe_fail.getValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)subscribeBills)) {
            addCopies = subscribeBills.stream().filter(r -> RedeemWayEnum.copies_redeem.getValue().equals(r.getString("redeemway"))).map(x -> x.getBigDecimal("buycopies")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return applyBill.getBigDecimal("buycopies").subtract(addCopies);
    }

    public static EBResult dealResponseResult(List<FinsubscribeDetail> details, DynamicObject finSubscribeBill, boolean isUpdate) {
        FinsubscribeDetail detail = details.get(0);
        EBResult ebResult = new EBResult();
        if (detail.getDetailSeqID().equals(finSubscribeBill.getPkValue().toString())) {
            BeBillStatusEnum status = BeServiceHelper.transferState((String)(isUpdate ? detail.getUpdateStatus() : detail.getEbStatus()));
            if (BeBillStatusEnum.TS.getValue().equals(status.getValue())) {
                FinSubscribeHelper.setStatus(finSubscribeBill, detail, status);
                FinSubscribeHelper.writeBackFinsubscribe(detail, finSubscribeBill);
                FinSubscribeHelper.writeBackFinApply(finSubscribeBill);
                ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
            } else {
                ebResult.setStatusCode(EBResultStatusCode.ERROR);
                ebResult.setErrMsg(detail.getEbStatusMsg());
                if (isUpdate) {
                    finSubscribeBill.set("returnmsg", (Object)detail.getEbStatusMsg());
                } else {
                    FinSubscribeHelper.setStatus(finSubscribeBill, detail, status);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finSubscribeBill});
        return ebResult;
    }

    private static void setStatus(DynamicObject finSubscribeBill, FinsubscribeDetail detail, BeBillStatusEnum status) {
        finSubscribeBill.set("bebankstatus", (Object)status.getValue());
        finSubscribeBill.set("returnmsg", (Object)detail.getEbStatusMsg());
        finSubscribeBill.set("lastmodifier", (Object)RequestContext.get().getCurrUserId());
        finSubscribeBill.set("lastmodifytime", (Object)new Date());
        finSubscribeBill.set("finservicestatus", (Object)FinSubscribeHelper.getFinServiceStatus(status));
    }

    private static void writeBackFinApply(DynamicObject finSubcribe) {
        DynamicObject sourceApply = TmcBotpHelper.getSourceBill((String)"cim_finsubscribe", (Object)finSubcribe.getPkValue(), (String)"cim_finapply");
        if (EmptyUtil.isNoEmpty((DynamicObject)sourceApply) && !finSubcribe.getBoolean("isrenewal")) {
            BigDecimal amount = finSubcribe.getBigDecimal("amount");
            BigDecimal oldAddAmount = sourceApply.getBigDecimal("addamount");
            BigDecimal addAmount = oldAddAmount.add(amount);
            sourceApply.set("addamount", (Object)addAmount);
            BigDecimal lastAmount = sourceApply.getBigDecimal("amount").subtract(addAmount);
            sourceApply.set("lastamount", (Object)lastAmount);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceApply});
        }
    }

    private static String getFinServiceStatus(BeBillStatusEnum status) {
        String finServiceStatus = "";
        switch (status) {
            case TS: {
                finServiceStatus = FinServiceStatusEnum.subscribe_done.getValue();
                break;
            }
            case TF: {
                finServiceStatus = FinServiceStatusEnum.subscribe_fail.getValue();
                break;
            }
            default: {
                finServiceStatus = FinServiceStatusEnum.subscribe_ing.getValue();
            }
        }
        return finServiceStatus;
    }

    private static void writeBackFinsubscribe(FinsubscribeDetail detail, DynamicObject finSubscribeBill) {
        if (EmptyUtil.isNoEmpty((String)detail.getBackAmount())) {
            finSubscribeBill.set("amount", (Object)FinSubscribeHelper.getBigDecima(detail.getBackAmount()));
        }
        finSubscribeBill.set("notifyid", (Object)detail.getEbSeqId());
        finSubscribeBill.set("reqnbr", (Object)detail.getBankFinancingSeqId());
        finSubscribeBill.set("securitiesaccno", (Object)detail.getSecuritiesAccNo());
        finSubscribeBill.set("contractno", (Object)detail.getReserved1());
        finSubscribeBill.set("subcontractno", (Object)detail.getReserved2());
        finSubscribeBill.set("traceno", (Object)detail.getReserved3());
    }

    public static Long getBankCateId(DynamicObject finSubscribeBill, String entityName) {
        DynamicObject bankAcct = null;
        switch (entityName) {
            case "cim_finsubscribe": {
                bankAcct = finSubscribeBill.getDynamicObject("settleaccount");
                break;
            }
            case "cim_redeem": {
                bankAcct = finSubscribeBill.getDynamicObject("recaccountf7");
            }
        }
        long bankCateId = 0L;
        if (bankAcct == null) {
            return bankCateId;
        }
        DynamicObject bank = bankAcct.getDynamicObject("bank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
            bank = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName(), (String)"bank_cate");
            bankCateId = bank.getDynamicObject("bank_cate").getLong("id");
        }
        return bankCateId;
    }

    public static BigDecimal getBigDecima(String convert) {
        if (EmptyUtil.isNoEmpty((String)convert)) {
            double convertDouble = Double.parseDouble(convert);
            return BigDecimal.valueOf(convertDouble);
        }
        return null;
    }

    public static void setProductFilter(BeforeF7SelectEvent evt, DynamicObject finOrg) {
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            return;
        }
        Optional<Long> bankCateOp = Optional.ofNullable(finOrg.getDynamicObject("bank_cate")).map(r -> r.getLong("id"));
        if (bankCateOp.isPresent()) {
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("bankcate", "=", (Object)bankCateOp.get()));
        }
    }

    public static void productChgEvt(IDataModel model) {
        DynamicObject product = (DynamicObject)model.getValue("product");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            return;
        }
        model.setValue("productno", (Object)product.getString("number"));
        model.setValue("productname", (Object)product.getString("name"));
        model.setValue("currency", (Object)product.getDynamicObject("currency"));
        model.setValue("revenuetype", (Object)product.getString("revenuetype"));
        String planRevenueStr = product.getString("planrevenue");
        model.setValue("planrevenue", (Object)FinSubscribeHelper.dealPlanRevenue(planRevenueStr));
        model.setValue("floatplanrevenue", (Object)product.getBigDecimal("floatplanrevenue"));
        String buyway = product.getString("buyway");
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)buyway) || StringUtils.equals((CharSequence)RedeemWayEnum.copies_redeem.getValue(), (CharSequence)buyway)) {
            model.setValue("redeemway", (Object)buyway);
        }
    }

    public static BigDecimal dealPlanRevenue(String planRevenueStr) {
        block3: {
            if (EmptyUtil.isNoEmpty((String)planRevenueStr)) {
                try {
                    return new BigDecimal(planRevenueStr.trim());
                }
                catch (Exception e) {
                    LOG.error("The planRevenueStr on Supermarket is:{}", (Object)planRevenueStr);
                    if (planRevenueStr.indexOf(45) <= 0) break block3;
                    String planReveNumber = planRevenueStr.substring(0, planRevenueStr.indexOf(45));
                    return new BigDecimal(planReveNumber.trim());
                }
            }
        }
        return BigDecimal.ZERO;
    }

    public static void fillValueEntry(DynamicObject finsubBill) {
        DynamicObjectCollection entry = finsubBill.getDynamicObjectCollection("valuationentry");
        if (null == entry) {
            return;
        }
        entry.clear();
        DynamicObject row = entry.addNew();
        row.set("e_valuationdate", (Object)finsubBill.getDate("purchasedate"));
        row.set("e_valuation", (Object)finsubBill.getBigDecimal("amount"));
    }

    public static void setBackColumnVals(DynamicObject finsubBill) {
        String billStatus = finsubBill.getString("billstatus");
        if (BillStatusEnum.isSave((String)billStatus) || BillStatusEnum.isSubmit((String)billStatus)) {
            String redeemWay = finsubBill.getString("redeemway");
            if (RedeemWayEnum.isCopiesRedeem(redeemWay)) {
                finsubBill.set("surpluscopies", (Object)finsubBill.getBigDecimal("buycopies"));
                finsubBill.set("surplusamount", null);
            } else {
                finsubBill.set("surplusamount", (Object)finsubBill.getBigDecimal("amount"));
                finsubBill.set("surpluscopies", null);
            }
        }
    }
}

