/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchHelper {
    public static void showIntRevBillForm(Object pkid, IFormView formView) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(pkid);
        parameter.setFormId("cim_intbill_revenue");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillStatus(BillOperationStatus.EDIT);
        parameter.setStatus(OperationStatus.VIEW);
        formView.showForm((FormShowParameter)parameter);
    }

    public static void showIntRevBillListForm(List<Long> collectId, IFormView formView) {
        QFilter qFilter = new QFilter("id", "in", collectId);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"cim_intbill_revenue", (boolean)true, (int)0, (boolean)false);
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        parameter.getCustomParams().put("clearExpireDate", "true");
        formView.showForm((FormShowParameter)parameter);
    }

    public static void loanIntDetailInfo(DynamicObject entry, AbstractFormPlugin formPlugin, IDataModel dataModel) {
        Object currency = entry.getDynamicObject("currency").getPkValue();
        String callIntStr = entry.getString("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("intstartdate", intDetail.getBeginDate());
            data.put("intenddate", intDetail.getEndDate());
            data.put("intentrydays", intDetail.getDays());
            data.put("intfinamount", intDetail.getPrinciple());
            data.put("planrevenuerate", intDetail.getRate());
            data.put("intcurrency", currency);
            data.put("convertdays", intDetail.getBasisDay());
            data.put("erevenueamount", intDetail.getAmount());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"intentry", (AbstractFormDataModel)((AbstractFormDataModel)dataModel), dataMap);
        formPlugin.getView().updateView("intentry");
    }

    public static boolean isAutoWriteRed(DynamicObject bill) {
        String param = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.CIM.getId(), (long)bill.getLong("org_id"), (String)"autoredwriteoff");
        return EmptyUtil.isNoEmpty((String)param) && StringUtils.equals((CharSequence)param, (CharSequence)"true");
    }
}

