/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.AmountEdit;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.SupermarketCardEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuperMarketHelper {
    public static final Long BANKCATEID_CMB = 544782186595789011L;
    public static final String BANKCATE_CMB = "BC-0031";
    public static final Long BANKCATEID_ABC = 544782186595789004L;
    public static final String BANKCATE_ABC = "BC-0024";
    public static final Long BANKCATEID_ICBC = 544782186595789003L;
    public static final String BANKCATE_ICBC = "BC-0023";
    public static final String CMB_BOOLEAN_COLUMN = "tercod,redctl,purctl,sbsctl,bnsctl";
    public static final String CMB_DATE_COLUMN = "navdat,sbsbdt,sbsedt,purbdt,puredt,redbdt,rededt";
    public static final String CMB_BANK_DETAIL_FIELD = "maacod,redctl,purctl,sbsctl,bnsctl,navdat,tercod,prfrat,terday,riptyp,qtybas,qtyhig,qtylow,sbsbdt,sbsedt,sbsprc,purbdt,puredt,redbdt,rededt,bnscnt,bnsamt,bnsqty";
    public static final String CMB_CARD_DETAIL_FIELD = "cmb_agency,cmb_redeemcontrol,cmb_subcontrol,cmb_applycontrol,cmb_bonuscontrol,cmb_pricedate,cmb_subscribemark,planrevenue,cmb_prdlimitinfo,cmb_prdtype,cmb_copybase,cmb_subamtceil,cmb_subamtfloor,cmb_applystartdate,cmb_applyenddate,cmb_applyprice,cmb_substartdate,cmb_subenddate,cmb_redeemstartdate,cmb_redeemenddate,cmb_bonuscount,cmb_bonusamt,cmb_bonuscopy";
    public static final String ABC_BANK_DETAIL_FIELD = "PrdDueDes,StartDate,EndDate,BuyStepAmt,SubscribStatus,PurchaseStatus,RedeemStatus,PrdOrg,PrdSaleSta,PrdBrand,SaleFrom,PurchaseAmt,StartAmt,StepAmt,TipAmt,PurchaseStepAmt,MktDate,UnitValue,TotValue,UnitBons,PftValue,DaysValue,YearValue,TotYearValue,CstnValue,TotCstnValue,MktBase";
    public static final String ABC_CARD_DETAIL_FIELD = "abc_term,abc_startdate,abc_untilldate,abc_redeembyamt,abc_applystat,abc_finsubstat,abc_redeemstat,abc_finorg,abc_bizstat,abc_prdname,abc_sellchannel,abc_applyrefamt,abc_compminamt,abc_compbyamt,abc_compmaxamt,abc_finsubminamt,abc_marketdate,abc_iopv,abc_totaliopv,abc_totalbonus,abc_perrevenue,abc_sevenrate,abc_yearrate,abc_yeartotalrate,abc_buildrate,abc_buildtotalrate,abc_achibase";
    public static final List ABC_TIMESTAMP_LIST = Arrays.asList("SStartDate", "SEndDate", "SStartTime", "SEndTime", "MStartDate", "MEndDate", "MStartTime", "MStopTime");
    public static final String ABC_DATE_COLUMN = "StartDate,EndDate,MktDate";

    public static boolean isTurnToBoolean(String bankField) {
        return CMB_BOOLEAN_COLUMN.indexOf(bankField) >= 0;
    }

    public static boolean isTurnToDate(String bankField, String fields) {
        return fields.indexOf(bankField) >= 0;
    }

    public static String turnBankFieldToCard(String bankField, String bankFieldStr, String cardFieldStr) {
        String[] bankFields = bankFieldStr.split(",");
        String[] cardFields = cardFieldStr.split(",");
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        for (int i = 0; i < bankFields.length; ++i) {
            fieldMap.put(bankFields[i], cardFields[i]);
        }
        return (String)fieldMap.get(bankField);
    }

    public static String getBankCardEntity(DynamicObject bankCate) {
        String bankCateNo = Optional.ofNullable(bankCate).map(r -> r.getString("number")).orElse("");
        SupermarketCardEnum cardEnum = SupermarketCardEnum.getEnumByBankCateNo(bankCateNo);
        return EmptyUtil.isNoEmpty((Object)((Object)cardEnum)) ? cardEnum.getCardEntity() : "";
    }

    public static DataEntityPropertyCollection getBankCardProperty(String bankCateNo) {
        SupermarketCardEnum cardEnum = SupermarketCardEnum.getEnumByBankCateNo(bankCateNo);
        return EmptyUtil.isNoEmpty((Object)((Object)cardEnum)) ? MetadataServiceHelper.getDataEntityType((String)cardEnum.getCardEntity()).getProperties() : new DynamicPropertyCollection();
    }

    public static DynamicObjectCollection getPrdCardCollection(String bankCateNo) {
        DynamicObjectCollection prdCols = StringUtil.equals((String)BANKCATE_CMB, (String)bankCateNo) ? QueryServiceHelper.query((String)"cim_market_cmb", (String)"id,cmb_listdate,cmb_untilldate,cmb_agency", null) : new DynamicObjectCollection();
        return prdCols;
    }

    public static String getBankCateNo(Long bankCateId) {
        DynamicObject bankCateBill = QueryServiceHelper.queryOne((String)"bd_bankcgsetting", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankCateId)});
        if (EmptyUtil.isEmpty((DynamicObject)bankCateBill)) {
            return "";
        }
        return bankCateBill.getString("number");
    }

    public static void bindValues(IDataModel model, Map<String, Object> paraMap, String columnPrefix) {
        if (EmptyUtil.isNoEmpty(paraMap)) {
            for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(columnPrefix) && !"currency".equals(key)) continue;
                model.setValue(key, entry.getValue());
            }
        }
    }

    public static void addAmountTips(IFormView view, IDataModel model) {
        DynamicObject product = (DynamicObject)model.getValue("product");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            return;
        }
        DynamicObject bankCate = product.getDynamicObject("bankcate");
        if (EmptyUtil.isEmpty((DynamicObject)bankCate)) {
            return;
        }
        String cardEntity = SuperMarketHelper.getBankCardEntity(bankCate);
        long prdCardId = product.getLong("prdcardid");
        if (StringUtils.isNotEmpty((CharSequence)cardEntity)) {
            DynamicObject cardBill = TmcDataServiceHelper.loadSingle((String)cardEntity, (String)SuperMarketHelper.getCardSelectPropByEntity(cardEntity), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)prdCardId)});
            if (EmptyUtil.isEmpty((DynamicObject)cardBill)) {
                return;
            }
            AmountEdit amountEdit = (AmountEdit)view.getControl("amount");
            amountEdit.addTips(SuperMarketHelper.buildDynamicTips(cardEntity, cardBill));
        }
    }

    public static String getCardSelectPropByEntity(String cardEntity) {
        String selectProp = "";
        if (StringUtils.equals((CharSequence)"cim_market_icbc", (CharSequence)cardEntity)) {
            selectProp = "icbc_minbuyamt";
        } else if (StringUtils.equals((CharSequence)"cim_market_cmb", (CharSequence)cardEntity)) {
            selectProp = "cmb_subamtfloor,cmb_subamtceil,cmb_copybase";
        } else if (StringUtils.equals((CharSequence)"cim_market_abc", (CharSequence)cardEntity)) {
            selectProp = "abc_compminamt,abc_compmaxamt";
        }
        return selectProp;
    }

    public static String getCardPropByEntityWhenRedeem(String cardEntity) {
        String selectProp = "";
        if (StringUtils.equals((CharSequence)"cim_market_icbc", (CharSequence)cardEntity)) {
            selectProp = "icbc_mincopy";
        } else if (StringUtils.equals((CharSequence)"cim_market_cmb", (CharSequence)cardEntity)) {
            selectProp = "cmb_redeemfloor,cmb_redeemceil";
        } else if (StringUtils.equals((CharSequence)"cim_market_abc", (CharSequence)cardEntity)) {
            selectProp = "abc_redeemminamt,abc_redeemmaxamt";
        }
        return selectProp;
    }

    public static Tips buildDynamicTips(String cardEntity, DynamicObject cardBill) {
        Tips tips = new Tips();
        tips.setType("text");
        String content = "";
        if (StringUtils.equals((CharSequence)"cim_market_icbc", (CharSequence)cardEntity)) {
            content = String.format(ResManager.loadKDString((String)"\u6700\u4f4e\uff1a%1$s", (String)"SuperMarketHelper_4", (String)"tmc-cim-common", (Object[])new Object[0]), SuperMarketHelper.tripBigDecimalZero(cardBill.getBigDecimal("icbc_minbuyamt")));
        } else if (StringUtils.equals((CharSequence)"cim_market_cmb", (CharSequence)cardEntity)) {
            content = String.format(ResManager.loadKDString((String)"\u6700\u4f4e\uff1a%1$s\uff0c\u6700\u9ad8\uff1a%2$s\uff0c\u57fa\u6570\uff1a%3$s", (String)"SuperMarketHelper_5", (String)"tmc-cim-common", (Object[])new Object[0]), SuperMarketHelper.tripBigDecimalZero(cardBill.getBigDecimal("cmb_subamtfloor")), SuperMarketHelper.tripBigDecimalZero(cardBill.getBigDecimal("cmb_subamtceil")), SuperMarketHelper.tripBigDecimalZero(cardBill.getBigDecimal("cmb_copybase")));
        } else if (StringUtils.equals((CharSequence)"cim_market_abc", (CharSequence)cardEntity)) {
            content = String.format(ResManager.loadKDString((String)"\u6700\u4f4e\uff1a%1$s\uff0c\u6700\u9ad8\uff1a%2$s", (String)"SuperMarketHelper_7", (String)"tmc-cim-common", (Object[])new Object[0]), SuperMarketHelper.tripBigDecimalZero(cardBill.getBigDecimal("abc_compminamt")), SuperMarketHelper.tripBigDecimalZero(cardBill.getBigDecimal("abc_compmaxamt")));
        }
        tips.setContent(new LocaleString(content));
        return tips;
    }

    public static String tripBigDecimalZero(BigDecimal data) {
        return data.stripTrailingZeros().toPlainString();
    }

    public static List<String> getValidateProductCardMsgs(DynamicObject finApply, String columnPrefix) {
        ArrayList<String> errMsgList = new ArrayList<String>(8);
        DynamicObject product = finApply.getDynamicObject(columnPrefix + "product");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            return errMsgList;
        }
        String cardEntity = SuperMarketHelper.getBankCardEntity(product.getDynamicObject("bankcate"));
        if (EmptyUtil.isEmpty((String)cardEntity)) {
            return errMsgList;
        }
        String selectProps = SuperMarketHelper.getCardSelectPropByEntity(cardEntity);
        DynamicObject prdCardBill = TmcDataServiceHelper.loadSingle((String)cardEntity, (String)selectProps, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)product.getLong("prdcardid"))});
        if (EmptyUtil.isEmpty((DynamicObject)prdCardBill)) {
            return errMsgList;
        }
        BigDecimal amount = finApply.getBigDecimal(columnPrefix + "amount");
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            return errMsgList;
        }
        switch (cardEntity) {
            case "cim_market_icbc": {
                BigDecimal minBuyAmt = prdCardBill.getBigDecimal("icbc_minbuyamt");
                if (amount.compareTo(minBuyAmt) >= 0) break;
                errMsgList.add(ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u201c\u4ea7\u54c1\u8d2d\u4e70\u8d77\u70b9\u91d1\u989d\u201d\u3002", (String)"SuperMarketHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]));
                break;
            }
            case "cim_market_cmb": {
                int copybase;
                BigDecimal floorAmt = prdCardBill.getBigDecimal("cmb_subamtfloor");
                BigDecimal ceilAmt = prdCardBill.getBigDecimal("cmb_subamtceil");
                if (amount.compareTo(floorAmt) < 0 || amount.compareTo(ceilAmt) > 0) {
                    errMsgList.add(ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d\u5fc5\u987b\u5728\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u201c\u7533\u8d2d\u91d1\u989d\u4e0b\u9650\u201d\u4e0e\u201c\u7533\u8d2d\u91d1\u989d\u4e0a\u9650\u201d\u4e4b\u95f4\u3002", (String)"SuperMarketHelper_2", (String)"tmc-cim-common", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((Integer)(copybase = prdCardBill.getInt("cmb_copybase")))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u4ea4\u6613\u4efd\u989d\u57fa\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuperMarketHelper_6", (String)"tmc-cim-common", (Object[])new Object[0]));
                }
                BigDecimal surpAmt = amount.divide(new BigDecimal(copybase), 10, RoundingMode.HALF_DOWN);
                if (new BigDecimal(surpAmt.intValue()).compareTo(surpAmt) == 0) break;
                errMsgList.add(ResManager.loadKDString((String)"\u8d2d\u4e70\u62db\u5546\u94f6\u884c\u7406\u8d22\u4ea7\u54c1\u65f6\uff0c\u7406\u8d22\u91d1\u989d\u5fc5\u987b\u4e3a\u57fa\u6570\u7684\u500d\u6570\u3002", (String)"SuperMarketHelper_3", (String)"tmc-cim-common", (Object[])new Object[0]));
                break;
            }
            case "cim_market_abc": {
                BigDecimal floorAmt = prdCardBill.getBigDecimal("abc_compminamt");
                BigDecimal ceilAmt = prdCardBill.getBigDecimal("abc_compmaxamt");
                if (amount.compareTo(floorAmt) >= 0 && amount.compareTo(ceilAmt) <= 0) break;
                errMsgList.add(ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d\u5fc5\u987b\u5728\u8be5\u7406\u8d22\u4ea7\u54c1\u7684\u201c\u5bf9\u516c\u8d77\u70b9\u91d1\u989d\u201d\u4e0e\u201c\u5bf9\u516c\u5355\u7b14\u6700\u9ad8\u9650\u989d\u201d\u4e4b\u95f4\u3002", (String)"SuperMarketHelper_8", (String)"tmc-cim-common", (Object[])new Object[0]));
                break;
            }
        }
        return errMsgList;
    }

    public static Long getBankCateId(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        List bankCateList = QueryServiceHelper.queryPrimaryKeys((String)"bd_bankcgsetting", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isNoEmpty((Object)bankCateList)) {
            return (Long)bankCateList.get(0);
        }
        return 0L;
    }

    public static Date getFormatDate(String dateStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = dateFormat.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getFormatDate(String dateStr, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date date = dateFormat.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Integer getPageSizeFromDB() {
        String queryStr = "SELECT FPAGESIZE FROM T_CIM_PAGEINQUIRYSET WHERE FID=1548802534507072520";
        Integer pageSize = (Integer)DB.query((DBRoute)DBRouteConst.TMC, (String)queryStr, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet resultSet) throws Exception {
                Integer size = 0;
                while (resultSet.next()) {
                    size = resultSet.getInt(1);
                }
                return size;
            }
        });
        return pageSize;
    }

    public static String getBankLoginFromDB(Long bankCateId) {
        String queryStr = "SELECT FINTERFACE FROM T_CIM_INTERFACESET WHERE FBANKCATE=?";
        String bankLogin = (String)DB.query((DBRoute)DBRouteConst.TMC, (String)queryStr, (Object[])new Object[]{bankCateId}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                String finterface = "";
                while (resultSet.next()) {
                    finterface = resultSet.getString(1);
                }
                return finterface;
            }
        });
        return bankLogin;
    }

    public static List<Object> getBankCate() {
        ArrayList<Object> bankCateList = new ArrayList<Object>();
        DataSet rows = QueryServiceHelper.queryDataSet((String)"", (String)"cim_supermarket", (String)"bankcate", null, null, (int)-1);
        DataSet bankCateDs = rows.distinct();
        bankCateDs.forEach(r -> bankCateList.add(r.get("bankcate")));
        return bankCateList;
    }

    public static Long getBankCateIdByInterFace(String bankLogin) {
        String queryStr = "SELECT FBANKCATE FROM T_CIM_INTERFACESET WHERE FINTERFACE=?";
        Long bankCateId = (Long)DB.query((DBRoute)DBRouteConst.TMC, (String)queryStr, (Object[])new Object[]{bankLogin}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                Long loginIn = 0L;
                while (resultSet.next()) {
                    loginIn = resultSet.getLong(1);
                }
                return loginIn;
            }
        });
        return bankCateId;
    }

    public static void setValueWhenNotNull(DynamicObject bill, String prop, Object value) {
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        bill.set(prop, value);
    }
}

