/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.service.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.enums.ProfitCycleEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.RevenueStatEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.cim.common.service.deposit.DepositCalcIntService;
import kd.tmc.cim.common.service.deposit.DepositReleaseHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.factory.PlanCallStragetyFactory;

public class DepositIntPlanService {
    private static final String REVENUE_PROPS = "id,sourcebillid,revenuesort,bizdate,prestenddate,prestartdate,prestenddate,actpreinstamt,entrys.inststartdate,entrys.instenddate,entrys.instdays,entrys.instprincipalamt,entrys.rate,entrys.ratetrandays,entrys.instamt";
    private static final DepositCalcIntService depositCalcIntService = new DepositCalcIntService();

    public void resetRevenueProjectEntry(List<DynamicObject> depositBills, String operateKey) {
        Map<Long, List<DynamicObject>> revenueBillMap = this.getRevenueBillMap(depositBills);
        Map<Long, List<PlanCallResult>> releasePlanMap = DepositReleaseHelper.getAllReleasePlanMap(depositBills);
        for (DynamicObject depositBill : depositBills) {
            depositBill.getDynamicObjectCollection("revenue_entry").clear();
            long depositId = depositBill.getLong("id");
            List revenueBills = revenueBillMap.getOrDefault(depositId, new ArrayList());
            this.dealRevenueDonePart(depositBill, revenueBills, operateKey);
            this.dealRevenueWillDoPart(depositBill, releasePlanMap.get(depositId));
        }
    }

    private Map<Long, List<DynamicObject>> getRevenueBillMap(List<DynamicObject> depositBills) {
        List depositIds = depositBills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("sourcebillid", "in", depositIds));
        DynamicObject[] revenueBillColl = TmcDataServiceHelper.load((String)"cim_dptrevenue", (String)REVENUE_PROPS, (QFilter[])qFilter.toArray(), (String)"bizdate");
        return Arrays.stream(revenueBillColl).collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
    }

    public void resetRevenueProjectEntry(DynamicObject depositBill) {
        this.resetRevenueProjectEntry(depositBill, "");
    }

    public void resetRevenueProjectEntry(DynamicObject depositBill, String operateKey) {
        this.resetRevenueProjectEntry(Collections.singletonList(depositBill), operateKey);
    }

    private List<PlanCallResult> buildIntPlanList(DynamicObject depositBill) {
        ArrayList<PlanCallResult> intPlanList = new ArrayList<PlanCallResult>(8);
        if (depositBill.getBoolean("handinstplan")) {
            DynamicObjectCollection entrys = depositBill.getDynamicObjectCollection("revenue_entry");
            for (DynamicObject entry : entrys) {
                Date reveDate = entry.getDate("revenuedate");
                if (EmptyUtil.isEmpty((Object)reveDate)) continue;
                PlanCallResult callResult = new PlanCallResult();
                callResult.setBizDate(reveDate);
                intPlanList.add(callResult);
            }
        }
        return intPlanList.stream().sorted(Comparator.comparing(PlanCallResult::getBizDate)).collect(Collectors.toList());
    }

    private void dealRevenueWillDoPart(DynamicObject depositBill, List<PlanCallResult> repayPlanList) {
        if (depositBill.getBigDecimal("surplusamount").compareTo(BigDecimal.ZERO) == 0) {
            depositBill.set("planamount", (Object)BigDecimal.ZERO);
            return;
        }
        List<PlanCallResult> intPlanList = this.buildIntPlanList(depositBill);
        String period = Optional.ofNullable(depositBill.getDynamicObject("revenueproject")).map(r -> r.getString("period")).orElse("");
        if (EmptyUtil.isEmpty((String)period) || EmptyUtil.isEmpty(intPlanList) && ProfitCycleEnum.isCustom(period)) {
            return;
        }
        Date startDate = DepositHelper.getIntCalcStartDate(depositBill);
        List<IntBillInfo> intBillList = this.calcDepositBillIntWithRevProject(depositBill, startDate, intPlanList, repayPlanList);
        this.setRevenueEntry(depositBill, intBillList);
    }

    private void dealRevenueDonePart(DynamicObject depositBill, List<DynamicObject> revenueBills, String operateKey) {
        DynamicObjectCollection revenueEntry = depositBill.getDynamicObjectCollection("revenue_entry");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("sourcebillid", "=", depositBill.getPkValue()));
        Optional<Date> lastMaxRevDateOp = revenueBills.stream().filter(r -> RevenueSortEnum.revenue.getValue().equals(r.getString("revenuesort"))).map(r -> r.getDate("prestenddate")).max(Date::compareTo);
        if (lastMaxRevDateOp.isPresent()) {
            depositBill.set("lastrevenuedate", (Object)lastMaxRevDateOp.get());
        } else {
            depositBill.set("lastrevenuedate", null);
        }
        Date lstPayIntDate = DepositIntPlanService.getLastPreIntDate(depositBill);
        depositBill.set("endpreinstdate", (Object)lstPayIntDate);
        if (EmptyUtil.isEmpty((BigDecimal)depositBill.getBigDecimal("surplusamount")) && !"substract".equals(operateKey)) {
            List redepositRev = revenueBills.stream().filter(r -> RevenueSortEnum.redeposit_revenue.getValue().equals(r.getString("revenuesort"))).map(r -> r.getDate("prestenddate")).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(redepositRev)) {
                depositBill.set("lastrevenuedate", redepositRev.get(0));
            } else if (!FinServiceStatusEnum.isSubscribeNorevenue(depositBill.getString("bizstatus"))) {
                Date lastRedeemDate = depositBill.getDate("lastredeemdate");
                Date lastRevenueDate = EmptyUtil.isNoEmpty((Object)lastRedeemDate) ? DateUtils.getLastDay((Date)lastRedeemDate, (int)1) : lastRedeemDate;
                depositBill.set("lastrevenuedate", (Object)lastRevenueDate);
            }
        }
        boolean isInit = depositBill.getBoolean("isinit");
        BigDecimal handRevenueAmt = depositBill.getBigDecimal("handrevenueamt");
        int handCount = 0;
        if (EmptyUtil.isEmpty(revenueBills) && isInit && EmptyUtil.isNoEmpty((BigDecimal)handRevenueAmt)) {
            DynamicObject row = revenueEntry.addNew();
            row.set("seq", (Object)handCount++);
            row.set("revenueseq", (Object)revenueEntry.size());
            Date lastRevenueDate = depositBill.getDate("handlastrevenuedate");
            row.set("revenuedate", (Object)lastRevenueDate);
            row.set("revenuecalamount", (Object)depositBill.getBigDecimal("handrevenueamt"));
            row.set("revenuestate", (Object)RevenueStatEnum.DONE.getValue());
        }
        for (int i = 0; i < revenueBills.size(); ++i) {
            DynamicObject revenueRow = revenueEntry.addNew();
            DynamicObject revenuedBill = revenueBills.get(i);
            revenueRow.set("seq", (Object)(i + handCount + 1));
            revenueRow.set("revenueseq", (Object)(i + handCount + 1));
            revenueRow.set("revenuedate", (Object)revenuedBill.getDate("bizdate"));
            revenueRow.set("revenuecalamount", (Object)revenuedBill.getBigDecimal("actpreinstamt"));
            revenueRow.set("revenuestate", (Object)RevenueStatEnum.DONE.getValue());
            DynamicObjectCollection revenueSubEntry = revenueRow.getDynamicObjectCollection("revenue_subentry");
            revenueSubEntry.clear();
            DynamicObjectCollection entrys = revenuedBill.getDynamicObjectCollection("entrys");
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject realRevRow = (DynamicObject)entrys.get(j);
                DynamicObject revenueSubRow = revenueSubEntry.addNew();
                revenueSubRow.set("seq", (Object)(j + 1));
                revenueSubRow.set("startdate", (Object)realRevRow.getDate("inststartdate"));
                revenueSubRow.set("enddate", (Object)realRevRow.getDate("instenddate"));
                revenueSubRow.set("days", (Object)realRevRow.getInt("instdays"));
                revenueSubRow.set("finamount", (Object)realRevRow.getBigDecimal("instprincipalamt"));
                revenueSubRow.set("eplanrevenue", (Object)realRevRow.getBigDecimal("rate"));
                revenueSubRow.set("convertdays", (Object)realRevRow.getInt("ratetrandays"));
                revenueSubRow.set("erevenueamount", (Object)realRevRow.getBigDecimal("instamt"));
            }
        }
    }

    private void setRevenueEntry(DynamicObject depositBill, List<IntBillInfo> intBillList) {
        DynamicObjectCollection revenueEntry = depositBill.getDynamicObjectCollection("revenue_entry");
        BigDecimal planAmt = BigDecimal.ZERO;
        int seq = revenueEntry.size() + 1;
        for (IntBillInfo intBill : intBillList) {
            DynamicObject interestEntryDO = revenueEntry.addNew();
            Date interestDate = intBill.getBizDate();
            BigDecimal interestAmount = intBill.getAmount();
            interestEntryDO.set("seq", (Object)seq++);
            interestEntryDO.set("revenueseq", (Object)revenueEntry.size());
            interestEntryDO.set("revenuedate", (Object)interestDate);
            interestEntryDO.set("revenuecalamount", (Object)interestAmount);
            interestEntryDO.set("revenuestate", (Object)RevenueStatEnum.NOTDO.getValue());
            planAmt = planAmt.add(interestAmount);
            List details = intBill.getDetails();
            DynamicObjectCollection interestSubEntry = interestEntryDO.getDynamicObjectCollection("revenue_subentry");
            interestSubEntry.clear();
            for (IntBillDetailInfo detail : details) {
                Date beginDate = detail.getBeginDate();
                Date endDate = detail.getEndDate();
                int days = detail.getDays();
                BigDecimal principle = detail.getPrinciple();
                BigDecimal yearRate = detail.getRate();
                BigDecimal rateAmount = detail.getAmount();
                DynamicObject interestSubEntryDO = interestSubEntry.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("startdate", (Object)beginDate);
                interestSubEntryDO.set("enddate", (Object)endDate);
                interestSubEntryDO.set("days", (Object)days);
                interestSubEntryDO.set("finamount", (Object)principle);
                interestSubEntryDO.set("eplanrevenue", (Object)yearRate);
                interestSubEntryDO.set("convertdays", (Object)detail.getBasisDay());
                interestSubEntryDO.set("erevenueamount", (Object)rateAmount);
            }
        }
        depositBill.set("planamount", (Object)planAmt);
    }

    private List<IntBillInfo> calcDepositBillIntWithRevProject(DynamicObject depositBill, Date beginDate, List<PlanCallResult> intPlanList, List<PlanCallResult> repayPlanList) {
        if (EmptyUtil.isEmpty(intPlanList)) {
            Date endDate = Optional.ofNullable(depositBill.getDate("expiredate")).orElseGet(() -> DateUtils.getNextYear((Date)beginDate, (int)1));
            intPlanList = this.callIntPlan(depositBill, beginDate, endDate);
        }
        return this.genIntPlan(depositBill, beginDate, repayPlanList, intPlanList);
    }

    private List<PlanCallResult> callIntPlan(DynamicObject depositBill, Date beginDate, Date endDate) {
        RepayPlanCallRequest callRequest = new RepayPlanCallRequest();
        callRequest.setBeginDate(beginDate).setEndDate(endDate).setRepayWay(RepaymentWayEnum.dqhbdqhx);
        callRequest.setSchemeInfo(this.trans2IntSchemeInfo(depositBill));
        List planCallResults = PlanCallStragetyFactory.createRevenuePlanCallStragety().createPlan(callRequest);
        String depositEntity = depositBill.getDynamicObjectType().getName();
        if ("cim_noticedeposit".equals(depositEntity) || "ifm_notice_deposit".equals(depositEntity)) {
            return planCallResults;
        }
        return RevenueCalcHelper.updateBizDateByPayIntAdjustRule(depositBill, planCallResults);
    }

    private RepaySchemeInfo trans2IntSchemeInfo(DynamicObject depositBill) {
        DynamicObject schemeObj = depositBill.getDynamicObject("revenueproject");
        if (schemeObj == null) {
            return null;
        }
        if ((schemeObj = TmcDataServiceHelper.loadSingleFromCache((Object)schemeObj.getLong("id"), (String)"cim_profitscheme")) == null) {
            return null;
        }
        RepaySchemeEnum repaySchemeEnum = RepaySchemeEnum.getByValue((String)schemeObj.getString("period"));
        if (repaySchemeEnum == null) {
            return null;
        }
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        schemeInfo.setRepayScheme(repaySchemeEnum);
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)schemeObj.getString("month")));
        String day = schemeObj.getString("day");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        schemeInfo.setOffetDay(Integer.valueOf(schemeObj.getInt("offetday")));
        if (schemeObj.containsProperty("days")) {
            schemeInfo.setDays(Integer.valueOf(schemeObj.getInt("days")));
        }
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(schemeObj.getBoolean("drawmonthsettle")));
        return schemeInfo;
    }

    private List<IntBillInfo> genIntPlan(DynamicObject deposit, Date beginDate, List<PlanCallResult> repayPlanList, List<PlanCallResult> intPlanList) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<IntBillInfo> list = new ArrayList<IntBillInfo>();
        DynamicObject productFactory = deposit.getDynamicObject("productfactory");
        for (int index = 0; index < intPlanList.size(); ++index) {
            PlanCallResult intPlan = intPlanList.get(index);
            IntBillInfo intBill = depositCalcIntService.calcDepositBillInt(deposit, beginDate, intPlan.getBizDate(), repayPlanList);
            if (EmptyUtil.isNoEmpty((Object)intBill)) {
                totalAmt = totalAmt.add(intBill.getAmount());
                if (EmptyUtil.isNoEmpty((BigDecimal)intBill.getAmount())) {
                    list.add(intBill);
                }
            }
            if (intPlan.getBizDate().after(beginDate)) {
                beginDate = intPlan.getBizDate();
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)productFactory) || !"cash".equals(productFactory.getString("profittype"))) continue;
            IntHTRuleEnum htRule = IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule"));
            if (IntHTRuleEnum.headtail == htRule) {
                beginDate = DateUtils.getNextDay((Date)beginDate, (int)1);
                continue;
            }
            if (IntHTRuleEnum.noheadnotail != htRule) continue;
            beginDate = DateUtils.getLastDay((Date)beginDate, (int)1);
        }
        return list;
    }

    private static Date getLastPreIntDate(DynamicObject depositBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", depositBill.getPkValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        qFilter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        DynamicObjectCollection intPreCols = QueryServiceHelper.query((String)"cim_depositpreint", (String)"bizdate", (QFilter[])qFilter.toArray(), (String)"bizdate desc");
        Date lstPayIntDate = EmptyUtil.isNoEmpty((DynamicObjectCollection)intPreCols) ? ((DynamicObject)intPreCols.get(0)).getDate("bizdate") : (depositBill.getBoolean("accepttransfer") && EmptyUtil.isNoEmpty((Object)depositBill.getDate("transferdate")) ? DateUtils.getLastDay((Date)depositBill.getDate("transferdate"), (int)1) : depositBill.getDate("handendpredate"));
        Date minDate = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
        Date lstDate1 = Optional.ofNullable(lstPayIntDate).orElse(minDate);
        Date lstDate2 = Optional.ofNullable(depositBill.getDate("lastrevenuedate")).orElse(minDate);
        lstPayIntDate = lstDate1.compareTo(lstDate2) >= 0 ? lstDate1 : lstDate2;
        lstPayIntDate = lstPayIntDate.compareTo(minDate) == 0 ? null : lstPayIntDate;
        return lstPayIntDate;
    }
}

