/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.service.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeCalcIntHelper {
    private static final String SELECT_FIELDS = "finbillno,isrevenue,redeemdate,amount";

    public static DynamicObject getFinSubBill(Long finBillId) {
        return TmcDataServiceHelper.loadSingle((Object)finBillId, (String)CimEntityEnum.cim_finsubscribe.getValue());
    }

    public static List<DynamicObject> getFinSubBills(List<Long> finBillIds) {
        DynamicObject[] bills = TmcDataServiceHelper.load((Object[])finBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)CimEntityEnum.cim_finsubscribe.getValue()));
        return Arrays.asList(bills);
    }

    public static BigDecimal getIntCallPrinciple(DynamicObject finBill) {
        return finBill.getBigDecimal("amount");
    }

    public static Date getIntBeginDate(DynamicObject finBill) {
        Date beginDate = FinSubscribeCalcIntHelper.getStartIntDate(finBill);
        Date lastIntDate = finBill.getDate("endinstdate");
        if (EmptyUtil.isNoEmpty((Object)lastIntDate)) {
            beginDate = DateUtils.getNextDay((Date)lastIntDate, (int)1);
        }
        return beginDate;
    }

    public static Date getStartIntDate(DynamicObject finBill) {
        String redeemWay = finBill.getString("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            return finBill.getDate("valuedate");
        }
        return finBill.getDate("intdate");
    }

    public static List<PlanCallResult> getAllRepayPlanList(DynamicObject finBill) {
        Map<Long, List<PlanCallResult>> planListMap = FinSubscribeCalcIntHelper.getAllRepayPlanMap(Collections.singletonList(finBill));
        return planListMap.values().iterator().next();
    }

    public static List<PlanCallResult> getAllRepayPlanListForReport(DynamicObject finBill, Date endDate) {
        DynamicObjectCollection redeemBills = FinSubscribeCalcIntHelper.getRedeemBills(Collections.singletonList(finBill));
        List<DynamicObject> redeemList = redeemBills.stream().filter(r -> r.getDate("redeemdate").compareTo(endDate) <= 0).collect(Collectors.toList());
        return FinSubscribeCalcIntHelper.getPlanCallResultsForReport(redeemList);
    }

    public static Map<Long, List<PlanCallResult>> getAllRepayPlanMap(List<DynamicObject> finBills) {
        HashMap<Long, List<PlanCallResult>> result = new HashMap<Long, List<PlanCallResult>>(8);
        DynamicObjectCollection redeemBills = FinSubscribeCalcIntHelper.getRedeemBills(finBills);
        Map<Long, List<DynamicObject>> redeemBillMap = redeemBills.stream().collect(Collectors.groupingBy(r -> r.getLong("finbillno")));
        for (DynamicObject finBill : finBills) {
            long finBillId = finBill.getLong("id");
            List<Object> redeemBillList = redeemBillMap.get(finBillId);
            if (redeemBillList == null) {
                redeemBillList = Collections.emptyList();
            }
            result.put(finBillId, FinSubscribeCalcIntHelper.getPlanCallResults(redeemBillList));
        }
        return result;
    }

    public static List<PlanCallResult> getPlanCallResults(List<DynamicObject> redeemBills) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(redeemBills.size());
        for (DynamicObject redeemBill : redeemBills) {
            PlanCallResult info = new PlanCallResult();
            info.setPayInt(redeemBill.getBoolean("isrevenue"));
            info.setBizDate(redeemBill.getDate("redeemdate"));
            info.setPrinciple(redeemBill.getBigDecimal("amount"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    public static List<PlanCallResult> getPlanCallResultsForReport(List<DynamicObject> redeemBills) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(redeemBills.size());
        for (DynamicObject redeemBill : redeemBills) {
            PlanCallResult info = new PlanCallResult();
            info.setPayInt(false);
            info.setBizDate(redeemBill.getDate("redeemdate"));
            info.setPrinciple(redeemBill.getBigDecimal("amount"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    private static String getTradeChannel(String tradeChannel) {
        return TradeChannelEnum.isOnLine(tradeChannel) ? TradeChannelEnum.ONLINE.getValue() : TradeChannelEnum.OFFLINE.getValue();
    }

    public static DynamicObjectCollection getRedeemBills(List<DynamicObject> finBills) {
        List finBillIds = finBills.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("finbillno", "in", finBillIds);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter online = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        online.and(new QFilter("bebankstatus", "=", (Object)BebankStatusEnum.TS.getValue()));
        QFilter tradeChannel = online.or(new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue()));
        filter.and(tradeChannel);
        return QueryServiceHelper.query((String)CimEntityEnum.cim_redeem.getValue(), (String)SELECT_FIELDS, (QFilter[])filter.toArray());
    }

    public static Set<RateInfo> getRateList(DynamicObject finBill) {
        HashSet<RateInfo> rateList = new HashSet<RateInfo>();
        DynamicObjectCollection rates = finBill.getDynamicObjectCollection("rateadjust_entry");
        for (DynamicObject rate : rates) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate(rate.getDate("ra_effectdate"));
            info.setRate(rate.getBigDecimal("ra_yearrate"));
            rateList.add(info);
        }
        return rateList;
    }
}

