/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.service.finsubscribe;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.cim.common.service.InterestCalcParam;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;

public class FinSubscribeCalcIntService {
    public IntBillInfo calcFinSubBillInt(Long finBillId, Date beginDate, Date endDate) {
        DynamicObject finBill = FinSubscribeCalcIntHelper.getFinSubBill(finBillId);
        List<PlanCallResult> repayPlanList = FinSubscribeCalcIntHelper.getAllRepayPlanList(finBill);
        return this.calcFinSubBillInt(finBill, beginDate, endDate, repayPlanList);
    }

    public IntBillInfo calcFinSubBillIntForReport(Long finBillId, Date beginDate, Date endDate) {
        DynamicObject finBill = FinSubscribeCalcIntHelper.getFinSubBill(finBillId);
        List<PlanCallResult> repayPlanList = FinSubscribeCalcIntHelper.getAllRepayPlanListForReport(finBill, endDate);
        return this.calcFinSubBillInt(finBill, beginDate, endDate, repayPlanList);
    }

    public IntBillInfo calcFinSubBillInt(DynamicObject finBill, Date beginDate, Date endDate, List<PlanCallResult> repayPlanList) {
        beginDate = this.getBeginDate(beginDate, finBill);
        BigDecimal principle = FinSubscribeCalcIntHelper.getIntCallPrinciple(finBill);
        return this.callFinBillInt(finBill, repayPlanList, beginDate, endDate, principle);
    }

    private Date getBeginDate(Date beginDate, DynamicObject finBill) {
        if (EmptyUtil.isEmpty((Object)beginDate) && EmptyUtil.isNoEmpty((Object)(beginDate = finBill.getDate("endinstdate")))) {
            beginDate = DateUtils.getNextDay((Date)beginDate, (int)1);
        }
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            beginDate = finBill.getDate("intdate");
        }
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            beginDate = finBill.getDate("valuedate");
        }
        return beginDate;
    }

    public Map<Long, IntBillInfo> batchCalcFinSubBillInt(List<Long> finBillIds, Date beginDate, Date endDate) {
        HashMap<Long, IntBillInfo> intBillMap = new HashMap<Long, IntBillInfo>(finBillIds.size());
        List<DynamicObject> finBills = FinSubscribeCalcIntHelper.getFinSubBills(finBillIds);
        Map<Long, DynamicObject> finBillMap = finBills.stream().collect(Collectors.toMap(f -> f.getLong("id"), f -> f));
        Map<Long, List<PlanCallResult>> repayPlanMap = FinSubscribeCalcIntHelper.getAllRepayPlanMap(finBills);
        for (Long finBillId : finBillIds) {
            DynamicObject finSubBill = finBillMap.get(finBillId);
            if (finSubBill == null) continue;
            IntBillInfo billInfo = this.calcFinSubBillInt(finSubBill, beginDate, endDate, repayPlanMap.get(finBillId));
            intBillMap.put(finBillId, billInfo);
        }
        return intBillMap;
    }

    public IntBillInfo calcFinSubBillInt(Long finBillId, Date endDate, BigDecimal repayAmt) {
        DynamicObject finBill = FinSubscribeCalcIntHelper.getFinSubBill(finBillId);
        Date beginDate = finBill.getDate("endinstdate");
        beginDate = EmptyUtil.isEmpty((Object)beginDate) ? finBill.getDate("intdate") : DateUtils.getNextDay((Date)beginDate, (int)1);
        return this.callFinBillInt(finBill, null, beginDate, endDate, repayAmt);
    }

    private IntBillInfo callFinBillInt(DynamicObject finBill, List<PlanCallResult> repayList, Date beginDate, Date endDate, BigDecimal principle) {
        Date callDate;
        Set<RateInfo> rateList = FinSubscribeCalcIntHelper.getRateList(finBill);
        Date expireDate = finBill.getDate("expiredate");
        Date date = callDate = EmptyUtil.isNoEmpty((Object)expireDate) && endDate.after(expireDate) ? expireDate : endDate;
        if (repayList != null && !repayList.isEmpty()) {
            repayList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        }
        InterestCalcParam param = InterestCalcParam.build(repayList, rateList, beginDate, callDate, principle);
        return this.calcFinSubBillInt(finBill, param);
    }

    public IntBillInfo calcFinSubBillInt(DynamicObject finBill, InterestCalcParam param) {
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(param.getRepayPlanList());
        BizBillInfo bizBill = this.getBizBill(finBill, param);
        request.setBizBill(bizBill);
        request.setRateList(param.getRateList());
        this.verifyInput(request);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)RepaymentWayEnum.zdyhk);
        return stragety.callInt(request);
    }

    private BizBillInfo getBizBill(DynamicObject finBill, InterestCalcParam param) {
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(param.getPrinciple());
        bizBill.setBeginDate(param.getBeginDate());
        bizBill.setEndDate(param.getEndDate());
        if (EmptyUtil.isNoEmpty((DynamicObject)finBill.getDynamicObject("revenueproject"))) {
            bizBill.setIntSchemeId(finBill.getDynamicObject("revenueproject").getLong("id"));
        }
        bizBill.setRepayWay(param.getRepayWay());
        bizBill.setBasis(BasisEnum.getEnum((String)finBill.getString("basis")));
        if (EmptyUtil.isNoEmpty((DynamicObject)finBill.getDynamicObject("currency"))) {
            bizBill.setCurrencyId(finBill.getDynamicObject("currency").getLong("id"));
        }
        bizBill.setSettleIntMode(SettleIntModeEnum.gdpljx);
        DynamicObject productFactory = finBill.getDynamicObject("productfactory");
        bizBill.setHtRule(param.getIntHTRule());
        bizBill.setRound(RoundRuleEnum.rounded);
        bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        bizBill.setPeriod(param.getPeriod());
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            Optional.ofNullable(productFactory.getString("intheadtailrule")).filter(r -> EmptyUtil.isNoEmpty((String)r)).ifPresent(r -> bizBill.setHtRule(IntHTRuleEnum.valueOf((String)r)));
            Optional.ofNullable(productFactory.getString("introundrule")).filter(r -> EmptyUtil.isNoEmpty((String)r)).ifPresent(r -> bizBill.setRound(RoundRuleEnum.valueOf((String)r)));
            Optional.ofNullable(productFactory.getString("intcalmethod")).filter(r -> EmptyUtil.isNoEmpty((String)r)).ifPresent(r -> bizBill.setIntCalMethod(IntCalMethodEnum.valueOf((String)r)));
        }
        return bizBill;
    }

    private void verifyInput(IntCalRequest request) {
        boolean hasEffectiveRate = false;
        for (RateInfo rate : request.getRateList()) {
            if (rate.getEffectiveDate().compareTo(request.getBizBill().getBeginDate()) > 0) continue;
            hasEffectiveRate = true;
            break;
        }
        if (!hasEffectiveRate) {
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u5fc5\u987b\u8981\u6709\u53ef\u7528\u5229\u7387\u3002", (String)"RevenueCalcHelper_0", (String)"tmc-cim-common", (Object[])new Object[0])});
        }
    }
}

