/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.service.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cim.common.enums.ProfitCycleEnum;
import kd.tmc.cim.common.service.InterestCalcParam;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntHelper;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntService;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.inst.plan.RevenuePlanCallStragety;
import org.apache.commons.lang3.tuple.Pair;

public class FinSubscribeIntPlanService {
    private static final FinSubscribeCalcIntService finSubscribeCalcIntService = new FinSubscribeCalcIntService();

    public Pair<BigDecimal, List<IntBillInfo>> callIntPlan(DynamicObject finBill) {
        return this.callIntPlanByPreInt(finBill, null);
    }

    private Pair<BigDecimal, List<IntBillInfo>> genIntPlan(DynamicObject finBill, List<PlanCallResult> intPlanList, Date beginDate) {
        BigDecimal principle = FinSubscribeCalcIntHelper.getIntCallPrinciple(finBill);
        List<PlanCallResult> repayPlanList = FinSubscribeCalcIntHelper.getAllRepayPlanList(finBill);
        return this.genIntPlan(finBill, repayPlanList, intPlanList, principle, beginDate);
    }

    public Pair<BigDecimal, List<IntBillInfo>> callIntPlanByPreInt(DynamicObject finBill, Boolean isPreInt) {
        return this.callIntPlanByPreInt(finBill, isPreInt, null);
    }

    public Pair<BigDecimal, List<IntBillInfo>> callIntPlanByPreInt(DynamicObject finBill, Boolean isPreInt, List<PlanCallResult> repayPlanList) {
        List<PlanCallResult> intPlanList;
        Date beginDate = FinSubscribeCalcIntHelper.getIntBeginDate(finBill);
        Date endDate = finBill.getDate("expiredate");
        if (EmptyUtil.isEmpty((Object)endDate)) {
            endDate = TermHelper.getDateByBaseDate4ymd((String)"1y", (Date)DateUtils.getCurrentDate());
        }
        DynamicObjectCollection entrys = finBill.getDynamicObjectCollection("revenue_entry");
        if (finBill.getBoolean("handreveplan") && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            intPlanList = new ArrayList<PlanCallResult>(entrys.size());
            for (DynamicObject entry : entrys) {
                PlanCallResult callResult = new PlanCallResult();
                callResult.setBizDate(entry.getDate("revenuedate"));
                intPlanList.add(callResult);
            }
        } else {
            intPlanList = this.callIntPlan(finBill, endDate);
        }
        BigDecimal principle = FinSubscribeCalcIntHelper.getIntCallPrinciple(finBill);
        if (repayPlanList == null) {
            repayPlanList = FinSubscribeCalcIntHelper.getAllRepayPlanList(finBill);
        }
        if (isPreInt != null) {
            repayPlanList.forEach(r -> r.setPayInt(isPreInt.booleanValue()));
        }
        return this.genIntPlan(finBill, repayPlanList, intPlanList, principle, beginDate);
    }

    public Pair<BigDecimal, List<IntBillInfo>> callIntPlanByHand(DynamicObject finBill, List<PlanCallResult> intPlanList) {
        Date beginDate = FinSubscribeCalcIntHelper.getIntBeginDate(finBill);
        return this.genIntPlan(finBill, intPlanList, beginDate);
    }

    private List<PlanCallResult> callIntPlan(DynamicObject finBill, Date endDate) {
        RepayPlanCallRequest request = new RepayPlanCallRequest();
        DynamicObject revenueSchema = finBill.getDynamicObject("revenueproject");
        if (EmptyUtil.isNoEmpty((DynamicObject)revenueSchema)) {
            DynamicObject schemeObj = TmcDataServiceHelper.loadSingleFromCache((Object)revenueSchema.getLong("id"), (String)"cim_profitscheme");
            if (schemeObj == null) {
                return Collections.emptyList();
            }
            ProfitCycleEnum repaySchemeEnum = ProfitCycleEnum.getEnumByValue(schemeObj.getString("period"));
            if (repaySchemeEnum == null || repaySchemeEnum == ProfitCycleEnum.CUSTOM) {
                return Collections.emptyList();
            }
            RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
            schemeInfo.setRepayScheme(RepaySchemeEnum.getByValue((String)repaySchemeEnum.getType()));
            schemeInfo.setRepayMonths(ListUtils.strToIntList((String)schemeObj.getString("month")));
            String day = schemeObj.getString("day");
            if (EmptyUtil.isNotBlank((CharSequence)day)) {
                schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
            }
            schemeInfo.setOffetDay(Integer.valueOf(schemeObj.getInt("offetday")));
            schemeInfo.setDays(Integer.valueOf(schemeObj.getInt("days")));
            schemeInfo.setRepayMonthSettle(Boolean.valueOf(schemeObj.getBoolean("drawmonthsettle")));
            request.setSchemeInfo(schemeInfo);
        }
        Date beginDate = FinSubscribeCalcIntHelper.getIntBeginDate(finBill);
        request.setBeginDate(beginDate).setEndDate(endDate).setRepayWay(RepaymentWayEnum.zdyhk).setBalanceList(Collections.emptyList()).setSettleIntMode(SettleIntModeEnum.gdpljx);
        List planCallResults = new RevenuePlanCallStragety().createPlan(request);
        return this.updateBizDateByPayIntAdjustRule(finBill, planCallResults);
    }

    private Pair<BigDecimal, List<IntBillInfo>> genIntPlan(DynamicObject finBill, List<PlanCallResult> repayPlanList, List<PlanCallResult> intPlanList, BigDecimal principle, Date stateDate) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<IntBillInfo> list = new ArrayList<IntBillInfo>();
        DynamicObject productFactory = finBill.getDynamicObject("productfactory");
        Set<RateInfo> rateList = FinSubscribeCalcIntHelper.getRateList(finBill);
        intPlanList = intPlanList.stream().sorted(Comparator.comparing(PlanCallResult::getBizDate)).collect(Collectors.toList());
        block4: for (int index = 0; index < intPlanList.size(); ++index) {
            PlanCallResult intPlan = (PlanCallResult)intPlanList.get(index);
            InterestCalcParam calcParam = InterestCalcParam.build(repayPlanList, rateList, stateDate, intPlan.getBizDate(), principle).setPeriod(index + 1);
            IntBillInfo intBill = finSubscribeCalcIntService.calcFinSubBillInt(finBill, calcParam);
            if (EmptyUtil.isNoEmpty((Object)intBill)) {
                totalAmt = totalAmt.add(intBill.getAmount());
                if (EmptyUtil.isNoEmpty((BigDecimal)intBill.getAmount())) {
                    list.add(intBill);
                }
            }
            if (intPlan.getBizDate().after(stateDate)) {
                stateDate = intPlan.getBizDate();
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)productFactory) || !"cash".equals(productFactory.getString("profittype"))) continue;
            IntHTRuleEnum htRule = IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule"));
            switch (htRule) {
                case headtail: {
                    stateDate = DateUtils.getNextDay((Date)stateDate, (int)1);
                    continue block4;
                }
                case noheadnotail: {
                    stateDate = DateUtils.getLastDay((Date)stateDate, (int)1);
                    continue block4;
                }
            }
        }
        return Pair.of((Object)totalAmt, list);
    }

    public List<PlanCallResult> updateBizDateByPayIntAdjustRule(DynamicObject loanBill, List<PlanCallResult> callResults) {
        if (EmptyUtil.isEmpty(callResults)) {
            return callResults;
        }
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        if (productFactory == null) {
            return callResults;
        }
        String revenueRule = productFactory.getString("revenueadjustrule");
        if (EmptyUtil.isBlank((CharSequence)revenueRule) || AdjustMethodEnum.no_adjust.getValue().equals(revenueRule)) {
            return callResults;
        }
        DynamicObjectCollection workCalendars = loanBill.getDynamicObjectCollection("workcalendar");
        if (workCalendars == null) {
            return callResults;
        }
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)revenueRule);
        Map<Date, PlanCallResult> datePlanMap = callResults.stream().collect(Collectors.toMap(PlanCallResult::getBizDate, r -> r, (r1, r2) -> r1));
        for (PlanCallResult callResult : callResults) {
            Date adjustBizDate;
            Date bizDate = callResult.getBizDate();
            if (bizDate.compareTo(adjustBizDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)bizDate, (AdjustMethodEnum)adjustMethod)) == 0) continue;
            datePlanMap.remove(bizDate);
            callResult.setBizDate(adjustBizDate);
            datePlanMap.put(adjustBizDate, callResult);
        }
        ArrayList<PlanCallResult> intPlanList = new ArrayList<PlanCallResult>(datePlanMap.values());
        intPlanList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        return intPlanList;
    }
}

