/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.apply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.cim.common.enums.BonusWayEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplySchemeBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit productFactoryEdit = (BasedataEdit)this.getControl("c_productfactory");
        productFactoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountEdit = (BasedataEdit)this.getControl("c_finaccountf7");
        accountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleAccount = (BasedataEdit)this.getControl("c_settleaccount");
        settleAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"c_finaccount"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "c_amount": {
                this.calByFinAmount();
                this.callPlanAmount();
                this.syncCardInfo(propName);
                break;
            }
            case "c_finorginfo": 
            case "c_productno": 
            case "c_name": 
            case "c_planamount": {
                this.syncCardInfo(propName);
                break;
            }
            case "c_redeemway": {
                this.redeemWayChgEvt();
                break;
            }
            case "c_expiredate": {
                this.expireDateChgEvt();
                break;
            }
            case "c_valuedate": {
                this.valueDateChgEvt((Date)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "c_term": {
                this.termChgEvt((String)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "c_buycopies": {
                this.calByFinCopies();
                break;
            }
            case "c_iopv": {
                this.calByFinIopv();
                break;
            }
            case "c_productfactory": {
                this.productFactoryChgEvt();
                break;
            }
            case "c_planrevenue": 
            case "c_basis": {
                this.callPlanAmount();
                break;
            }
            case "c_intdate": {
                this.intDateChgEvt((Date)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "finaccountf7": {
                this.finAcctChgEvt();
                break;
            }
            case "c_finaccount": {
                this.setCardEntryValue("c_finaccountf7", null);
                break;
            }
            case "currency": {
                if (!((Boolean)this.getModel().getValue("inquiry")).booleanValue()) break;
                int rowCount = this.getModel().getEntryRowCount("s_entry");
                for (int i = 0; i < rowCount; ++i) {
                    this.getModel().setValue("s_currency", this.getModel().getValue("currency"), i);
                }
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"c_finaccount")) {
            BasedataEdit finAccountF7 = (BasedataEdit)this.getControl("finaccountf7");
            finAccountF7.click();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int currRowIndex = e.getRowDataEntities()[0].getRowIndex();
        if (currRowIndex < 0) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl("s_entry");
        cardEntry.selectCard(Integer.valueOf(currRowIndex));
        if (!CollectionUtils.isEmpty((Collection)this.getModel().getDataEntity(true).getDynamicObjectCollection("s_entry"))) {
            long schemeId = DB.genLongId((String)"cim_finscheme");
            int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"s_schemeid", (Object)schemeId, (int)rowIndex);
            this.setCardEntryValue("c_schemeid", schemeId);
            DynamicObject finScheme = TmcDataServiceHelper.newDynamicObject((String)"cim_finscheme");
            finScheme.set("id", (Object)schemeId);
            String orgId = ((DynamicObject)this.getModel().getValue("org")).getString("id");
            String finSchemeBillNo = CodeRuleServiceHelper.getNumber((String)"cim_finscheme", (DynamicObject)finScheme, (String)orgId);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"s_number", (Object)finSchemeBillNo, (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"s_currency", (Object)this.getModel().getValue("currency"), (int)rowIndex);
            this.setCardEntryValue("c_number", finSchemeBillNo);
        }
    }

    public void syncCardInfo(String propName) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("s_entry", rowIndex);
        Object value = ((DynamicObject)cardEntry.getDynamicObjectCollection("c_entry").get(0)).get(propName);
        this.getModel().setValue(propName.replace("c_", "s_"), value, rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"c_finaccountf7", (CharSequence)propName) || StringUtils.equals((CharSequence)"c_settleaccount", (CharSequence)propName)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            showParameter.getListFilterParameter().getQFilters().add(TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id")));
        } else if ("c_productfactory".equals(propName)) {
            if (EmptyUtil.isEmpty((Object)this.getCardEntryValue("c_investvarieties"))) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u8d44\u54c1\u79cd\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinApplySchemeBillEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject investVarieties = (DynamicObject)this.getCardEntryValue("c_investvarieties");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("investvarieties", "=", investVarieties.getPkValue()));
        }
    }

    private void calcTerm() {
        Date startdate = (Date)this.getCardEntryValue("c_valuedate");
        Date expiredate = (Date)this.getCardEntryValue("c_expiredate");
        if (null == startdate || null == expiredate) {
            return;
        }
        String term = DateUtils.getDiff_ymd((Date)startdate, (Date)expiredate);
        this.setCardEntryValue("c_term", term);
    }

    private boolean checkExpireDate() {
        Date expireDate = (Date)this.getCardEntryValue("c_expiredate");
        Date valueDate = (Date)this.getCardEntryValue("c_valuedate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)valueDate) && valueDate.after(expireDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7406\u8d22\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7406\u8d22\u5f00\u59cb\u65e5\u3002", (String)"FinApplySchemeBillEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.setCardEntryValue("c_expiredate", null);
            return false;
        }
        return true;
    }

    private boolean checkTermIsRight(String oldValue) {
        String term = (String)this.getCardEntryValue("c_term");
        boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term);
        if (!rightFormat) {
            this.setCardEntryValue("c_term", oldValue);
        }
        return rightFormat;
    }

    private void calExpireDate() {
        Date startdate = (Date)this.getCardEntryValue("c_valuedate");
        String termStr = (String)this.getCardEntryValue("c_term");
        if (null == startdate || EmptyUtil.isEmpty((String)termStr)) {
            this.setCardEntryValue("c_expiredate", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", null);
            return;
        }
        this.setCardEntryValue("c_expiredate", TermHelper.getDateByTerm((String)termStr, (Date)startdate));
    }

    private void calFinAmount() {
        String redeemWay = (String)this.getCardEntryValue("c_redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal buyCopies = (BigDecimal)this.getCardEntryValue("c_buycopies");
            BigDecimal iopv = (BigDecimal)this.getCardEntryValue("c_iopv");
            BigDecimal amount = iopv.multiply(buyCopies);
            this.setCardEntryValue("c_amount", amount);
            this.syncCardInfo("c_amount");
        }
        this.callPlanAmount();
    }

    private void expireDateChgEvt() {
        Date intDate;
        if (this.checkExpireDate()) {
            this.calcTerm();
        }
        Date expireDate = (Date)this.getCardEntryValue("c_expiredate");
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)((String)this.getCardEntryValue("c_redeemway"))) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate = (Date)this.getCardEntryValue("c_intdate"), expireDate}) && intDate.after(expireDate)) {
            this.setCardEntryValue("c_intdate", this.getCardEntryValue("c_valuedate"));
        }
        this.callPlanAmount();
    }

    private void valueDateChgEvt(Date oldValue) {
        Date intDate;
        Date valueDate = (Date)this.getCardEntryValue("c_valuedate");
        if (EmptyUtil.isEmpty((Object)valueDate)) {
            return;
        }
        Date expiredate = (Date)this.getCardEntryValue("c_expiredate");
        if (EmptyUtil.isNoEmpty((Object)expiredate) && expiredate.before(valueDate)) {
            valueDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7406\u8d22\u5f00\u59cb\u65e5\u4e0d\u80fd\u5927\u4e8e\u7406\u8d22\u5230\u671f\u65e5\u3002", (String)"FinApplySchemeBillEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.setCardEntryValue("c_valuedate", valueDate);
        }
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)((String)this.getCardEntryValue("c_redeemway"))) && (EmptyUtil.isEmpty((Object)(intDate = (Date)this.getCardEntryValue("c_intdate"))) || intDate.before(valueDate))) {
            this.setCardEntryValue("c_intdate", valueDate);
        }
        this.calcTerm();
        this.callPlanAmount();
    }

    private void productFactoryChgEvt() {
        DynamicObject productFactory = (DynamicObject)this.getCardEntryValue("c_productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)productFactory)) {
            return;
        }
        String basis = EmptyUtil.isNoEmpty((String)productFactory.getString("basis")) ? productFactory.getString("basis") : BasisEnum.Actual_360.getValue();
        this.setCardEntryValue("c_basis", basis);
        this.callPlanAmount();
        String profitType = productFactory.getString("profittype");
        String redeemWay = StringUtils.equals((CharSequence)profitType, (CharSequence)"cash") ? "amount_redeem" : "copies_redeem";
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        this.getModel().setValue("c_redeemway", (Object)redeemWay, 0, parentRowIndex.intValue());
    }

    private void termChgEvt(String oldValue) {
        if (this.checkTermIsRight(oldValue)) {
            this.calExpireDate();
            this.callPlanAmount();
        }
    }

    private void callPlanAmount() {
        DynamicObject callObject = TmcDataServiceHelper.newDynamicObject((String)"cim_finapply");
        callObject.set("amount", this.getCardEntryValue("c_amount"));
        callObject.set("planrevenue", this.getCardEntryValue("c_planrevenue"));
        callObject.set("valuedate", this.getCardEntryValue("c_valuedate"));
        callObject.set("redeemway", this.getCardEntryValue("c_redeemway"));
        callObject.set("expiredate", this.getCardEntryValue("c_expiredate"));
        callObject.set("basis", this.getCardEntryValue("c_basis"));
        callObject.set("intdate", this.getCardEntryValue("c_intdate"));
        callObject.set("productfactory", this.getCardEntryValue("c_productfactory"));
        BigDecimal planAmount = RedeemBillHelper.calPlanAmount((ModelAgent)new ModelAgent((Object)callObject));
        this.setCardEntryValue("c_planamount", planAmount);
        this.syncCardInfo("c_planamount");
    }

    private Object getCardEntryValue(String propName) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        return this.getModel().getValue(propName, 0, parentRowIndex.intValue());
    }

    private void setCardEntryValue(String propName, Object value) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)value, (int)0, (int)parentRowIndex);
    }

    private void intDateChgEvt(Date oldValue) {
        Date expireDate;
        Date intDate = (Date)this.getCardEntryValue("c_intdate");
        if (EmptyUtil.isEmpty((Object)intDate)) {
            return;
        }
        Date valueDate = (Date)this.getCardEntryValue("c_valuedate");
        if (EmptyUtil.isNoEmpty((Object)valueDate) && intDate.before(valueDate)) {
            intDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u7406\u8d22\u5f00\u59cb\u65e5\u3002", (String)"FinSchemeInfoEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.setCardEntryValue("c_intdate", intDate);
        }
        if (EmptyUtil.isNoEmpty((Object)(expireDate = (Date)this.getCardEntryValue("c_expiredate"))) && intDate.after(expireDate)) {
            intDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u5927\u4e8e\u7406\u8d22\u5230\u671f\u65e5\u3002", (String)"FinSchemeInfoEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.setCardEntryValue("c_intdate", intDate);
        }
    }

    private void redeemWayChgEvt() {
        this.calFinAmount();
        String redeemWay = (String)this.getCardEntryValue("c_redeemway");
        if (StringUtils.equals((CharSequence)redeemWay, (CharSequence)RedeemWayEnum.amount_redeem.getValue())) {
            this.setCardEntryValue("c_bonusway", BonusWayEnum.amount_bonus.getValue());
            this.setCardEntryValue("c_buycopies", 0);
            this.setCardEntryValue("c_iopv", 0);
        } else {
            this.setCardEntryValue("c_bonusway", BonusWayEnum.copies_bonus.getValue());
            this.setCardEntryValue("c_revenueproject", null);
            this.setCardEntryValue("c_intdate", null);
        }
    }

    private void finAcctChgEvt() {
        if (((Boolean)this.getModel().getValue("inquiry")).booleanValue()) {
            DynamicObject finAcct = (DynamicObject)this.getModel().getValue("finaccountf7");
            if (EmptyUtil.isNoEmpty((DynamicObject)finAcct)) {
                this.setCardEntryValue("c_finaccountf7", finAcct.getPkValue());
                this.setCardEntryValue("c_finaccount", finAcct.getString("number"));
                this.setCardEntryValue("c_finorginfo", finAcct.getDynamicObject("bank"));
            }
            this.getModel().setDataChanged(false);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finaccountf7", null);
        }
    }

    private void calByFinAmount() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        String redeemWay = (String)this.getModel().getValue("c_redeemway", 0, rowIndex);
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("c_amount", 0, rowIndex);
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("c_buycopies", 0, rowIndex);
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("c_iopv", 0, rowIndex);
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, buyCopies})) {
                iopv = amount.divide(buyCopies, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"c_iopv", (Object)iopv, (int)0, (int)rowIndex);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, iopv})) {
                buyCopies = amount.divide(iopv, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"c_buycopies", (Object)buyCopies, (int)0, (int)rowIndex);
            }
        }
    }

    private void calByFinCopies() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        String redeemWay = (String)this.getModel().getValue("c_redeemway", 0, rowIndex);
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("c_amount", 0, rowIndex);
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("c_buycopies", 0, rowIndex);
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("c_iopv", 0, rowIndex);
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, buyCopies})) {
                iopv = amount.divide(buyCopies, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"c_iopv", (Object)iopv, (int)0, (int)rowIndex);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCopies, iopv})) {
                amount = iopv.multiply(buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"c_amount", (Object)amount, (int)0, (int)rowIndex);
                this.calFinAmount();
            }
        }
    }

    private void calByFinIopv() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        String redeemWay = (String)this.getModel().getValue("c_redeemway", 0, rowIndex);
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("c_amount", 0, rowIndex);
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("c_buycopies", 0, rowIndex);
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("c_iopv", 0, rowIndex);
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, iopv})) {
                buyCopies = amount.divide(iopv, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"c_buycopies", (Object)buyCopies, (int)0, (int)rowIndex);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCopies, iopv})) {
                amount = iopv.multiply(buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"c_amount", (Object)amount, (int)0, (int)rowIndex);
                this.calFinAmount();
            }
        }
    }
}

