/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.model.interest.IntBillInfo;

public class DepositAuto2ReleaseConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        String entityName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendData : dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(entityName)) {
            DynamicObject releaseBill = extendData.getDataEntity();
            BigDecimal releaseAmt = releaseBill.getBigDecimal("amount");
            IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)releaseBill, (boolean)false);
            DepositHelper.addRevenueCalDetailEntry((DynamicObjectCollection)releaseBill.getDynamicObjectCollection("entrys"), (List)intBillInfo.getDetails());
            BigDecimal rateAmt = intBillInfo.getAmount().setScale(releaseBill.getDynamicObject("currency").getInt("amtprecision"), RoundingMode.HALF_UP);
            releaseBill.set("realrevenue", (Object)rateAmt);
            releaseBill.set("totalamount", (Object)releaseAmt.add(rateAmt));
            BigDecimal redepositAmt = releaseAmt;
            if (StringUtils.equals((CharSequence)ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue(), (CharSequence)releaseBill.getString("expireredeposit"))) {
                redepositAmt = releaseBill.getBigDecimal("totalamount");
            }
            releaseBill.set("redepositamount", (Object)redepositAmt);
        }
    }
}

