/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDeal2ReleaseConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        String entityName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendData : dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(entityName)) {
            DynamicObject releaseBill = extendData.getDataEntity();
            this.dealValidateAndAcceptTransfer(releaseBill);
            this.setReleaseType(releaseBill);
            DepositHelper.setDepositRateWhenFloat((DynamicObject)releaseBill);
            this.resetRedeemDate(releaseBill);
            DepositHelper.setReleaseBillValue((DynamicObject)releaseBill);
        }
    }

    private void setReleaseType(DynamicObject releaseBill) {
        String investType = Optional.ofNullable(releaseBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isNotice((String)investType)) {
            releaseBill.set("releasetype", (Object)ReleaseTypeEnum.agreeon.getValue());
        } else if (InvestTypeEnum.isFixed((String)investType)) {
            releaseBill.set("releasetype", (Object)ReleaseTypeEnum.expire.getValue());
        }
    }

    private void dealValidateAndAcceptTransfer(DynamicObject releaseBill) {
        long releaseDoingNum;
        QFilter qFilter = new QFilter("sourcebillid", "=", releaseBill.get("sourcebillid"));
        DynamicObjectCollection existsReleaseCols = QueryServiceHelper.query((String)"cim_release", (String)"id,billstatus", (QFilter[])qFilter.toArray(), (String)"", (int)-1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)existsReleaseCols) && (releaseDoingNum = existsReleaseCols.stream().filter(r -> !BillStatusEnum.isAudit((String)r.getString("billstatus"))).count()) >= 1L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5176\u4ed6\u5728\u9014\u7684\u89e3\u6d3b\u5355\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"DepositDeal2ReleaseConvertPlugin_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        }
    }

    private void resetRedeemDate(DynamicObject releaseBill) {
        String releaseEntity = releaseBill.getDynamicObjectType().getName();
        if (!"cim_release".equals(releaseEntity) && !"ifm_release".equals(releaseEntity)) {
            return;
        }
        Optional<DynamicObject> prdFactoryOp = Optional.ofNullable(releaseBill.getDynamicObject("finbillno")).map(r -> r.getDynamicObject("productfactory"));
        if (!prdFactoryOp.isPresent()) {
            return;
        }
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle((String)"cim_deposit", (String)"workcalendar,expiredate,productfactory", (QFilter[])new QFilter[]{new QFilter("id", "=", releaseBill.getDynamicObject("finbillno").getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        DynamicObjectCollection workCalendarCols = depositBill.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendarCols)) {
            return;
        }
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)depositBill.getDynamicObject("productfactory").getString("graceadjustrule"));
        Date adjustExpireDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendarCols, (Date)depositBill.getDate("expiredate"), (AdjustMethodEnum)adjustMethod);
        releaseBill.set("redeemdate", (Object)adjustExpireDate);
        releaseBill.set("accountdate", (Object)adjustExpireDate);
    }
}

