/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplyBill2RedeemBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject redeemBill = dataEntity.getDataEntity();
            Long srcId = (Long)redeemBill.get("sourcebillid");
            DynamicObject finApply = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName());
            DynamicObject finSubscribe = finApply.getDynamicObject("finsubscribe");
            redeemBill.set("finbillno", (Object)finSubscribe);
            String redeemWay = finApply.getString("redeemway");
            if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
                int copies = finApply.getInt("redemptioncopies");
                int surplusCopies = finSubscribe.getInt("surpluscopies");
                redeemBill.set("surpluscopies", (Object)(surplusCopies - copies));
                BigDecimal srcIopv = Optional.ofNullable(finSubscribe.getBigDecimal("iopv")).orElse(BigDecimal.ZERO);
                BigDecimal revenueAmt = redeemBill.getBigDecimal("amount").subtract(srcIopv.multiply(redeemBill.getBigDecimal("copies")));
                redeemBill.set("realrevenue", (Object)revenueAmt);
            } else {
                BigDecimal amount = finApply.getBigDecimal("redemptionamount");
                BigDecimal surplusAmount = finSubscribe.getBigDecimal("surplusamount");
                redeemBill.set("surplusamount", (Object)surplusAmount.subtract(amount));
            }
            DynamicObject settleAccount = finSubscribe.getDynamicObject("settleaccount");
            if (EmptyUtil.isEmpty((DynamicObject)settleAccount)) {
                redeemBill.set("recaccount", (Object)finSubscribe.getString("finaccount"));
                redeemBill.set("recaccountf7", (Object)finSubscribe.getString("finaccountf7"));
            } else {
                redeemBill.set("recaccount", (Object)finSubscribe.getString("settleaccount.bankaccountnumber"));
                redeemBill.set("recaccountf7", (Object)finSubscribe.getDynamicObject("settleaccount"));
            }
            if (RedeemWayEnum.isAmountRedeem((String)redeemWay) && finApply.getBigDecimal("planamount").compareTo(BigDecimal.ZERO) != 0) {
                redeemBill.set("isrevenue", (Object)true);
                redeemBill.set("realrevenue", finApply.get("planamount"));
            }
            QFilter qFilter = new QFilter("finbillno", "=", finSubscribe.getPkValue());
            DynamicObjectCollection lastRedeem = QueryServiceHelper.query((String)CimEntityEnum.cim_redeem.getValue(), (String)"redeemdate,count", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)1);
            redeemBill.set("count", (Object)1);
            if (!lastRedeem.isEmpty()) {
                redeemBill.set("lastredeemdate", (Object)((DynamicObject)lastRedeem.get(0)).getDate("redeemdate"));
                redeemBill.set("count", (Object)(((DynamicObject)lastRedeem.get(0)).getInt("count") + 1));
            }
            this.setRenewalAmount(redeemBill, finSubscribe);
        }
    }

    private void setRenewalAmount(DynamicObject redeemBill, DynamicObject finSubscribe) {
        boolean isRenewal = redeemBill.getBoolean("isrenewal");
        BigDecimal renewalAmount = BigDecimal.ZERO;
        if (isRenewal) {
            boolean isRollCapital = redeemBill.getBoolean("isrollcapital");
            renewalAmount = finSubscribe.getBigDecimal("amount");
            if (isRollCapital) {
                BigDecimal realRevenue = redeemBill.getBigDecimal("realrevenue");
                renewalAmount = renewalAmount.add(realRevenue);
            }
        }
        redeemBill.set("renewalamount", (Object)renewalAmount);
    }
}

