/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeBill2RevenueBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(FinSubscribeBill2RevenueBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String descEntity = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity);
        Map variables = this.getOption().getVariables();
        String status = (String)variables.get("billstatus");
        logger.info("billstatus = " + status);
        for (ExtendedDataEntity dataEntity : billDataEntitys) {
            IntBillInfo intBill;
            DynamicObject revenueBill = dataEntity.getDataEntity();
            if ("submit".equals(status) || "audit".equals(status)) {
                revenueBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            } else {
                revenueBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            }
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Long srcId = (Long)((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)srcRow);
            DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName());
            revenueBill.set("finbillno", (Object)finSubscribe);
            Date endInstDate = finSubscribe.getDate("endinstdate");
            Date revenueStartDate = EmptyUtil.isEmpty((Object)endInstDate) ? finSubscribe.getDate("intdate") : DateUtils.getNextDay((Date)endInstDate, (int)1);
            revenueBill.set("revenuestartdate", (Object)revenueStartDate);
            Date endDate = DateUtils.getCurrentDate();
            Date expireDate = finSubscribe.getDate("expiredate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && endDate.compareTo(expireDate) > 0) {
                endDate = expireDate;
            }
            Date revenueEndDate = DateUtils.getLastDay((Date)endDate, (int)1);
            revenueBill.set("revenueenddate", (Object)revenueEndDate);
            revenueBill.set("expiredate", (Object)endDate);
            if (EmptyUtil.isNoEmpty((Object)revenueStartDate) && EmptyUtil.isNoEmpty((Object)revenueEndDate)) {
                revenueBill.set("revenuedays", (Object)DateUtils.getDiffDays((Date)revenueStartDate, (Date)revenueEndDate));
            }
            if ((intBill = RevenueCalcHelper.callInt((Long)((Long)finSubscribe.getPkValue()), (Date)revenueStartDate, (Date)endDate)) == null) continue;
            revenueBill.set("amount", (Object)intBill.getAmount());
            revenueBill.set("revenueamount", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = revenueBill.getDynamicObjectCollection("entrys");
            if (!EmptyUtil.isNoEmpty((Object)intBill.getDetails())) continue;
            RevenueCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
            Integer revDays = intBill.getDetails().stream().map(r -> r.getDays()).reduce(0, Integer::sum);
            revenueBill.set("revenuedays", (Object)revDays);
        }
    }
}

