/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinsubAuto2RedeemConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extDataEntities;
        for (ExtendedDataEntity extData : extDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().getName())) {
            BigDecimal redeemAmt;
            DynamicObject redeemBill = extData.getDataEntity();
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemBill.getString("redeemway"))) {
                if (redeemBill.getBoolean("isrevenue")) {
                    BigDecimal revenueAmt = this.calRevenue(redeemBill);
                    redeemBill.set("revenueamount", (Object)revenueAmt);
                    redeemBill.set("realrevenue", (Object)revenueAmt);
                    redeemBill.set("ispushrev", (Object)Boolean.TRUE);
                }
            } else if (redeemBill.getBoolean("isrenewal")) {
                redeemBill.set("renewalcopies", (Object)redeemBill.getBigDecimal("copies"));
                redeemBill.set("renewaliopv", (Object)redeemBill.getBigDecimal("iopv"));
            }
            if (!redeemBill.getBoolean("isrenewal")) continue;
            BigDecimal reFinsubAmt = redeemAmt = redeemBill.getBigDecimal("amount");
            if (redeemBill.getBoolean("isrollcapital")) {
                BigDecimal revenueAmt = redeemBill.getBigDecimal("realrevenue");
                reFinsubAmt = redeemAmt.add(revenueAmt);
            }
            redeemBill.set("renewalamount", (Object)reFinsubAmt);
        }
    }

    private BigDecimal calRevenue(DynamicObject redeemBill) {
        IntBillInfo intBill;
        Date redeemDate = redeemBill.getDate("redeemdate");
        DynamicObject finsubBill = redeemBill.getDynamicObject("finbillno");
        Date lastEndIntDate = finsubBill.getDate("endinstdate");
        BigDecimal amount = redeemBill.getBigDecimal("amount");
        BigDecimal surplusAmount = redeemBill.getBigDecimal("surplusamount");
        Long finBillId = finsubBill.getLong("id");
        if (BigDecimal.ZERO.compareTo(surplusAmount) != 0) {
            intBill = RevenueCalcHelper.callInt((Long)finBillId, (Date)redeemDate, (BigDecimal)amount);
        } else {
            if (EmptyUtil.isNoEmpty((Object)lastEndIntDate)) {
                lastEndIntDate = DateUtils.getNextDay((Date)lastEndIntDate, (int)1);
            }
            intBill = RevenueCalcHelper.callInt((Long)finBillId, (Date)lastEndIntDate, (Date)redeemDate);
        }
        if (EmptyUtil.isEmpty((Object)intBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u76ca\u6d4b\u7b97\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinsubAuto2RedeemConvertPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        }
        return intBill.getAmount();
    }
}

