/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Redeem2RecConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entries = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        Set redeemBillIds = Arrays.stream(entries).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        Map redeemBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cim_redeem", (String)"id,redeemway,combineinst,realrevenue", redeemBillIds);
        for (ExtendedDataEntity entity : entries) {
            DynamicObject dataEntity = entity.getDataEntity();
            long billid = dataEntity.getLong("sourcebillid");
            DynamicObject redeemBill = (DynamicObject)redeemBillMap.get(billid);
            BigDecimal revenueAmt = redeemBill.getBigDecimal("realrevenue");
            if (!EmptyUtil.isNoEmpty((BigDecimal)revenueAmt) || !redeemBill.getBoolean("combineinst") && !RedeemWayEnum.isCopiesRedeem((String)redeemBill.getString("redeemway"))) continue;
            DynamicObjectCollection paymentEntrys = dataEntity.getDynamicObjectCollection("entry");
            if (paymentEntrys.size() > 0) {
                DynamicObject secondLine = paymentEntrys.addNew();
                secondLine.set("seq", (Object)2);
                secondLine.set("e_sourcebillid", (Object)billid);
                secondLine.set("e_sourcebillentryid", (Object)billid);
                secondLine.set("e_receivableamt", (Object)revenueAmt);
                secondLine.set("e_actamt", (Object)revenueAmt);
                secondLine.set("e_remark", (Object)ResManager.loadKDString((String)"\u6536\u76ca", (String)"Release2RecBillConvertPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                TmcBotpHelper.addLinkEntity((DynamicObject)dataEntity, (String)"entry", (String)"sourcebilltype", (DynamicObject)redeemBill, (String)"e_sourcebillentryid");
            }
            dataEntity.set("actrecamt", (Object)dataEntity.getBigDecimal("actrecamt").add(revenueAmt));
            dataEntity.set("inneraccountamount", (Object)dataEntity.getBigDecimal("inneraccountamount").add(revenueAmt));
        }
    }
}

