/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Release2RecBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entries = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        Set releaseBillIds = Arrays.stream(entries).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        Map releaseBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cim_release", (String)"amount,totalamount,finaccountf7,finbillno,combineinst,realrevenue", releaseBillIds);
        for (ExtendedDataEntity entity : entries) {
            BigDecimal revenueAmt;
            DynamicObject dataEntity = entity.getDataEntity();
            long billid = dataEntity.getLong("sourcebillid");
            DynamicObject releaseBill = (DynamicObject)releaseBillMap.get(billid);
            DynamicObject fixedAcct = Optional.ofNullable(releaseBill.getDynamicObject("finbillno")).map(r -> r.getDynamicObject("finaccountf7")).orElse(null);
            if (fixedAcct != null) {
                DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bank.name", (QFilter[])new QFilter("id", "=", (Object)fixedAcct.getLong("id")).toArray());
                dataEntity.set("payerbankname", (Object)acct.getString("bank.name"));
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)(revenueAmt = releaseBill.getBigDecimal("realrevenue"))) || !releaseBill.getBoolean("combineinst")) continue;
            DynamicObjectCollection paymentEntrys = dataEntity.getDynamicObjectCollection("entry");
            if (paymentEntrys.size() > 0) {
                DynamicObject secondLine = paymentEntrys.addNew();
                secondLine.set("seq", (Object)2);
                secondLine.set("e_sourcebillid", (Object)billid);
                secondLine.set("e_sourcebillentryid", (Object)billid);
                secondLine.set("e_receivableamt", (Object)revenueAmt);
                secondLine.set("e_actamt", (Object)revenueAmt);
                secondLine.set("e_remark", (Object)ResManager.loadKDString((String)"\u6536\u76ca", (String)"Release2RecBillConvertPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                TmcBotpHelper.addLinkEntity((DynamicObject)dataEntity, (String)"entry", (String)"sourcebilltype", (DynamicObject)releaseBill, (String)"e_sourcebillentryid");
            }
            dataEntity.set("actrecamt", (Object)dataEntity.getBigDecimal("actrecamt").add(revenueAmt));
            dataEntity.set("inneraccountamount", (Object)dataEntity.getBigDecimal("inneraccountamount").add(revenueAmt));
        }
    }
}

