/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert.revenueconvert;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.formplugin.convert.revenueconvert.AbstractRevenueConvert;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;

public class FromBatchRevenueConvert
extends AbstractRevenueConvert {
    @Override
    public void convert(List<DynamicObject> revenues, RevenueConvertParam convertParam) {
        Map sourceParamMap = convertParam.getSourceParamMap();
        for (DynamicObject revenue : revenues) {
            long sourceBillId = revenue.getLong("sourcebillid");
            this.dealByBatchBill(revenue, ((RevenueConvertParam.SourceParam)sourceParamMap.get(sourceBillId)).getOption());
            this.calcRealRate(revenue);
        }
    }

    private void dealByBatchBill(DynamicObject revenue, Map<String, String> opMap) {
        String tag = opMap.get("intdetail_tag");
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)tag, IntBillInfo.class);
        revenue.set("bizdate", (Object)DateUtils.stringToDate((String)opMap.get("revenuedate"), (String)"yyyy-MM-dd"));
        DepositHelper.setRevenueEntry((DynamicObject)revenue, (IntBillInfo)intBillInfo);
        revenue.set("actpreinstamt", (Object)opMap.get("actualinstamt"));
    }
}

