/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public abstract class AbstractDepositList
extends AbstractTmcListPlugin {
    private static final String DEPOSIT_APPLYID = "depositApplyId";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        DepositHelper.removeSpareFilter((FilterContainerInitArgs)args, (String)((BillList)this.getControl("billlistap")).getBillFormId());
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"org.name", (CharSequence)fieldName)) continue;
            filterColumn.setDefaultValue("");
            break;
        }
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        String dataInclude = (String)this.getView().getFormShowParameter().getCustomParam("dataInclude");
        if (EmptyUtil.isEmpty((String)dataInclude)) {
            e.getQFilters().add(new QFilter("investvarieties.investtype", "in", (Object)this.chooseInvestType()));
        }
        if (!(billList = (BillList)this.getControl("billlistap")).getBillFormId().startsWith("ifm")) {
            String finOrgTypeProp = "finorginfo.finorgtype.type";
            QFilter filter = new QFilter(finOrgTypeProp, "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            if (DepositHelper.isCimRelateAppSet()) {
                QFilter settleOrgFilter = new QFilter(finOrgTypeProp, "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
                filter = filter.or(settleOrgFilter);
            }
            e.getQFilters().add(filter);
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.equals((CharSequence)"investvarieties.name", (CharSequence)fieldName)) {
            filters.add(new QFilter("investtype", "in", (Object)this.chooseInvestType()));
        }
        return filters;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "pushrelease": {
                this.dealPush2Release(args);
                break;
            }
            case "redeposit": {
                operate.getOption().setVariableValue("OPERATE_BY_USER", "true");
                break;
            }
            case "pushintorevenue": {
                this.dealPush2Revenue(args);
                break;
            }
            case "pushandsavepaybill": {
                this.dealPush2PayBill(args);
                break;
            }
            case "updaterevenueplan": {
                this.validateUpdateRevenuePlan(args);
                break;
            }
            case "linkqueryapply": {
                this.validateLinkQueryApply(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "commitbe": 
            case "recommitbe": 
            case "activedeposit": 
            case "enddeposit": {
                ((BillList)this.getControl("billlistap")).refreshData();
                break;
            }
            case "redeposit": {
                ((BillList)this.getControl("billlistap")).refreshData();
                List selectedIdList = this.getSelectedIdList();
                if (!EmptyUtil.isNoEmpty((Object)selectedIdList) || selectedIdList.size() != 1) break;
                this.showSingleRedepositBill(args.getOperationResult().getSuccessPkIds().get(0));
                break;
            }
            case "updaterevenueplan": {
                this.openRevenuePlanForm();
                break;
            }
            case "pushintorevenue": {
                this.openIntBatchEdit();
                break;
            }
            case "linkqueryapply": {
                this.openApplyBill(args);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (StringUtils.equals((CharSequence)"srcdepositno", (CharSequence)args.getFieldName())) {
            args.setCancel(true);
            this.doHyperLinkForSrcDepositNo(billlistap);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equals((CharSequence)"close_bake_key_filter", (CharSequence)actionId) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            String currentEntity = this.getDataEntityName();
            String batchEntity = currentEntity.startsWith("cim_") ? "cim_dptrevenuebatch" : "ifm_dptrevenuebatch";
            parameter.setFormId(batchEntity);
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void doHyperLinkForSrcDepositNo(BillList billlistap) {
        ListSelectedRow currentSelectedRowInfo = billlistap.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        DynamicObject currentDepositBill = QueryServiceHelper.queryOne((String)formId, (String)"srcdepositno", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        List srcDepositBillIds = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)currentDepositBill.getString("srcdepositno"))}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)srcDepositBillIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DepositDealList_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(srcDepositBillIds.get(0));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public abstract String[] chooseInvestType();

    private void showSingleRedepositBill(Object data) {
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        Map customParams = showParameter.getCustomParams();
        customParams.put("flage_redeposit", data);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void dealPush2Release(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        String billFormId = billList.getBillFormId();
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)billPkId, (String)billFormId, (String)"id,billno,finorginfo,bizstatus");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        String pkValue = depositBill.getString("id");
        if (!this.txCheck(pkValue)) {
            args.setCancel(true);
            return;
        }
        String operateName = ((AbstractOperate)args.getSource()).getOperateName().getLocaleValue();
        String validateMsg = DepositHelper.validateSettleBill((DynamicObject)depositBill, (String)operateName);
        if (EmptyUtil.isNoEmpty((String)validateMsg)) {
            this.getView().showTipNotification(validateMsg);
            args.setCancel(true);
            return;
        }
        String bizStatus = depositBill.getString("bizstatus");
        if (!StringUtils.equals((CharSequence)FinServiceStatusEnum.subscribe_done.getValue(), (CharSequence)bizStatus) && !StringUtils.equals((CharSequence)FinServiceStatusEnum.subscribe_part.getValue(), (CharSequence)bizStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5b58\u6b3e\u4e1a\u52a1\u4e2d\u7684\u201c\u5df2\u5b58\u6b3e\u201d\u548c\u201c\u90e8\u5206\u89e3\u6d3b\u201d\u624d\u80fd\u8fdb\u884c\u89e3\u6d3b\u3002", (String)"DepositDealList_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (DepositHelper.isExistsRedepositBill((String)depositBill.getString("billno"))) {
            this.getView().showTipNotification(this.getTips());
            args.setCancel(true);
            return;
        }
        QFilter applyQfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        applyQfilter.and(new QFilter("applytype", "=", (Object)DepositApplyTypeEnum.SUBSIST.getValue()));
        applyQfilter.and(new QFilter("deposit", "=", depositBill.getPkValue()));
        boolean exists = QueryServiceHelper.exists((String)"cim_deposit_apply", (QFilter[])new QFilter[]{applyQfilter});
        if (exists) {
            this.getView().showTipNotification(CimFormResourceEnum.DepositDealList_10.loadKDString());
            args.setCancel(true);
            return;
        }
    }

    private void dealPush2PayBill(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
        if (!this.txCheck(String.valueOf(billPkId))) {
            args.setCancel(true);
        }
    }

    private void dealPush2Revenue(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        String billFormId = billList.getBillFormId();
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)billPkId, (String)billFormId, (String)"billno,finorginfo,bizstatus,tradechannel,bebankstatus");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        String pkValue = depositBill.getString("id");
        if (!this.txCheck(pkValue)) {
            args.setCancel(true);
            return;
        }
        String bizStatus = depositBill.getString("bizstatus");
        if (!(StringUtils.equals((CharSequence)FinServiceStatusEnum.subscribe_done.getValue(), (CharSequence)bizStatus) || StringUtils.equals((CharSequence)FinServiceStatusEnum.subscribe_part.getValue(), (CharSequence)bizStatus) || StringUtils.equals((CharSequence)FinServiceStatusEnum.subscribe_norevenue.getValue(), (CharSequence)bizStatus))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5b58\u6b3e\u6216\u5df2\u90e8\u5206\u89e3\u6d3b\u6216\u5df2\u89e3\u6d3b\u672a\u6536\u76ca\u4e1a\u52a1\u72b6\u6001\u7684\u5b9a\u671f\uff08\u901a\u77e5\uff09\u5b58\u6b3e\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositDealList_15", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)billPkId);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        boolean exists = QueryServiceHelper.exists((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u671f\uff08\u901a\u77e5\uff09\u5b58\u6b3e\u5355\u5b58\u5728\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355\uff0c\u8bf7\u5148\u5220\u9664\u6216\u5ba1\u6838\u3002", (String)"DepositDealList_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String tradeChannel = depositBill.getString("tradechannel");
        String bankStatus = depositBill.getString("bebankstatus");
        if (StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel) && !StringUtils.equals((CharSequence)BebankStatusEnum.TS.getValue(), (CharSequence)bankStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5982\u679c\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\uff0c\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u9700\u8981\u4e3a\u4ea4\u6613\u6210\u529f\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositDealList_8", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void openRevenuePlanForm() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        BillShowParameter param = new BillShowParameter();
        param.setPkId(selectedRows.get(0).getPrimaryKeyValue());
        param.setFormId("cim_dptrevenue_plan");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)param);
    }

    private void validateUpdateRevenuePlan(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
    }

    protected void openIntBatchEdit() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        String entityName = this.getDataEntityName();
        String formId = entityName.startsWith("cim_") ? "cim_dptrevenue_navigate" : "ifm_dptrevenue_naviga";
        parameter.setFormId(formId);
        Long billPkId = this.getSelectedId();
        parameter.setCustomParam("loanbill", (Object)billPkId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_bake_key_filter"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    protected String getTips() {
        return ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u5355\uff0c\u8bf7\u5c06\u7eed\u5b58\u5355\u5220\u9664\u540e\u518d\u64cd\u4f5c\u3002", (String)"DepositDealList_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
    }

    private boolean txCheck(String pkValue) {
        List lockedIds = TxCheckUtil.loadUnfinishedTx(Collections.singletonList(pkValue));
        if (EmptyUtil.isNoEmpty((Object)lockedIds) && lockedIds.contains(pkValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u4e0b\u63a8\u4ed8\u6b3e\u5904\u7406\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\u6267\u884c\u5931\u8d25\u6216\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AbstractDepositList_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateLinkQueryApply(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
        OperateOption option = ((FormOperate)args.getSource()).getOption();
        DynamicObject depositBill = QueryServiceHelper.queryOne((String)"cim_deposit", (String)"apply,isredepositgenerate,srcdepositno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billPkId)});
        if (!depositBill.getBoolean("isredepositgenerate")) {
            long applyId = depositBill.getLong("apply");
            if (EmptyUtil.isEmpty((Long)applyId)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0a\u6e38\u7533\u8bf7\u5355\u3002", (String)"AbstractDepositList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return;
            }
            option.setVariableValue(DEPOSIT_APPLYID, String.valueOf(applyId));
            return;
        }
        boolean isLoop = false;
        do {
            QFilter qFilter = new QFilter("billno", "=", (Object)depositBill.getString("srcdepositno"));
            depositBill = QueryServiceHelper.queryOne((String)"cim_deposit", (String)"apply,isredepositgenerate,srcdepositno", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0a\u6e38\u7533\u8bf7\u5355\u3002", (String)"AbstractDepositList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            if (depositBill.getBoolean("isredepositgenerate")) continue;
            long applyId = depositBill.getLong("apply");
            if (EmptyUtil.isEmpty((Long)applyId)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0a\u6e38\u7533\u8bf7\u5355\u3002", (String)"AbstractDepositList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
            option.setVariableValue(DEPOSIT_APPLYID, String.valueOf(applyId));
            break;
        } while (isLoop = true);
    }

    protected void openApplyBill(AfterDoOperationEventArgs args) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("cim_deposit_apply");
        String applyIdStr = ((FormOperate)args.getSource()).getOption().getVariableValue(DEPOSIT_APPLYID);
        parameter.setPkId((Object)Long.valueOf(applyIdStr));
        this.getView().showForm((FormShowParameter)parameter);
    }
}

