/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.formplugin.common.AgreeDepositHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AgreeDepositEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit bankAcct = (BasedataEdit)this.getControl("bankacct");
        bankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit intObj = (BasedataEdit)this.getControl("intobj");
        intObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit apply = (BasedataEdit)this.getControl("apply");
        apply.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field;
        switch (field = evt.getProperty().getName()) {
            case "apply": {
                this.setApplyF7Filter(evt);
                break;
            }
            case "intobj": {
                AgreeDepositHelper.setIntObjF7Filter(evt);
                break;
            }
            case "bankacct": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"AgreeDepositEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                AgreeDepositHelper.setBankAcctF7Filter(evt, org);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"amount", "rate"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "intobj": {
                this.setValueByIntObj();
                break;
            }
            case "bankacct": {
                AgreeDepositHelper.setCurrencyByBankAcct(this.getModel());
                break;
            }
            case "depositorg": {
                AgreeDepositHelper.setBankColumnNull(e, this.getModel());
                break;
            }
            case "apply": {
                this.setValueByApply();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Date endDate;
        Object value = e.getValue();
        Control source = (Control)e.getSource();
        String field = source.getKey();
        if (StringUtils.equals((CharSequence)"enddate", (CharSequence)field)) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, value}) && DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd").compareTo(startDate) <= 0) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u8bae\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u534f\u8bae\u5f00\u59cb\u65e5\u671f\u3002", (String)"AgreeDepositEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                this.getView().updateView(field);
            }
        } else if (StringUtils.equals((CharSequence)"startdate", (CharSequence)field) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{endDate = (Date)this.getModel().getValue("enddate"), value}) && DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd").compareTo(endDate) >= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u8bae\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u534f\u8bae\u7ed3\u675f\u65e5\u671f\u3002", (String)"AgreeDepositEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.getView().updateView(field);
        }
    }

    private void setValueByIntObj() {
        DynamicObject intObj = (DynamicObject)this.getModel().getValue("intobj");
        if (EmptyUtil.isEmpty((DynamicObject)intObj)) {
            this.getModel().setValue("depositorg", null);
            this.getModel().setValue("finorginfo", null);
            this.getModel().setValue("bankacct", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("amount", null);
            this.getModel().setValue("rate", null);
            return;
        }
        intObj = TmcDataServiceHelper.loadSingleFromCache((Object)intObj.getPkValue(), (String)"ifm_bankacctintobject");
        this.getModel().setValue("depositorg", (Object)intObj.getDynamicObject("accountorg"));
        DynamicObject bankAcct = intObj.getDynamicObject("intobject");
        if (EmptyUtil.isEmpty((DynamicObject)bankAcct)) {
            return;
        }
        bankAcct = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "=", bankAcct.getPkValue())});
        this.getModel().setValue("finorginfo", (Object)bankAcct.getDynamicObject("bank"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bankacct", (Object)bankAcct);
        this.getModel().setValue("currency", (Object)intObj.getDynamicObject("currency"));
        Pair<BigDecimal, BigDecimal> amtPair = AgreeDepositHelper.getAmtAndBpPoint(intObj);
        this.getModel().setValue("amount", amtPair.getLeft());
        DynamicObject referrate = intObj.getDynamicObject("referrate");
        if (EmptyUtil.isEmpty((DynamicObject)referrate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u8ba1\u606f\u5bf9\u8c61\u4e2d\u7684\u53c2\u8003\u5229\u7387\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AgreeDepositEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal rate = MarketDataServiceHelper.referRate((String)referrate.getString("number"), (Date)intObj.getDate("startintdate"));
        if (EmptyUtil.isEmpty((BigDecimal)rate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"AgreeDepositEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal newRate = rate.add(((BigDecimal)amtPair.getRight()).divide(Constants.ONE_HUNDRED, 10, 4));
        this.getModel().setValue("rate", (Object)newRate);
    }

    private void setValueByApply() {
        DynamicObject apply = (DynamicObject)this.getModel().getValue("apply");
        if (EmptyUtil.isEmpty((DynamicObject)apply)) {
            return;
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"intobj", (Object)apply.getDynamicObject("intobj"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"org", (Object)apply.getDynamicObject("applyorg"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"depositorg", (Object)apply.getDynamicObject("org"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finorginfo", (Object)apply.getDynamicObject("finorginfo"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bankacct", (Object)apply.getDynamicObject("bankacct"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", (Object)apply.getDynamicObject("currency"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"startdate", (Object)apply.getDate("intdate"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"enddate", (Object)apply.getDate("expiredate"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"amount", (Object)apply.getBigDecimal("amount"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"rate", (Object)apply.getBigDecimal("interestrate"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"autoredeposit", (Object)apply.getBoolean("autoredeposit"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"comment", (Object)apply.getString("remark"));
    }

    private void setApplyF7Filter(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org", "in", (Object)orgIdCollection);
        DynamicObjectCollection applys = QueryServiceHelper.query((String)"cim_agreement_deposit", (String)"apply", (QFilter[])new QFilter[]{new QFilter("apply", "!=", (Object)0)});
        List applyIds = applys.stream().map(s -> s.getLong("apply")).collect(Collectors.toList());
        qFilter.and(new QFilter("id", "not in", applyIds));
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
    }
}

