/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.Collection;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class AgreeDepositList
extends AbstractTmcListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((CharSequence)"autoredeposit", (CharSequence)operateKey)) {
            source.getOption().setVariableValue("OPERATE_BY_USER", "true");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (EmptyUtil.isNoEmpty((Object)opResult) && opResult.isSuccess()) {
            if (StringUtils.equals((CharSequence)"closeagree", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"uncloseagree", (CharSequence)operateKey)) {
                this.getView().invokeOperation("refresh");
            } else if (StringUtils.equals((CharSequence)"autoredeposit", (CharSequence)operateKey)) {
                List idList = this.getSelectedIdList();
                if (EmptyUtil.isNoEmpty((Object)idList) && idList.size() == 1) {
                    this.showRedepositAgreeBill();
                } else {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"srcdepositno", (CharSequence)args.getFieldName())) {
            args.setCancel(true);
            this.doHyperLinkForSrcDepositNo();
        }
    }

    private void doHyperLinkForSrcDepositNo() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billlistap.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        DynamicObject currentDepositBill = QueryServiceHelper.queryOne((String)formId, (String)"srcdepositno", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        List srcDepositBillIds = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)currentDepositBill.getString("srcdepositno"))}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)srcDepositBillIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DepositDealList_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(srcDepositBillIds.get(0));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showRedepositAgreeBill() {
        String billNo = this.getSelectedRows().get(0).getBillNo();
        QFilter qFilter = new QFilter("srcdepositno", "=", (Object)billNo);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)AgreeDepositStatusEnum.NORMAL.getValue()));
        List redepositBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_agreement_deposit", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isNoEmpty((Object)redepositBillIds)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("cim_agreement_deposit");
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPkId(redepositBillIds.get(0));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

