/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.formplugin.common.AgreeDepositHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DepositApplyForAgreeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit bankAcct = (BasedataEdit)this.getControl("bankacct");
        bankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit intObj = (BasedataEdit)this.getControl("intobj");
        intObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finOrg = (BasedataEdit)this.getControl("finorginfo");
        finOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        this.setFieldCaption();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "applytype": {
                this.setFieldCaption();
                break;
            }
            case "intobj": {
                this.setValueByIntObj();
                break;
            }
            case "bankacct": {
                AgreeDepositHelper.setCurrencyByBankAcct(this.getModel());
                break;
            }
            case "org": {
                AgreeDepositHelper.setBankColumnNull(e, this.getModel());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field;
        switch (field = evt.getProperty().getName()) {
            case "bankacct": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("applyorg");
                if (EmptyUtil.isEmpty((DynamicObject)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"AgreeDepositEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                AgreeDepositHelper.setBankAcctF7Filter(evt, org);
                break;
            }
            case "intobj": {
                AgreeDepositHelper.setIntObjF7Filter(evt);
                break;
            }
            case "finorginfo": {
                if (!DepositApplyTypeEnum.isAgree((String)((String)this.getModel().getValue("applytype")))) break;
                List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("finorgtype.type", "!=", (Object)"1"));
                break;
            }
            case "currency": {
                this.setCurrencyF7Filter(evt);
                break;
            }
        }
    }

    private void setFieldCaption() {
        this.setDisplayName("currency", ResManager.loadKDString((String)"\u5b58\u6b3e\u5e01\u79cd", (String)"DepositApplyForAgreeEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DepositApplyForAgreeEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        this.setDisplayName("intdate", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d77\u606f\u65e5", (String)"DepositApplyForAgreeEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u8bae\u5f00\u59cb\u65e5\u671f", (String)"DepositApplyForAgreeEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        this.setDisplayName("expiredate", ResManager.loadKDString((String)"\u5b58\u6b3e\u5230\u671f\u65e5", (String)"DepositApplyForAgreeEdit_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u8bae\u7ed3\u675f\u65e5\u671f", (String)"DepositApplyForAgreeEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        this.setDisplayName("amount", ResManager.loadKDString((String)"\u5b58\u6b3e\u91d1\u989d", (String)"DepositApplyForAgreeEdit_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6700\u4f4e\u7559\u5b58\u91d1\u989d", (String)"DepositApplyForAgreeEdit_8", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        this.setDisplayName("interestrate", ResManager.loadKDString((String)"\u5b58\u6b3e\u5229\u7387\uff08%\uff09", (String)"DepositApplyForAgreeEdit_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u5b9a\u5229\u7387\uff08%\uff09", (String)"DepositApplyForAgreeEdit_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        String applyType = (String)this.getModel().getValue("applytype");
        boolean isAgree = DepositApplyTypeEnum.isAgree((String)applyType);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isAgree ? 1 : 0) != 0, (String[])new String[]{"expiredate", "amount"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isAgree, (String[])new String[]{"bankacct"});
    }

    private void setDisplayName(String fieldProp, String defShowName, String showName) {
        FieldEdit field = (FieldEdit)this.getControl(fieldProp);
        boolean isAgree = DepositApplyTypeEnum.isAgree((String)((String)this.getModel().getValue("applytype")));
        field.setCaption(!isAgree ? new LocaleString(defShowName) : new LocaleString(showName));
    }

    private void setValueByIntObj() {
        DynamicObject intObj = (DynamicObject)this.getModel().getValue("intobj");
        if (EmptyUtil.isEmpty((DynamicObject)intObj)) {
            return;
        }
        intObj = TmcDataServiceHelper.loadSingleFromCache((Object)intObj.getPkValue(), (String)"ifm_bankacctintobject");
        this.getModel().setValue("org", (Object)intObj.getDynamicObject("accountorg"));
        DynamicObject bankAcct = intObj.getDynamicObject("intobject");
        if (EmptyUtil.isEmpty((DynamicObject)bankAcct)) {
            return;
        }
        bankAcct = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "=", bankAcct.getPkValue())});
        this.getModel().setValue("finorginfo", (Object)bankAcct.getDynamicObject("bank"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bankacct", (Object)bankAcct);
        this.getModel().setValue("currency", (Object)intObj.getDynamicObject("currency"));
        Pair<BigDecimal, BigDecimal> amtPair = AgreeDepositHelper.getAmtAndBpPoint(intObj);
        this.getModel().setValue("amount", amtPair.getLeft());
        DynamicObject referrate = intObj.getDynamicObject("referrate");
        if (EmptyUtil.isEmpty((DynamicObject)referrate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u8ba1\u606f\u5bf9\u8c61\u4e2d\u7684\u53c2\u8003\u5229\u7387\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AgreeDepositEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal rate = MarketDataServiceHelper.referRate((String)referrate.getString("number"), (Date)intObj.getDate("startintdate"));
        if (EmptyUtil.isEmpty((BigDecimal)rate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"AgreeDepositEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal newRate = rate.add(((BigDecimal)amtPair.getRight()).divide(Constants.ONE_HUNDRED, 10, 4));
        this.getModel().setValue("interestrate", (Object)newRate);
    }

    private void setCurrencyF7Filter(BeforeF7SelectEvent evt) {
        if (DepositApplyTypeEnum.isAgree((String)((String)this.getModel().getValue("applytype")))) {
            DynamicObject intObj = (DynamicObject)this.getModel().getValue("intobj");
            if (EmptyUtil.isEmpty((DynamicObject)intObj)) {
                return;
            }
            Optional<Long> bankAcctOp = Optional.ofNullable(intObj.getDynamicObject("intobject")).map(r -> r.getLong("id"));
            if (!bankAcctOp.isPresent()) {
                return;
            }
            DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankAcctOp.get())});
            DynamicObjectCollection currencyCols = bankAcct.getDynamicObjectCollection("currency");
            List bankIdList = currencyCols.stream().map(r -> r.getDynamicObject("fbasedataid")).map(r -> r.getLong("id")).collect(Collectors.toList());
            List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", bankIdList));
        }
    }
}

