/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class DepositApplyList
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        this.removeSpareFilter(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"applyorg.name", (CharSequence)fieldName)) continue;
            filterColumn.setDefaultValue(RequestContext.get().getLoginOrg());
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Set selectedIds;
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("regist".equals(operateKey)) {
            this.validateBeforeRegist(args);
        } else if ("pushbizdealbill".equals(operateKey)) {
            this.validateBeforeSubmitCenter(args);
        } else if ("selectdepositscheme".equals(operateKey) && (selectedIds = args.getListSelectedData().stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toSet())).size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"DepositApplyList_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("regist".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.pushToDeposit();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"selectdepositscheme") && args.getOperationResult().isSuccess()) {
            Long selectedId = this.getSelectedId();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setFormId("cim_deposit_apply");
            parameter.setPkId((Object)selectedId);
            parameter.setCustomParam("fromselect", (Object)"true");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equalsAny((String)operateKey, (String[])new String[]{"commitbe", "recommitbe"}) && args.getOperationResult().isSuccess()) {
            ((BillList)this.getControl("billlistap")).refreshData();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("tbltrackdown".equals(evt.getItemKey())) {
            Long id = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)id)) {
                return;
            }
            DynamicObject depositApply = TmcDataServiceHelper.loadSingle((Object)id, (String)"cim_deposit_apply", (String)"applytype,deposit,investvarieties");
            String applyType = depositApply.getString("applytype");
            if (!DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u89e3\u6d3b\u7533\u8bf7\u5355\u53ef\u4ee5\u4e0b\u67e5\u89e3\u6d3b\u5355\u3002", (String)"DepositApplyList_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.trackClick(depositApply);
        }
    }

    private void trackClick(DynamicObject depositApply) {
        DynamicObject depositBill = depositApply.getDynamicObject("deposit");
        Object[] releaseIds = TmcBotpHelper.getTargetBillIds((String)DepositHelper.getDepositEntityName((DynamicObject)depositApply), (Object)depositBill.getPkValue(), (String)DepositHelper.getReleaseEntityName((DynamicObject)depositApply));
        if (EmptyUtil.isNoEmpty((Object[])releaseIds)) {
            if (releaseIds.length == 1) {
                DepositHelper.showBillForm((Object)releaseIds[0], (IFormView)this.getView(), (String)DepositHelper.getReleaseEntityName((DynamicObject)depositApply));
            } else if (releaseIds.length > 1) {
                DepositHelper.showBillListForm((Long[])releaseIds, (IFormView)this.getView(), (String)DepositHelper.getReleaseEntityName((DynamicObject)depositApply));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"DepositApplyList_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateBeforeRegist(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection depositBills;
        List billNoList;
        Object[] targetBillIds;
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
        }
        if (EmptyUtil.isEmpty((Object[])(targetBillIds = TmcBotpHelper.getTargetBillIds((String)"cim_deposit_apply", (Object)billPkId, (String)"cim_deposit")))) {
            targetBillIds = TmcBotpHelper.getTargetBillIds((String)"cim_deposit_apply", (Object)billPkId, (String)"cim_noticedeposit");
        }
        if (EmptyUtil.isNoEmpty((Object[])targetBillIds) && EmptyUtil.isNoEmpty(billNoList = (depositBills = QueryServiceHelper.query((String)"cim_deposit", (String)"billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetBillIds)})).stream().filter(r -> !StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)r.getString("billstatus"))).map(r -> r.getString("billno")).collect(Collectors.toList()))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u5b58\u6b3e\u5355%s\uff0c\u662f\u5426\u518d\u6b21\u4e0b\u63a8\u5b58\u6b3e\u5355\uff1f", (String)"DepositApplyList_8", (String)"tmc-cim-formplugin", (Object[])new Object[]{String.join((CharSequence)",", billNoList)}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("REGIST_CONFIRM_CALLBACK", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void pushToDeposit() {
        Long billPkId = this.getSelectedId();
        DynamicObject depositApply = TmcDataServiceHelper.loadSingle((Object)billPkId, (String)"cim_deposit_apply", (String)"applytype,investvarieties");
        if (DepositApplyTypeEnum.isAgree((String)depositApply.getString("applytype"))) {
            TmcBotpHelper.doPush((IFormView)this.getView(), (Long)billPkId, (String)"cim_deposit_apply", (String)"cim_agreement_deposit", (String)"cim_deposit_apply", (String)"cim_agreement_deposit");
        } else {
            String targetEntity = DepositHelper.getDepositEntityName((DynamicObject)depositApply);
            TmcBotpHelper.doPush((IFormView)this.getView(), (Long)billPkId, (String)"cim_deposit_apply", (String)targetEntity, (String)"cim_deposit_apply", (String)targetEntity);
        }
    }

    private void validateBeforeSubmitCenter(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject selectApplyBill = TmcDataServiceHelper.loadSingle((String)"cim_deposit_apply", (String)"releaseamount,finorginfo,billstatus,applytype,deposit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId)});
        if (EmptyUtil.isEmpty((DynamicObject)selectApplyBill)) {
            return;
        }
        String billStatus = selectApplyBill.getString("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositApplyList_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!DepositHelper.isSettleCenterBill((DynamicObject)selectApplyBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositApplyList_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject bizDealBill = TmcBotpHelper.getTargetBill((String)"cim_deposit_apply", (Object)selectApplyBill.getPkValue(), (String)"ifm_bizdealbill_deposit");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizDealBill) && !StringUtils.equals((CharSequence)"D", (CharSequence)bizDealBill.getString("bizstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u5df2\u4e0b\u63a8\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositApplyList_11", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String applyType = selectApplyBill.getString("applytype");
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)DepositApplyTypeEnum.RELEASE.getValue())) {
            DynamicObject deposit = selectApplyBill.getDynamicObject("deposit");
            BigDecimal surPlusAmt = deposit.getBigDecimal("surplusamount");
            BigDecimal releaseAmt = selectApplyBill.getBigDecimal("releaseamount");
            if (releaseAmt.compareTo(surPlusAmt) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u7684\u89e3\u6d3b\u91d1\u989d\u5927\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\uff0c\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u5931\u8d25\u3002", (String)"DepositApplyList_12", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"REGIST_CONFIRM_CALLBACK", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.pushToDeposit();
        }
    }

    private void removeSpareFilter(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        ArrayList<String> removeFeilds = new ArrayList<String>(4);
        removeFeilds.add("bebankstatus");
        removeFeilds.add("submittime");
        removeFeilds.add("org.name");
        commonFilterColumns.removeIf(v -> removeFeilds.contains(v.getFieldName()));
    }
}

