/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.DepositTermEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.InterestTypeEnum;
import kd.tmc.cim.common.enums.RateSignEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.property.DepositDealProp;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.RateResetEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit finAccount = (TextEdit)this.getControl("finaccount");
        if (EmptyUtil.isNoEmpty((Object)finAccount)) {
            finAccount.addButtonClickListener((ClickListener)this);
        }
        this.addBeforeF7Listener(Arrays.asList("settleaccount", "productfactory", "apply", "referencerate", "finorginfo", "finaccountf7"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String fieldName = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"finaccount")) {
            ((BasedataEdit)this.getControl("finaccountf7")).click();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        switch (fieldName) {
            case "expiredate": {
                this.validateExpireDate(e, value, fieldName);
                break;
            }
            case "term": {
                boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString());
                if (rightFormat) break;
                e.setCancel(true);
                this.getView().updateView(fieldName);
                break;
            }
            case "amount": {
                BigDecimal lastAmt;
                DynamicObject apply = (DynamicObject)this.getModel().getValue("apply");
                if (!EmptyUtil.isNoEmpty((DynamicObject)apply) || !StringUtils.equals((CharSequence)DepositApplyTypeEnum.DEPOSIT.getValue(), (CharSequence)apply.getString("applytype")) || new BigDecimal((String)value).compareTo(lastAmt = apply.getBigDecimal("lastamount")) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u5b58\u6b3e\u91d1\u989d\u5927\u4e8e\u5b58\u6b3e\u7533\u8bf7\u5355\u7684\u5269\u4f59\u53ef\u5b58\u6b3e\u91d1\u989d\u3002", (String)"DepositDealEdit_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("amount");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"finaccount", (CharSequence)actionId)) {
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)actionId, (Object)returnData.get(0).getNumber());
                this.getModel().setValue("finaccountf7", returnData.get(0).getPrimaryKeyValue());
            }
        } else if (StringUtils.equals((CharSequence)"productfactory", (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)returnData)) {
            this.getModel().setValue(actionId, returnData.get(0).getPrimaryKeyValue());
            DynamicObject productFactory = (DynamicObject)this.getModel().getValue(actionId);
            DynamicObject investVarieties = productFactory.getDynamicObject("investvarieties");
            if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (Object)investVarieties);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "settleaccount": {
                this.setSettAccountF7Filter(evt);
                break;
            }
            case "productfactory": {
                this.setPrdFactoryF7Filter(evt);
                break;
            }
            case "apply": {
                this.setApplyF7Filter(evt);
                break;
            }
            case "referencerate": {
                Optional.ofNullable((DynamicObject)this.getModel().getValue("currency")).map(r -> r.getLong("id")).ifPresent(id -> ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("currency", "=", id)));
                break;
            }
            case "finaccountf7": {
                this.setFinAccountF7Filter(evt);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        switch (fieldName = e.getProperty().getName()) {
            case "intdate": {
                this.intDateChgEvt();
                break;
            }
            case "term": 
            case "deadline": {
                this.calExpireDate((String)this.getModel().getValue("tradechannel"));
                break;
            }
            case "expiredate": {
                this.calTermOrIntDate((String)this.getModel().getValue("tradechannel"));
                break;
            }
            case "investvarieties": {
                this.getModel().setValue("productfactory", null);
                this.getModel().setValue("expireredeposit", (Object)ExpireRedepositTypeEnum.NOREDEPOSIT.getValue());
                this.setMustPutByInvestvarieties();
                DepositHelper.initInterestTypeEnum((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (String)"interesttype");
                DepositHelper.setInterestRateShowName((IFormView)this.getView());
                break;
            }
            case "productfactory": {
                Optional.ofNullable((DynamicObject)this.getModel().getValue("productfactory")).ifPresent(factory -> {
                    this.getModel().setValue("basis", (Object)factory.getString("basis"));
                    this.getModel().setValue("interesttype", (Object)factory.getString("ratetype"));
                });
                break;
            }
            case "interesttype": {
                this.setMustInputByInterestType();
                this.setRangeRateMust();
                break;
            }
            case "amount": {
                this.getModel().setValue("surplusamount", this.getModel().getValue("amount"));
                break;
            }
            case "apply": {
                this.setDepositApplyProp();
                break;
            }
            case "settleaccount": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("finorginfo")) || !EmptyUtil.isEmpty((Object)this.getModel().getValue("apply"))) break;
                Optional.ofNullable((DynamicObject)this.getModel().getValue("settleaccount")).ifPresent(r -> this.getModel().setValue("finorginfo", (Object)r.getDynamicObject("bank")));
                break;
            }
            case "finorginfo": {
                String tradeChannel = (String)this.getModel().getValue("tradechannel");
                if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    this.getModel().setValue("settleaccount", null);
                    this.getModel().setValue("currency", null);
                    this.getModel().setValue("finaccount", null);
                    break;
                }
                this.getModel().setValue("finaccount", null);
                break;
            }
            case "tradechannel": {
                this.getModel().setValue("finaccount", null);
                this.tradeChannelChgEvt(false);
                break;
            }
            case "org": {
                if (this.getView().getFormShowParameter().getFormId().equals("ifm_deposit")) break;
                DepositHelper.setBaseCurrency((IDataModel)this.getModel());
                break;
            }
            case "bizdate": {
                this.bizDateChgEvt();
                break;
            }
            case "srcinterest": {
                this.reCalcDepositAmt();
                break;
            }
            case "finaccountf7": {
                if (this.getModel().getDataEntity().getDataEntityType().getName().startsWith("ifm") || !EmptyUtil.isEmpty((Object)this.getModel().getValue("apply"))) break;
                Optional.ofNullable((DynamicObject)this.getModel().getValue("finaccountf7")).map(r -> r.getDynamicObject("defaultcurrency")).map(DataEntityBase::getPkValue).ifPresent(r -> this.getModel().setValue("currency", r));
                break;
            }
            case "rangemax": 
            case "rangemin": {
                this.setDefaultRate();
                break;
            }
            case "finaccount": {
                this.setFinaccountF7();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInputByInterestType();
        this.setMustPutByInvestvarieties();
        this.tradeChannelChgEvt(true);
        this.setSrcreMustInputWhenRedeposit();
        this.setAllRevenueAmt();
        DepositHelper.initInterestTypeEnum((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (String)"interesttype");
        this.setRangeRateMust();
        DepositHelper.setInterestRateShowName((IFormView)this.getView());
    }

    public void createNewData(BizDataEventArgs e) {
        String reDepositStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("flage_redeposit") && EmptyUtil.isNoEmpty((String)(reDepositStr = (String)customParams.get("flage_redeposit")))) {
            Object[] reDepositBillArr = DynamicObjectSerializeUtil.deserialize((String)reDepositStr, (DynamicObjectType)this.getModel().getDataEntityType());
            DynamicObject reDepositBill = (DynamicObject)reDepositBillArr[0];
            reDepositBill.set("isinit", (Object)Boolean.FALSE);
            DynamicObject currModel = TmcDataServiceHelper.newDynamicObject((String)this.getModel().getDataEntityType().getName());
            DynamicObjectUtil.copy((DynamicObject)reDepositBill, (DynamicObject)currModel, (String[])new String[]{"id"});
            e.setDataEntity((Object)currModel);
            e.setFireAfterCreateNewData(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DepositHelper.setBaseCurrency((IDataModel)this.getModel());
        this.bizDateChgEvt();
        this.intDateChgEvt();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "checkinterest": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("revenue_entry");
                boolean isInit = (Boolean)this.getModel().getValue("isinit");
                if (!isInit || rowIndex != 0 || !EmptyUtil.isNoEmpty((BigDecimal)((BigDecimal)this.getModel().getValue("handrevenueamt"))) || BillStatusEnum.isAudit((String)((String)this.getModel().getValue("billstatus")))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6570\u636e\uff0c\u4e0d\u80fd\u67e5\u770b\u6d4b\u7b97\u8be6\u60c5\u3002", (String)"DepositInitEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "submit": 
            case "save": {
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                if (!EmptyUtil.isNoEmpty((BigDecimal)amount) || amount.compareTo(DepositHelper.RATE_MAX) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b58\u6b3e\u91d1\u989d\u201d\u3002", (String)"DepositInitEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "updaterevenueplan": {
                this.showUpdateRevenuePlan();
                break;
            }
            case "submit": 
            case "save": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Date endDate = (Date)this.getModel().getValue("expiredate");
        Date startDate = (Date)this.getModel().getValue("intdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)startDate, (Date)endDate));
        }
        this.setTransferInfoByImport();
    }

    private void showUpdateRevenuePlan() {
        BillShowParameter param = new BillShowParameter();
        param.setPkId(this.getModel().getDataEntity().getPkValue());
        String formId = this.getView().getFormShowParameter().getFormId();
        String planEntity = formId.startsWith("cim_") ? "cim_dptrevenue_plan" : "ifm_dptrevenue_plan";
        param.setFormId(planEntity);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.EDIT);
        param.setEnableUserReentrant(true);
        this.getView().showForm((FormShowParameter)param);
    }

    private void setPrdFactoryF7Filter(BeforeF7SelectEvent e) {
        DynamicObject investVar = (DynamicObject)this.getModel().getValue("investvarieties");
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "productfactory"));
        if (EmptyUtil.isNoEmpty((DynamicObject)investVar)) {
            QFilter qFilter = new QFilter("investvarieties", "=", investVar.getPkValue());
            qFilters.add(qFilter);
            return;
        }
        String billName = this.getModel().getDataEntityType().getName();
        QFilter qFilter = new QFilter("investvarieties.enable", "=", (Object)"1");
        qFilters.add(qFilter);
        qFilter = new QFilter("investvarieties.isleaf", "=", (Object)"1");
        qFilters.add(qFilter);
        if ("cim_deposit".equals(billName)) {
            qFilter = new QFilter("investvarieties.investtype", "in", (Object)DepositDealProp.INVEST_TYPE_ARR);
            qFilters.add(qFilter);
        } else if ("cim_noticedeposit".equals(billName)) {
            qFilter = new QFilter("investvarieties.investtype", "=", (Object)InvestTypeEnum.notice.getValue());
            qFilters.add(qFilter);
        }
    }

    private void setSettAccountF7Filter(BeforeF7SelectEvent e) {
        QFilter accountFilter = this.getSettleAccountFilter();
        if (EmptyUtil.isEmpty((Object)accountFilter)) {
            e.setCancel(true);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(accountFilter);
    }

    private void setApplyF7Filter(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter applyTypeQFilter = new QFilter("applytype", "!=", (Object)DepositApplyTypeEnum.RELEASE.getValue());
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org.id", "in", (Object)orgIdCollection);
        DynamicObjectCollection applys = QueryServiceHelper.query((String)"cim_deposit", (String)"apply", (QFilter[])new QFilter[]{new QFilter("apply", "!=", (Object)0)});
        List applyIds = applys.stream().map(s -> s.getLong("apply")).collect(Collectors.toList());
        qFilter.and(new QFilter("id", "not in", applyIds));
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter.and(applyTypeQFilter));
    }

    private void setFinAccountF7Filter(BeforeF7SelectEvent e) {
        QFilter accountFilter = this.getAccountFilter();
        if (null == accountFilter) {
            e.setCancel(true);
            return;
        }
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        if (StringUtils.equals((CharSequence)tradeChannel, (CharSequence)TradeChannelEnum.ONLINE.getValue())) {
            accountFilter.and(new QFilter("issetbankinterface", "=", (Object)true));
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "finaccount"));
        listShowParameter.setMultiSelect(false);
        listShowParameter.getListFilterParameter().getQFilters().add(accountFilter);
    }

    private void setMustPutByInvestvarieties() {
        Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).ifPresent(investType -> {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InvestTypeEnum.isFixed((String)investType), (String[])new String[]{"expiredate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InvestTypeEnum.isNotice((String)investType), (String[])new String[]{"prenoticeday"});
        });
    }

    private void setMustInputByInterestType() {
        String intType = (String)this.getModel().getValue("interesttype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InterestTypeEnum.isFixed((String)intType), (String[])new String[]{"interestrate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType), (String[])new String[]{"referencerate", "ratesign", "ratefloatpoint", "rateadjuststyle"});
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType)) {
            this.getModel().setValue("interestrate", null);
            this.getModel().setValue("rateadjuststyle", (Object)RateResetEnum.deadline.getValue());
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("ratesign"))) {
                this.getModel().setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
            }
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"referencerate", null);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"ratesign", null);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"ratefloatpoint", null);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"rateadjuststyle", null);
        }
    }

    private void setDepositApplyProp() {
        DynamicObject applyBill = (DynamicObject)this.getModel().getValue("apply");
        if (EmptyUtil.isEmpty((DynamicObject)applyBill)) {
            return;
        }
        this.getModel().setValue("org", applyBill.get("org"));
        this.getModel().setValue("investvarieties", applyBill.get("investvarieties"));
        this.getModel().setValue("finorginfo", applyBill.get("finorginfo"));
        this.getModel().setValue("remark", applyBill.get("remark"));
        this.getModel().setValue("currency", applyBill.get("currency"));
        this.getModel().setValue("amount", applyBill.get("amount"));
        this.getModel().setValue("intdate", applyBill.get("intdate"));
        this.getModel().setValue("term", applyBill.get("term"));
        this.getModel().setValue("expiredate", applyBill.get("expiredate"));
        String intType = (String)applyBill.get("interesttype");
        this.getModel().setValue("interesttype", (Object)intType);
        this.getModel().setValue("tradechannel", applyBill.get("tradechannel"));
        this.getModel().setValue("deadline", applyBill.get("deadline"));
        if (InterestTypeEnum.isRange((String)intType)) {
            this.getModel().setValue("rangemin", (Object)applyBill.getBigDecimal("rangemin"));
            this.getModel().setValue("rangesign", (Object)applyBill.getString("rangesign"));
            this.getModel().setValue("rangemax", (Object)applyBill.getBigDecimal("rangemax"));
        }
        if (InterestTypeEnum.isFixed((String)intType)) {
            this.getModel().setValue("interestrate", applyBill.get("interestrate"));
        } else if (InterestTypeEnum.isFloat((String)intType)) {
            this.getModel().setValue("referencerate", applyBill.get("referencerate"));
            this.getModel().setValue("ratesign", applyBill.get("ratesign"));
            this.getModel().setValue("ratefloatpoint", applyBill.get("ratefloatpoint"));
        }
        this.setAcceptTransfer(applyBill);
    }

    private void calExpireDate(String tradeChannel) {
        Date expireDate;
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (!StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) {
            String term = (String)this.getModel().getValue("term");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
                return;
            }
            expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        } else {
            String deadLine = (String)this.getModel().getValue("deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, deadLine})) {
                return;
            }
            expireDate = DepositHelper.calEndDate((Date)intDate, (String)deadLine);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
    }

    private void calTermOrIntDate(String tradeChannel) {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (!StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) {
            Date intDate = (Date)this.getModel().getValue("intdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)intDate, (Date)expireDate));
        } else {
            String deadLine = (String)this.getModel().getValue("deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{deadLine, expireDate})) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)DepositHelper.calStartDate((Date)expireDate, (String)deadLine));
        }
    }

    private void validateExpireDate(BeforeFieldPostBackEvent e, Object value, String fieldName) {
        if (StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)((String)this.getModel().getValue("tradechannel")))) {
            return;
        }
        Date expireDate = DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            return;
        }
        if (expireDate.compareTo(intDate) <= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositDealEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.getView().updateView(fieldName);
        }
    }

    private void tradeChannelChgEvt(boolean isInit) {
        boolean isAddNew;
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        boolean isOnline = StringUtils.equals((CharSequence)tradeChannel, (CharSequence)TradeChannelEnum.ONLINE.getValue());
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus opStatus = billShowParameter.getStatus();
        boolean bl = isAddNew = opStatus == OperationStatus.ADDNEW;
        if (isOnline) {
            DynamicObject settleAccount = (DynamicObject)this.getModel().getValue("settleaccount");
            DynamicObject finOrgInfo = (DynamicObject)this.getModel().getValue("finorginfo");
            if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
                this.getModel().setValue("settleaccount", null);
            } else if (EmptyUtil.isNoEmpty((DynamicObject)settleAccount)) {
                DynamicObject settleAccountBank = (DynamicObject)settleAccount.get("bank");
                if (!finOrgInfo.getPkValue().equals(settleAccountBank.getPkValue())) {
                    this.getModel().setValue("settleaccount", null);
                }
            }
        }
        if ((isAddNew || !isInit) && isOnline) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
            String formId = this.getView().getFormShowParameter().getFormId();
            if ("cim_noticedeposit".equals(formId) || "ifm_notice_deposit".equals(formId)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"deadline", null);
            } else {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"deadline", (Object)DepositTermEnum.SIXMONTH.getValue());
            }
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"intdate", "demandrate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isOnline, (String[])new String[]{"deadline"});
        if (!(!isAddNew && isInit || isOnline)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"deadline", null);
        }
    }

    private void bizDateChgEvt() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("flage_redeposit")) {
            return;
        }
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("intdate", (Object)bizDate);
    }

    private QFilter getAccountFilter() {
        DynamicObject currency;
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"DepositDealEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return null;
        }
        QFilter qFilter = new QFilter("bank", "=", finOrg.getPkValue());
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)(org == null ? 0L : org.getLong("id")));
        qFilter.and(acctFilter);
        qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        DynamicObject applyBill = (DynamicObject)this.getModel().getValue("apply");
        if (EmptyUtil.isNoEmpty((DynamicObject)applyBill) && EmptyUtil.isNoEmpty((DynamicObject)(currency = applyBill.getDynamicObject("currency")))) {
            Object currrencyId = currency.getPkValue();
            qFilter.and(new QFilter("currency.fbasedataid", "=", currrencyId));
        }
        return qFilter;
    }

    private QFilter getSettleAccountFilter() {
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter statusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)(org == null ? 0L : org.getLong("id")));
        QFilter qFilter = statusFilter.and(acctFilter);
        if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
            DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
            if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"DepositDealEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return null;
            }
            qFilter = qFilter.and(new QFilter("bank", "=", finOrg.getPkValue()));
        }
        return qFilter;
    }

    private void intDateChgEvt() {
        this.calExpireDate((String)this.getModel().getValue("tradechannel"));
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isNoEmpty((Object)intDate)) {
            DateEdit intDateEdit = (DateEdit)this.getControl("expiredate");
            intDateEdit.setMinDate(DateUtils.getNextDay((Date)intDate, (int)1));
        }
    }

    private void reCalcDepositAmt() {
        String srcExpRedeposit = (String)this.getModel().getValue("srcexpireredeposit");
        if (!ExpireRedepositTypeEnum.isPrincipalInt((String)srcExpRedeposit)) {
            return;
        }
        BigDecimal srcPrincipal = (BigDecimal)this.getModel().getValue("srcprincipal");
        BigDecimal srcInt = (BigDecimal)this.getModel().getValue("srcinterest");
        this.getModel().setValue("amount", (Object)srcPrincipal.add(srcInt));
    }

    private void setSrcreMustInputWhenRedeposit() {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)((Boolean)this.getModel().getValue("isredepositgenerate")), (String[])new String[]{"srcexpireredeposit", "srcinterest"});
    }

    private void addBeforeF7Listener(List<String> baseDataFields) {
        for (String field : baseDataFields) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(field);
            if (EmptyUtil.isEmpty((Object)basedataEdit)) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void setAllRevenueAmt() {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"allamount", (Object)((BigDecimal)this.getModel().getValue("planamount")).add((BigDecimal)this.getModel().getValue("totalamount")));
    }

    private void setRangeRateMust() {
        String interestType = (String)this.getModel().getValue("interesttype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InterestTypeEnum.isRange((String)interestType), (String[])new String[]{"rangemin", "rangemax"});
    }

    private void setDefaultRate() {
        BigDecimal rangeMin = (BigDecimal)this.getModel().getValue("rangemin");
        BigDecimal rangeMax = (BigDecimal)this.getModel().getValue("rangemax");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rangeMin, rangeMax})) {
            return;
        }
        BigDecimal halfValue = rangeMin.add(rangeMax).divide(new BigDecimal("2"));
        this.getModel().setValue("interestrate", (Object)halfValue);
    }

    private void setAcceptTransfer(DynamicObject apply) {
        if (!apply.getBoolean("accepttransfer")) {
            return;
        }
        this.getModel().setValue("accepttransfer", (Object)apply.getBoolean("accepttransfer"));
        this.getModel().setValue("transferertype", apply.get("transferertype"));
        this.getModel().setValue("transferer", apply.get("transferer"));
        this.getModel().setValue("transfererid", apply.get("transfererid"));
        this.getModel().setValue("transferdate", apply.get("transferdate"));
        this.getModel().setValue("transferterm", apply.get("transferterm"));
        this.getModel().setValue("transferrevenue", apply.get("transferrevenue"));
        this.getModel().setValue("transferamount", apply.get("transferamount"));
    }

    private void setFinaccountF7() {
        String bankAcctNo = (String)this.getModel().getValue("finaccount");
        QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)bankAcctNo);
        DynamicObject bankAcctBill = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{qFilter});
        this.getModel().setValue("finaccountf7", (Object)bankAcctBill);
    }

    private void setTransferInfoByImport() {
        if (!((Boolean)this.getModel().getValue("accepttransfer")).booleanValue()) {
            return;
        }
        Date endDate = (Date)this.getModel().getValue("transferdate");
        Date startDate = (Date)this.getModel().getValue("intdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"transferterm", (Object)TermHelper.callTermLargeEqualZore((Date)startDate, (Date)endDate));
        }
        BigDecimal depositAmt = Optional.ofNullable((BigDecimal)this.getModel().getValue("amount")).orElse(BigDecimal.ZERO);
        BigDecimal transferRevenue = Optional.ofNullable((BigDecimal)this.getModel().getValue("transferrevenue")).orElse(BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"transferamount", (Object)depositAmt.add(transferRevenue));
        String transferType = Optional.ofNullable((String)this.getModel().getValue("transferertype")).orElse("");
        if ("other".equals(transferType)) {
            return;
        }
        String transferName = (String)this.getModel().getValue("transferer");
        List idList = QueryServiceHelper.queryPrimaryKeys((String)transferType, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)transferName)}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)idList)) {
            return;
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"transfererid", idList.get(0));
    }
}

