/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealReleaseTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        BillList revenueBillList;
        super.registerListener(e);
        BillList releaseBillList = (BillList)this.getControl("redeembilllistap");
        if (EmptyUtil.isNoEmpty((Object)releaseBillList) && OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            releaseBillList.addHyperClickListener((HyperLinkClickListener)this);
            QFilter qFilter = new QFilter("finbillno", "=", this.getModel().getValue("id"));
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            releaseBillList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
        }
        if (EmptyUtil.isNoEmpty((Object)(revenueBillList = (BillList)this.getControl("revenuebilllistap"))) && OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            revenueBillList.addHyperClickListener((HyperLinkClickListener)this);
            QFilter qFilter = new QFilter("sourcebillid", "=", this.getModel().getValue("id"));
            revenueBillList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
        }
    }

    public void beforeBindData(EventObject e) {
        BillList revenueBillList;
        super.beforeBindData(e);
        BillList releaseBillList = (BillList)this.getControl("redeembilllistap");
        QFilter qFilter = new QFilter("finbillno", "=", this.getModel().getValue("id"));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (EmptyUtil.isNoEmpty((Object)releaseBillList)) {
            releaseBillList.getFilterParameter().getQFilters().add(qFilter);
        }
        if (EmptyUtil.isNoEmpty((Object)(revenueBillList = (BillList)this.getControl("revenuebilllistap")))) {
            revenueBillList.getFilterParameter().getQFilters().add(new QFilter("loanbillno", "=", this.getModel().getValue("billno")));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "billno": {
                this.openBillPage(evt);
                break;
            }
            case "recbillno": {
                BillList sourceBill = (BillList)evt.getSource();
                Long focusRowPkId = (Long)sourceBill.getFocusRowPkId();
                String formId = sourceBill.getEntityId();
                TmcBotpHelper.showDirtBillParamter((String)formId, (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_recbill");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView("tabrevenueplan");
        } else if ("checkinterest".equals(operateKey)) {
            this.checkinterestShowForm();
        }
    }

    private void checkinterestShowForm() {
        IDataModel model = this.getModel();
        DynamicObject revenueEntry = (DynamicObject)model.getEntryEntity("revenue_entry").get(model.getEntryCurrentRowIndex("revenue_entry"));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("formId", "cim_revcaldetailcard");
        param.put("finBillId", this.getModel().getDataEntity().getPkValue());
        param.put("revenueEntryId", revenueEntry.getPkValue());
        param.put("fromDeposit", "true");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void openBillPage(HyperLinkClickEvent evt) {
        BillList sourceBill = (BillList)evt.getSource();
        String formId = sourceBill.getEntityId();
        Object pkId = sourceBill.getFocusRowPkId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

