/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.cim.formplugin.intbatch.AbstractNavigateAddPlugin;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositInnerNavigateAddPlugin
extends AbstractNavigateAddPlugin
implements BeforeF7SelectListener {
    @Override
    protected String chooseOpenFinBillId() {
        return "ifm_deposit";
    }

    @Override
    protected Map<String, Object> buildReturnData() {
        Map<String, Object> valMap = super.buildReturnData();
        valMap.put("formid", "ifm_depositprebatch");
        return valMap;
    }

    @Override
    protected QFilter setOpenFinBillFilter() {
        List<String> finStatus = Arrays.asList(FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue());
        QFilter qFilter = new QFilter("bizstatus", "in", finStatus);
        qFilter.and(new QFilter("isresubmit", "!=", (Object)Boolean.TRUE));
        this.addOrgFilter(qFilter);
        DynamicObject settlecenter = (DynamicObject)this.getModel().getValue("settlecenter");
        qFilter.and("finorginfo.number", "=", settlecenter.get("number"));
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            Set ids = currency.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            qFilter.and("currency", "in", ids);
        }
        Date endintdate = (Date)this.getModel().getValue("endintdate");
        qFilter.and(QFilter.isNotNull((String)"endpreinstdate").and("endpreinstdate", "<", (Object)DateUtils.getLastDay((Date)endintdate, (int)1)).or(QFilter.isNull((String)"endpreinstdate").and("intdate", "<=", (Object)DateUtils.getLastDay((Date)endintdate, (int)1))));
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qFilter.and("id", "not in", loanIds);
        }
        return qFilter;
    }

    private void addOrgFilter(QFilter qFilter) {
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            Set companyIds = company.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            qFilter.and("org", "in", companyIds);
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List companyIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"ifm_depositprebatch", (String)"47150e89000000ac");
            qFilter.and("org", "in", (Object)companyIds);
        }
    }

    @Override
    protected String chooseBatchPreFormId() {
        return "ifm_depositprebatch";
    }

    @Override
    protected Date getStartIntDate(DynamicObject finBill) {
        if (IntBillBatchHelper.isAutoWriteRed((DynamicObject)finBill)) {
            return DepositHelper.getIntCalcStartDate((DynamicObject)finBill);
        }
        Date lastPayinstDate = finBill.getDate("endpreinstdate");
        if (EmptyUtil.isNoEmpty((Object)lastPayinstDate)) {
            return DateUtils.getNextDay((Date)lastPayinstDate, (int)1);
        }
        return finBill.getDate("intdate");
    }

    @Override
    protected String getFunction() {
        return "preint";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settlecenter = (BasedataEdit)this.getControl("settlecenter");
        settlecenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String fieldName = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"settlecenter")) {
            this.setFinOrgFilter(event);
        }
    }

    private void setFinOrgFilter(BeforeF7SelectEvent event) {
        Set settleCenters = SettleCenterHelper.getAuthorizedSettleCenters((String)"ifm", (String)"ifm_depositprebatch", (String)"47150e89000000ac");
        List settleCenterIdList = settleCenters.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        Map finOrgInfoMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("finorgtype.type", "=", (Object)"1"), new QFilter("id", "in", settleCenterIdList)});
        List centerFinOrgIds = finOrgInfoMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", centerFinOrgIds);
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Object source = evt.getSource();
        if (!(source instanceof Control)) {
            return;
        }
        switch (key = ((Control)source).getKey()) {
            case "finbillno": {
                this.setDepositNumberFilter();
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next") && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"settlecenter")) {
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    private void setDepositNumberFilter() {
        DynamicObject settlecenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (settlecenter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ed3\u7b97\u4e2d\u5fc3\u201d\u3002", (String)"DepositInnerNavigateAddPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"endintdate")) {
            return;
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)this.chooseOpenFinBillId(), (boolean)true, (int)0, (boolean)true);
        parameter.getListFilterParameter().getQFilters().add(this.setOpenFinBillFilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "finbill"));
        parameter.setCustomParam("dataInclude", (Object)"fixedAndNotice");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

