/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DepositReleaseEdit
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setReleaseType();
        this.setRedeemDataRange();
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)((Boolean)this.getModel().getValue("isrevenue")), (String[])new String[]{"realrevenue"});
        this.setValueByParentListView();
        DepositHelper.setInterestRateShowName((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (field) {
            case "redeemdate": {
                if (((Boolean)this.getModel().getValue("accepttransfer")).booleanValue()) {
                    this.getModel().setValue("transferdate", this.getModel().getValue("redeemdate"));
                }
                if (!this.reSetReleaseType(oldValue)) break;
                this.reCalInterest();
                break;
            }
            case "amount": {
                if (!this.checkReleaseAmount(oldValue)) break;
                this.reCalInterest();
                break;
            }
            case "demandrate": 
            case "isrevenue": 
            case "releasetype": 
            case "accepttransfer": 
            case "interestrate": {
                this.reCalInterest();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        if (StringUtils.equals((CharSequence)"accountdate", (CharSequence)fieldName)) {
            this.validateAccountDate(e, fieldName);
        }
    }

    private void validateAccountDate(BeforeFieldPostBackEvent e, String fieldName) {
        Object value = e.getValue();
        Date redeemDate = (Date)this.getModel().getValue("redeemdate");
        if (EmptyUtil.isEmpty((Object)value) || EmptyUtil.isEmpty((Object)redeemDate)) {
            return;
        }
        Date accountDate = DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd");
        if (accountDate.compareTo(redeemDate) < 0) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5230\u8d26\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u89e3\u6d3b\u65e5\u671f\u3002", (String)"DepositReleaseEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.getView().updateView(fieldName);
        }
    }

    private void setReleaseType() {
        String investType = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isNotice((String)investType)) {
            this.setReleaseTypeComboItem(true);
        } else if (InvestTypeEnum.isFixed((String)investType)) {
            this.setReleaseTypeComboItem(false);
        }
    }

    private void setReleaseTypeComboItem(boolean isNotice) {
        ArrayList<ComboItem> releaseTypeList = new ArrayList<ComboItem>(2);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(isNotice ? ReleaseTypeEnum.agreeon.getName() : ReleaseTypeEnum.inadvance.getName()));
        comboItem1.setValue(isNotice ? ReleaseTypeEnum.agreeon.getValue() : ReleaseTypeEnum.inadvance.getValue());
        releaseTypeList.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setCaption(new LocaleString(isNotice ? ReleaseTypeEnum.temporary.getName() : ReleaseTypeEnum.expire.getName()));
        comboItem2.setValue(isNotice ? ReleaseTypeEnum.temporary.getValue() : ReleaseTypeEnum.expire.getValue());
        releaseTypeList.add(comboItem2);
        ComboEdit releaseControl = (ComboEdit)this.getControl("releasetype");
        releaseControl.setComboItems(releaseTypeList);
        this.getView().setEnable(Boolean.valueOf(isNotice), new String[]{"releasetype"});
    }

    private void reCalInterest() {
        Date redeemDate;
        if (!((Boolean)this.getModel().getValue("isrevenue")).booleanValue()) {
            this.getModel().setValue("predictinstamt", null);
            this.getModel().setValue("totalamount", this.getModel().getValue("amount"));
            this.getModel().deleteEntryData("entrys");
            return;
        }
        DynamicObject depositF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositF7, redeemDate = (Date)this.getModel().getValue("redeemdate")})) {
            return;
        }
        String releaseType = (String)this.getModel().getValue("releasetype");
        boolean useDemandRate = DepositHelper.judgeUseDemandRate((DynamicObject)depositF7, (String)releaseType, (Date)redeemDate);
        boolean isrevenue = (Boolean)this.getModel().getValue("isrevenue");
        boolean isHuge = (Boolean)this.getModel().getValue("accepttransfer");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isrevenue, (String[])new String[]{"realrevenue"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (isrevenue && useDemandRate && !isHuge ? 1 : 0) != 0, (String[])new String[]{"demandrate"});
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)this.getModel().getDataEntity(true), (boolean)isHuge);
        BigDecimal rateAmt = intBillInfo.getAmount().setScale(((DynamicObject)this.getModel().getValue("currency")).getInt("amtprecision"), RoundingMode.HALF_UP);
        this.getModel().setValue("predictinstamt", (Object)rateAmt);
        this.getModel().setValue("realrevenue", (Object)rateAmt);
        this.getModel().setValue("totalamount", (Object)((BigDecimal)this.getModel().getValue("amount")).add(rateAmt));
        DepositHelper.addRevenueCalDetailEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entrys"), (List)intBillInfo.getDetails());
        this.getView().updateView("entrys");
    }

    private boolean reSetReleaseType(Object oldValue) {
        Date redeemDate;
        DynamicObject investVar;
        DynamicObject depositF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositF7, investVar = (DynamicObject)this.getModel().getValue("investvarieties"), redeemDate = (Date)this.getModel().getValue("redeemdate")})) {
            return false;
        }
        Date startDate = depositF7.getDate("intdate");
        if (redeemDate.compareTo(startDate) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6d3b\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DepositReleaseEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"redeemdate", (Object)oldValue);
            return false;
        }
        if (InvestTypeEnum.isFixed((String)investVar.getString("investtype"))) {
            Date expireDate = depositF7.getDate("expiredate");
            Pair adjustPair = DepositHelper.getAdjustExpireDate((DynamicObject)depositF7, (Date)expireDate);
            Date adjustExpireDate = (Date)adjustPair.getLeft();
            AdjustMethodEnum adjustMethodEnum = (AdjustMethodEnum)adjustPair.getRight();
            if (redeemDate.compareTo(expireDate) < 0 && (expireDate.compareTo(adjustExpireDate) == 0 || adjustMethodEnum == AdjustMethodEnum.forward || adjustMethodEnum == AdjustMethodEnum.ad_forward) || redeemDate.compareTo(adjustExpireDate) < 0 && (adjustMethodEnum == AdjustMethodEnum.backward || adjustMethodEnum == AdjustMethodEnum.ad_backward)) {
                this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.inadvance.getValue());
            } else {
                this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.expire.getValue());
            }
        }
        return true;
    }

    private boolean checkReleaseAmount(Object oldValue) {
        BigDecimal surplusAmount = (BigDecimal)this.getModel().getValue("surplusamount");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, surplusAmount}) && amount.compareTo(surplusAmount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6d3b\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u53ef\u89e3\u6d3b\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DepositReleaseEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("amount", oldValue);
            return false;
        }
        return true;
    }

    private void setRedeemDataRange() {
        Date lastRevenueDate;
        DynamicObject depositBill = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        Date intDate = depositBill.getDate("intdate");
        Date lastRedeemDate = Optional.ofNullable(depositBill.getDate("lastredeemdate")).orElse(intDate);
        Date minDate = lastRedeemDate.compareTo(lastRevenueDate = Optional.ofNullable(depositBill.getDate("lastrevenuedate")).map(r -> DateUtils.getNextDay((Date)r, (int)1)).orElse(intDate)) >= 0 ? lastRedeemDate : lastRevenueDate;
        DateEdit redeemDate = (DateEdit)this.getControl("redeemdate");
        redeemDate.setMinDate(minDate);
    }

    private void setValueByParentListView() {
        IFormView parentView = this.getView().getParentView();
        if (EmptyUtil.isEmpty((Object)parentView)) {
            return;
        }
        String fromDepositList = parentView.getPageCache().get("fromDepositList");
        if (EmptyUtil.isNoEmpty((String)fromDepositList)) {
            this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.temporary.getValue());
        }
    }
}

