/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class HugeDepositEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static List<String> transferCols = Arrays.asList("accepttransfer", "transferertype", "transferer", "transferdate", "transferterm", "transferamount", "transferrevenue");
    private static final String CONST_RELEASE_STR = "release";

    public void registerListener(EventObject e) {
        TextEdit transferer;
        super.registerListener(e);
        BasedataEdit investVarieties = (BasedataEdit)this.getControl("investvarieties");
        investVarieties.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finOrg = (BasedataEdit)this.getControl("finorginfo");
        finOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit deposit = (BasedataEdit)this.getControl("deposit");
        if (EmptyUtil.isNoEmpty((Object)deposit)) {
            deposit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(transferer = (TextEdit)this.getControl("transferer")))) {
            transferer.addClickListener((ClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field;
        switch (field = evt.getProperty().getName()) {
            case "finorginfo": {
                this.setFinOrgInfoFilter(evt);
                break;
            }
            case "investvarieties": {
                this.setInvestVarietiesFilter(evt);
                break;
            }
            case "deposit": {
                this.setDepositF7Filter(evt);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTransferSwitchVisible();
        this.setTransferInfoMustInput();
        this.setTransferPeopleMustInput();
        this.setTransferDateRange(true);
        this.setTransferColumnName();
        this.setRedeemDateRange();
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "transferer": {
                String typePropDisplayName = this.getTypeDisplayName("transferertype");
                if ("other".equals(this.getModel().getValue("transferertype"))) break;
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u975e\u5176\u4ed6\u7c7b\u578b\uff0c\u4e0d\u80fd\u76f4\u63a5\u8f93\u5165\uff0c\u8bf7\u901a\u8fc7\u70b9\u51fb\u9009\u62e9\u3002", (String)"HugeDepositEdit_15", (String)"tmc-cim-formplugin", (Object[])new Object[0]), typePropDisplayName));
                this.getView().updateView(key);
                break;
            }
            case "accepttransfer": {
                if (!"cim_release".equals(this.getView().getEntityId()) || !EmptyUtil.isEmpty((Object)this.getModel().getValue("finbillno"))) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u201c\u5b58\u6b3e\u9009\u5355\u201d\u3002", (String)"HugeDepositEdit_16", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "applytype": {
                this.setTransferSwitchVisible();
                this.setTransferColumnName();
                break;
            }
            case "accepttransfer": {
                this.setTransferInfoMustInput();
                this.setTransferColumnName();
                this.clearDepositF7();
                this.clearInvestvarieties();
                break;
            }
            case "intdate": 
            case "term": 
            case "expiredate": {
                this.setTransferDateRange(false);
                break;
            }
            case "estimatedate": {
                this.getModel().setValue("transferdate", this.getModel().getValue("estimatedate"));
                break;
            }
            case "transferertype": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"transferer", null);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"transfererid", null);
                this.setTransferPeopleMustInput();
                break;
            }
            case "transferdate": {
                this.calTransferTerm();
                this.calTransferRevenue();
                break;
            }
            case "amount": 
            case "interestrate": 
            case "basis": {
                this.calTransferRevenue();
                break;
            }
            case "deposit": {
                this.setEstimateRedeemDateRange();
                break;
            }
            case "finbillno": {
                this.setRedeemDateRange();
                break;
            }
            case "investvarieties": {
                this.setTransferSwitchVisible();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String field;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (field = control.getKey()) {
            case "transferer": {
                String transferType = (String)this.getModel().getValue("transferertype");
                if (EmptyUtil.isEmpty((String)transferType)) {
                    switch (this.getView().getEntityId()) {
                        case "cim_release": {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d7\u8ba9\u4eba\u7c7b\u578b\u3002", (String)"DepositApplyEdit_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        case "cim_deposit_apply": {
                            if (CONST_RELEASE_STR.equals(this.getModel().getValue("applytype"))) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d7\u8ba9\u4eba\u7c7b\u578b\u3002", (String)"DepositApplyEdit_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            if ("deposit".equals(this.getModel().getValue("applytype"))) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f6c\u8ba9\u4eba\u7c7b\u578b\u3002", (String)"DepositApplyEdit_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        case "cim_deposit": {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f6c\u8ba9\u4eba\u7c7b\u578b\u3002", (String)"DepositApplyEdit_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
                if ("other".equals(transferType)) {
                    return;
                }
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)transferType, (boolean)false, (int)0, (boolean)true);
                if (OppUnitTypeEnum.BOSORG.getValue().equals(transferType)) {
                    parameter.setCustomParam("orgFuncId", (Object)"08");
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "transferer");
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "transferer": {
                if (!EmptyUtil.isNoEmpty((Object)returnData)) break;
                this.getModel().setValue("transferer", (Object)returnData.get(0).getName());
                this.getModel().setValue("transfererid", returnData.get(0).getPrimaryKeyValue());
                break;
            }
        }
    }

    private void setFinOrgInfoFilter(BeforeF7SelectEvent evt) {
        boolean isAcceptTransfer = (Boolean)this.getModel().getValue("accepttransfer");
        if (isAcceptTransfer) {
            List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            List scFinOrgTypeIds = DepositHelper.getScFinOrgTypeIds();
            qFilters.add(new QFilter("finorgtype", "not in", (Object)scFinOrgTypeIds));
        }
    }

    private void setTransferSwitchVisible() {
        if ("cim_deposit_apply".equals(this.getView().getFormShowParameter().getFormId()) && ((Boolean)this.getModel().getValue("inquiry")).booleanValue()) {
            return;
        }
        boolean isSc = DepositHelper.isSettleCenterBill((DynamicObject)this.getModel().getDataEntity());
        String investType = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        boolean isHuge = EmptyUtil.isEmpty((String)investType) || InvestTypeEnum.huge.getValue().equals(investType);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_deposit_apply".equals(formId)) {
            String applyType = Optional.ofNullable((String)this.getModel().getValue("applytype")).orElse("");
            boolean isDeposit = DepositApplyTypeEnum.DEPOSIT.getValue().equals(applyType) || DepositApplyTypeEnum.RELEASE.getValue().equals(applyType);
            this.getView().setVisible(Boolean.valueOf(!isSc && isDeposit && isHuge), new String[]{"accepttransfer"});
            boolean isMustInput = DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) && (Boolean)this.getModel().getValue("accepttransfer") != false;
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"estimatedate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(!isSc && isHuge), new String[]{"accepttransfer"});
        }
    }

    private void setTransferInfoMustInput() {
        boolean acceptTrans = (Boolean)this.getModel().getValue("accepttransfer");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)acceptTrans, (String[])new String[]{"transferertype", "transferdate", "transferrevenue"});
    }

    private void setTransferPeopleMustInput() {
        boolean acceptTrans = (Boolean)this.getModel().getValue("accepttransfer");
        String transferType = (String)this.getModel().getValue("transferertype");
        boolean isMust = acceptTrans && "bos_org".equals(transferType);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMust, (String[])new String[]{"transferer"});
    }

    private void setTransferDateRange(boolean isInit) {
        if (this.getView().getEntityId().contains(CONST_RELEASE_STR)) {
            return;
        }
        if (!isInit) {
            this.getModel().setValue("transferdate", null);
        }
        DateEdit dateControl = (DateEdit)this.getControl("transferdate");
        Date startDate = (Date)this.getModel().getValue("intdate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dateControl, startDate, expireDate})) {
            return;
        }
        dateControl.setMinDate(DateUtils.getNextDay((Date)startDate, (int)1));
        dateControl.setMaxDate(DateUtils.getLastDay((Date)expireDate, (int)1));
    }

    private void calTransferTerm() {
        Date expireDate = (Date)this.getModel().getValue("transferdate");
        Date intDate = this.getIntStartDate();
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            return;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"transferterm", (Object)TermHelper.callTermLargeEqualZore((Date)intDate, (Date)expireDate));
    }

    private void setInvestVarietiesFilter(BeforeF7SelectEvent e) {
        boolean acceptTransfer = (Boolean)this.getModel().getValue("accepttransfer");
        if (acceptTransfer) {
            List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("investtype", "=", (Object)InvestTypeEnum.huge.getValue()));
        }
    }

    private void calTransferRevenue() {
        DynamicObject deposit;
        Date endDate;
        boolean isAccpt = (Boolean)this.getModel().getValue("accepttransfer");
        if (!isAccpt) {
            return;
        }
        if (this.getView().getEntityId().equals("cim_deposit_apply") && DepositApplyTypeEnum.RELEASE.getValue().equals(this.getModel().getValue("applytype"))) {
            return;
        }
        Date startDate = this.getIntStartDate();
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate = (Date)this.getModel().getValue("transferdate")})) {
            return;
        }
        if (this.getView().getEntityId().contains(CONST_RELEASE_STR)) {
            deposit = (DynamicObject)this.getModel().getValue("finbillno");
            if (EmptyUtil.isNoEmpty((DynamicObject)deposit)) {
                deposit = TmcDataServiceHelper.loadSingle((Object)deposit.getPkValue(), (String)"cim_deposit");
            }
        } else {
            deposit = this.getModel().getDataEntity();
        }
        if (deposit == null) {
            return;
        }
        if (InterestTypeEnum.isFloat((String)deposit.getString("interesttype")) && EmptyUtil.isEmpty((DynamicObject)deposit.getDynamicObject("referencerate"))) {
            return;
        }
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)deposit, (Date)startDate, (Date)endDate);
        if (EmptyUtil.isNoEmpty((Object)intBillInfo)) {
            this.getModel().setValue("transferrevenue", (Object)intBillInfo.getAmount());
        }
    }

    private void setTransferColumnName() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_deposit_apply".equals(formId)) {
            String applyType = (String)this.getModel().getValue("applytype");
            if (DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) || DepositApplyTypeEnum.DEPOSIT.getValue().equals(applyType)) {
                Map<String, String> keyMap = DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) ? this.getTransfereeMap() : this.getTransfererMap();
                for (String key : transferCols) {
                    FieldEdit control = (FieldEdit)this.getControl(key);
                    control.setCaption(new LocaleString(keyMap.get(key)));
                }
                Map<String, Object> flexMap = DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) ? this.getTranseeflexMap() : this.getTranserflexMap();
                this.getView().updateControlMetadata("transferinfo", flexMap);
            }
        }
    }

    private void setDepositF7Filter(BeforeF7SelectEvent e) {
        boolean acceptTransfer = (Boolean)this.getModel().getValue("accepttransfer");
        if (acceptTransfer) {
            QFilter invFilter = new QFilter("investtype", "=", (Object)InvestTypeEnum.huge.getValue());
            invFilter.and(new QFilter("enable", "=", (Object)"1"));
            List invarIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_investvarieties", (QFilter[])new QFilter[]{invFilter}, (String)"", (int)-1);
            List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("investvarieties", "in", (Object)invarIds));
        }
    }

    private void clearDepositF7() {
        if ("cim_deposit_apply".equals(this.getView().getEntityId())) {
            String applyType = (String)this.getModel().getValue("applytype");
            if (DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) {
                this.getModel().setValue("deposit", null);
            }
            boolean isMustInput = DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) && (Boolean)this.getModel().getValue("accepttransfer") != false;
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"estimatedate"});
        }
    }

    private void clearInvestvarieties() {
        if ("cim_deposit_apply".equals(this.getView().getEntityId())) {
            this.getModel().setValue("investvarieties", null);
        }
    }

    private void setEstimateRedeemDateRange() {
        if (!((Boolean)this.getModel().getValue("accepttransfer")).booleanValue()) {
            return;
        }
        DateEdit dateControl = (DateEdit)this.getControl("estimatedate");
        Date startDate = (Date)this.getModel().getValue("intdate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dateControl, startDate, expireDate})) {
            return;
        }
        dateControl.setMinDate(DateUtils.getNextDay((Date)startDate, (int)1));
        dateControl.setMaxDate(DateUtils.getLastDay((Date)expireDate, (int)1));
    }

    private void setRedeemDateRange() {
        if (!((Boolean)this.getModel().getValue("accepttransfer")).booleanValue()) {
            return;
        }
        if (!this.getView().getEntityId().contains(CONST_RELEASE_STR)) {
            return;
        }
        DateEdit dateControl = (DateEdit)this.getControl("redeemdate");
        DynamicObject deposit = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)deposit)) {
            return;
        }
        Date startDate = deposit.getDate("intdate");
        Date expireDate = deposit.getDate("expiredate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dateControl, startDate, expireDate})) {
            return;
        }
        dateControl.setMinDate(DateUtils.getNextDay((Date)startDate, (int)1));
        dateControl.setMaxDate(DateUtils.getLastDay((Date)expireDate, (int)1));
    }

    private Date getIntStartDate() {
        Date intDate = this.getView().getEntityId().contains(CONST_RELEASE_STR) ? (Date)Optional.ofNullable((DynamicObject)this.getModel().getValue("finbillno")).map(r -> r.getDate("intdate")).orElse(null) : (Date)this.getModel().getValue("intdate");
        return intDate;
    }

    private Map<String, String> getTransfererMap() {
        HashMap<String, String> transfererMap = new HashMap<String, String>(8);
        transfererMap.put("accepttransfer", ResManager.loadKDString((String)"\u53d7\u8ba9", (String)"HugeDepositEdit_8", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfererMap.put("transferertype", ResManager.loadKDString((String)"\u8f6c\u8ba9\u4eba\u7c7b\u578b", (String)"HugeDepositEdit_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfererMap.put("transferer", ResManager.loadKDString((String)"\u8f6c\u8ba9\u4eba", (String)"HugeDepositEdit_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfererMap.put("transferdate", ResManager.loadKDString((String)"\u8f6c\u8ba9\u65e5\u671f", (String)"HugeDepositEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfererMap.put("transferterm", ResManager.loadKDString((String)"\u8f6c\u8ba9\u4eba\u6301\u6709\u671f\u9650\uff08ymd\uff09", (String)"HugeDepositEdit_11", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfererMap.put("transferamount", ResManager.loadKDString((String)"\u8f6c\u8ba9\u91d1\u989d", (String)"HugeDepositEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfererMap.put("transferrevenue", ResManager.loadKDString((String)"\u8f6c\u8ba9\u4eba\u6536\u76ca\u91d1\u989d", (String)"HugeDepositEdit_12", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        return transfererMap;
    }

    private Map<String, String> getTransfereeMap() {
        HashMap<String, String> transfereeMap = new HashMap<String, String>(8);
        transfereeMap.put("accepttransfer", ResManager.loadKDString((String)"\u8f6c\u8ba9", (String)"HugeDepositEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfereeMap.put("transferertype", ResManager.loadKDString((String)"\u53d7\u8ba9\u4eba\u7c7b\u578b", (String)"HugeDepositEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfereeMap.put("transferer", ResManager.loadKDString((String)"\u53d7\u8ba9\u4eba", (String)"HugeDepositEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfereeMap.put("transferdate", ResManager.loadKDString((String)"\u8f6c\u8ba9\u65e5\u671f", (String)"HugeDepositEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfereeMap.put("transferterm", ResManager.loadKDString((String)"\u6301\u6709\u671f\u9650\uff08ymd\uff09", (String)"HugeDepositEdit_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfereeMap.put("transferamount", ResManager.loadKDString((String)"\u8f6c\u8ba9\u91d1\u989d", (String)"HugeDepositEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        transfereeMap.put("transferrevenue", ResManager.loadKDString((String)"\u6536\u76ca\u91d1\u989d", (String)"HugeDepositEdit_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        return transfereeMap;
    }

    private Map<String, Object> getTranserflexMap() {
        HashMap<String, Object> transerflexMap = new HashMap<String, Object>(8);
        transerflexMap.put("text", ResManager.getLocaleString((String)"\u53d7\u8ba9\u4fe1\u606f", (String)"HugeDepositEdit_13", (String)"tmc-cim-formplugin"));
        return transerflexMap;
    }

    private Map<String, Object> getTranseeflexMap() {
        HashMap<String, Object> transeeflexMap = new HashMap<String, Object>(8);
        transeeflexMap.put("text", ResManager.getLocaleString((String)"\u8f6c\u8ba9\u4fe1\u606f", (String)"HugeDepositEdit_14", (String)"tmc-cim-formplugin"));
        return transeeflexMap;
    }

    private String getTypeDisplayName(String typePropName) {
        ComboEdit control = (ComboEdit)this.getControl(typePropName);
        LocaleString typeDisplayName = control.getProperty().getDisplayName();
        String typePropDisplayName = typeDisplayName.toString();
        return typePropDisplayName;
    }
}

