/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.DateEdit;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class NoticeDepositEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isRedepositGen()) {
            DynamicObject srcDeposit = this.getSrcDeposit();
            if (srcDeposit == null) {
                return;
            }
            Date intDate = srcDeposit.getDate("intdate");
            DateEdit intDateEdit = (DateEdit)this.getControl("intdate");
            intDateEdit.setMinDate(intDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"intdate")) {
            this.handleIntDateChange();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"srcinterest")) {
            this.handleSrcInterestChange();
        }
    }

    private void handleIntDateChange() {
        if (!this.isRedepositGen()) {
            return;
        }
        DynamicObject srcDeposit = this.getSrcDeposit();
        if (srcDeposit == null) {
            return;
        }
        Date intDate = (Date)this.getModel().getValue("intdate");
        String bizStatus = srcDeposit.getString("bizstatus");
        Date beginDate = StringUtils.equals((CharSequence)bizStatus, (CharSequence)FinServiceStatusEnum.subscribe_part.getValue()) && EmptyUtil.isNoEmpty((Object)srcDeposit.getDate("lastredeemdate")) ? srcDeposit.getDate("lastredeemdate") : srcDeposit.getDate("intdate");
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)srcDeposit, (Date)beginDate, (Date)intDate);
        BigDecimal intAmt = null == intBillInfo ? BigDecimal.ZERO : intBillInfo.getAmount();
        this.getModel().setValue("srcinterest", (Object)intAmt);
    }

    private void handleSrcInterestChange() {
        if (!this.isRedepositGen()) {
            return;
        }
        BigDecimal intAmt = (BigDecimal)this.getModel().getValue("srcinterest");
        BigDecimal srcPrincipal = (BigDecimal)this.getModel().getValue("srcprincipal");
        BigDecimal principal = EmptyUtil.isNoEmpty((BigDecimal)intAmt) ? intAmt.add(srcPrincipal) : srcPrincipal;
        this.getModel().setValue("amount", (Object)principal);
    }

    private DynamicObject getSrcDeposit() {
        Long srcDepositId = (Long)this.getModel().getValue("srcdepositid");
        if (EmptyUtil.isEmpty((Long)srcDepositId)) {
            return null;
        }
        return TmcDataServiceHelper.loadSingle((Object)srcDepositId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_noticedeposit"));
    }

    private boolean isRedepositGen() {
        return (Boolean)this.getModel().getValue("isredepositgenerate");
    }
}

