/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.formplugin.deposit.AbstractDepositList;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;

public class NoticeDepositList
extends AbstractDepositList {
    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qFilter = new QFilter("isinit", "=", (Object)Boolean.TRUE);
        QFilter initQfilter = qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter unionFilter = initQfilter.or(new QFilter("isinit", "=", (Object)Boolean.FALSE));
        e.getQFilters().add(unionFilter);
    }

    @Override
    public String[] chooseInvestType() {
        return new String[]{InvestTypeEnum.notice.getValue()};
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"pushrelease")) {
            this.getPageCache().put("fromDepositList", "true");
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        boolean isSuccess = Optional.ofNullable(args.getOperationResult()).map(r -> r.isSuccess()).orElse(false);
        if (!isSuccess) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "releaseapply": {
                this.openReleaseApplyBill();
                break;
            }
        }
    }

    private void openReleaseApplyBill() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        BillShowParameter param = new BillShowParameter();
        param.setFormId("cim_deposit_apply");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.EDIT);
        param.setCustomParam("depositId", selectedRows.get(0).getPrimaryKeyValue());
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    protected String getTips() {
        return CimFormResourceEnum.DepositDealList_11.loadKDString();
    }
}

