/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.helper.EntityMapBizHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DptRevenueBatchEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
        this.getModel().setValue("loannum", (Object)entry.getString("loanbillno"));
        IntBillBatchHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
    }

    public void afterBindData(EventObject e) {
        this.loanIntEntry(0);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "intdetailnum": {
                this.showDptRevenueBill(rowIndex);
                break;
            }
            case "loanbillno": {
                this.showDepositBill(rowIndex);
                break;
            }
            case "interestamt": {
                this.showIntDetailForm(rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentryloans": {
                String errMsg = this.checkLoansEntry();
                if (EmptyUtil.isNoEmpty((String)errMsg)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                this.dealInterest();
                break;
            }
            case "addentryloans": {
                args.setCancel(true);
                this.openAddNewNavigateForm(this.initParams());
                break;
            }
        }
    }

    private void openAddNewNavigateForm(FormShowParameter showParameter) {
        String entityName = this.getView().getEntityId();
        String formId = StringUtils.equals((CharSequence)entityName, (CharSequence)"cim_dptrevenuebatch") ? "cim_dptrevenue_navigate" : "ifm_dptrevenue_naviga";
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_bake_key_filter"));
        this.getView().showForm(showParameter);
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getLong("loanbillid")).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanIds", loanIds);
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
            initParams.put("settlecenter", settleCenter.getPkValue());
            DynamicObject finorgtype = QueryServiceHelper.queryOne((String)"bd_finorgtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", settleCenter.getDynamicObject("finorgtype").getPkValue())});
            if (EmptyUtil.isNoEmpty((DynamicObject)finorgtype)) {
                initParams.put("settlecenterdpt", "1".equals(finorgtype.getString("type")));
            }
        }
        initParams.put("revenuedate", this.getModel().getValue("revenuedate"));
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        for (DynamicObject dyn : entrys) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
            currenyIds.add(dyn.getDynamicObject("currency").getPkValue().toString());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    private void dealInterest() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)cl.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)"cim_dptrevenue")) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"cim_dptrevenue", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_dptrevenue", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55", (String)"DptRevenueBatchEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"close_bake_key_filter", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map navparam = (Map)evt.getReturnData();
            List<Map<String, Object>> intDetail = this.genIntDetails(navparam.get("calcIntResult").toString());
            if (EmptyUtil.isEmpty(intDetail)) {
                return;
            }
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail, (boolean)false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("summary", (Object)ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u7f16\u53f7+\u3010\u5b58\u6b3e\u5355\u7f16\u53f7\u3011+\u3010\u6536\u76ca\u65e5\u671f\u3011+\u6536\u76ca+\u3010\u5e01\u79cd\u3011+\u3010\u5b9e\u4ed8\u6536\u76ca\u3011", (String)"DptRevenueBatchEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        JSONObject navparam = (JSONObject)this.getView().getFormShowParameter().getCustomParams().get("navparam");
        if (EmptyUtil.isEmpty((Object)navparam)) {
            return;
        }
        this.getModel().setValue("revenuedate", (Object)DateUtils.stringToDate((String)((String)navparam.get((Object)"endintdate")), (String)"yyyy-MM-dd"));
        List<Map<String, Object>> intDetail = this.genIntDetails(navparam.get((Object)"calcIntResult").toString());
        if (EmptyUtil.isEmpty(intDetail)) {
            return;
        }
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail);
        this.dealNoBotpTake(intDetail);
        DynamicObject permOrg = TmcOrgDataHelper.getCurrentAuthPermOrg((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (long)RequestContext.get().getOrgId());
        if (EmptyUtil.isNoEmpty((DynamicObject)permOrg)) {
            this.getModel().setValue("org", permOrg.getPkValue());
        }
    }

    private void dealNoBotpTake(List<Map<String, Object>> intDetail) {
        Set depositIdSet = intDetail.stream().map(r -> r.get("loanbillid")).collect(Collectors.toSet());
        EntityMapBizHelper.dealNoneBotpPush(depositIdSet, (String)"cim_deposit", (IDataModel)this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "actualinstamt": {
                this.resetIntComment(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operateKey = (FormOperate)args.getSource();
        switch (operateKey.getOperateKey()) {
            case "save": 
            case "submit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "deleteentryloans": {
                this.getView().invokeOperation("save");
            }
        }
        this.loanIntEntry(0);
    }

    private void resetIntComment(PropertyChangedArgs e) {
        int entryRowCount = e.getChangeSet()[0].getRowIndex();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", entryRowCount);
        BigDecimal actualInstAmt = entry.getBigDecimal("actualinstamt");
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"cim_deposit", (String)"id,billno,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", entry.get("loanbillid"))});
        String intComment = DepositHelper.buildIntComment((DynamicObject)loanBill, (BigDecimal)actualInstAmt, (Date)((Date)this.getModel().getValue("revenuedate")));
        this.getModel().setValue("intcomment", (Object)intComment, entryRowCount);
    }

    private List<Map<String, Object>> genIntDetails(String calcIntResultStr) {
        DynamicObject[] loanBills;
        Map calcIntResult = (Map)JSON.parseObject((String)calcIntResultStr, (TypeReference)new TypeReference<Map<Object, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList<Map<String, Object>> intDetails = new ArrayList<Map<String, Object>>(calcIntResult.size());
        for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((Object[])calcIntResult.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit"))) {
            this.fillDepositIntDetail(loanBill, (IntBillInfo)calcIntResult.get(loanBill.getPkValue()), intDetails);
        }
        return intDetails;
    }

    protected void fillDepositIntDetail(DynamicObject finBill, IntBillInfo intBill, List<Map<String, Object>> dataMap) {
        if (EmptyUtil.isEmpty((Object)intBill) || EmptyUtil.isEmpty((BigDecimal)intBill.getAmount())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("company", finBill.getDynamicObject("org"));
        DynamicObject currency = finBill.getDynamicObject("currency");
        data.put("currency", currency);
        data.put("finorginfo", finBill.getDynamicObject("finorginfo"));
        data.put("loanbillid", finBill.getLong("id"));
        String depositNo = finBill.getString("billno");
        data.put("investvarieties", finBill.get("investvarieties"));
        data.put("loanbillno", depositNo);
        data.put("startdate", intBill.getBeginDate());
        data.put("enddate", intBill.getEndDate());
        Integer days = intBill.getDetails().stream().map(r -> r.getDays()).reduce((a, b) -> a + b).orElse(0);
        data.put("intdays", days);
        BigDecimal revenueAmt = intBill.getAmount();
        data.put("interestamt", revenueAmt);
        data.put("actualinstamt", revenueAmt);
        data.put("intcomment", DepositHelper.buildIntComment((DynamicObject)finBill, (BigDecimal)revenueAmt, (Date)((Date)this.getModel().getValue("revenuedate"))));
        data.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(data);
    }

    private void showDptRevenueBill(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        BillShowParameter parameter = new BillShowParameter();
        long revenuId = rowEntity.getLong("intbillid");
        boolean exists = QueryServiceHelper.exists((String)"cim_dptrevenue", (Object)revenuId);
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DptRevenueBatchEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        parameter.setPkId((Object)revenuId);
        String batchBillFormId = this.getView().getEntityId();
        Pair batchRevenuePair = DepositHelper.getBatchRevenuePair((String)batchBillFormId, null);
        parameter.setFormId((String)batchRevenuePair.getRight());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showDepositBill(int index) {
        Object pkId = this.getModel().getValue("loanbillid", index);
        DynamicObject billDyn = TmcDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"cim_deposit");
        if (EmptyUtil.isEmpty((DynamicObject)billDyn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DptRevenueBatchEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        String batchBillFormId = this.getView().getEntityId();
        Pair batchRevenuePair = DepositHelper.getBatchRevenuePair((String)batchBillFormId, (DynamicObject)billDyn);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId(pkId);
        parameter.setFormId((String)batchRevenuePair.getLeft());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        String callIntStr = entry.getString("intdetail_tag");
        parameter.getCustomParams().put("intdetail_tag", callIntStr);
        parameter.getCustomParams().put("currency", entry.getDynamicObject("currency").getPkValue());
        parameter.getCustomParams().put("fromDeposit", "true");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("cim_revcaldetailcard");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }
}

