/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class DptRevenueList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        DepositHelper.removeSpareFilter((FilterContainerInitArgs)args, (String)((BillList)this.getControl("billlistap")).getBillFormId());
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"org.name", (CharSequence)fieldName)) continue;
            filterColumn.setDefaultValue("");
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "pushifmrevenue": {
                Long selectedId = this.getSelectedId();
                if (!EmptyUtil.isEmpty((Long)selectedId)) break;
                args.setCancel(true);
                break;
            }
            case "push2rec": {
                this.validateBeforePushRec(args);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String entityName = this.getDataEntityName();
        if (StringUtils.startsWith((CharSequence)entityName, (CharSequence)"ifm")) {
            QFilter filter = new QFilter("finorginfo.finorgtype.type", "=", (Object)"1");
            filter.and(new QFilter("datasource", "=", (Object)"ifm").or(new QFilter("datasource", "=", (Object)"cim").and(new QFilter("confirmstatus", "=", (Object)"yetconfirm"))));
            e.getQFilters().add(filter);
        } else if (!DepositHelper.isCimRelateAppSet()) {
            e.getQFilters().add(new QFilter("finorginfo.finorgtype.type", "!=", (Object)"1"));
        }
        e.getQFilters().add(new QFilter("id", "not in", this.getIntIds()));
    }

    private void validateBeforePushRec(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        String billFormId = billList.getBillFormId();
        DynamicObject dptRevenue = TmcDataServiceHelper.loadSingle((Object)billPkId, (String)billFormId, (String)"finorginfo,billstatus");
        if (EmptyUtil.isEmpty((DynamicObject)dptRevenue)) {
            return;
        }
        String operateName = ((FormOperate)args.getSource()).getOperateName().getLocaleValue();
        String validateMsg = DepositHelper.validateSettleBill((DynamicObject)dptRevenue, (String)operateName);
        if (EmptyUtil.isNoEmpty((String)validateMsg)) {
            this.getView().showTipNotification(validateMsg);
            args.setCancel(true);
            return;
        }
        String billStatus = dptRevenue.getString("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"DptRevenueList_0", (String)"tmc-cim-formplugin", (Object[])new Object[]{operateName}));
            args.setCancel(true);
        }
    }

    private Set<Long> getIntIds() {
        DynamicObjectCollection intbillentries = QueryServiceHelper.query((String)"cim_dptrevenuebatch", (String)"entry.intbillid", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}), new QFilter("entry.intbillid", "!=", (Object)0L)});
        DynamicObjectCollection intbills = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)intbillentries.stream().map(o -> o.get("entry.intbillid")).toArray()), new QFilter("billstatus", "=", (Object)"B")});
        HashSet<Long> intIds = new HashSet<Long>();
        intbills.stream().forEach(item -> intIds.add(item.getLong("id")));
        intIds.remove(0L);
        return intIds;
    }
}

