/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenuePlanEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit depositBill = (TextEdit)this.getControl("depositbill");
        if (EmptyUtil.isNoEmpty((Object)depositBill)) {
            depositBill.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"depositbill", null);
    }

    public void afterBindData(EventObject e) {
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"depositbill", (Object)this.getModel().getValue("billno"));
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"depositbill"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"org"});
        this.setCanEditByIntState();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "calinstplan": {
                if (this.validateDepositBillNull()) {
                    args.setCancel(true);
                    break;
                }
                this.beforeDoSystemCalc(args);
                break;
            }
            case "instplansave": {
                if (!this.validateDepositBillNull()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = args.getOperateKey()) {
            case "instplansave": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                this.getModel().setDataChanged(false);
                break;
            }
            case "calinstplan": {
                this.calIntByPlan();
                this.setCanEditByIntState();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "depositbill": {
                this.openDepositBill();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        switch (e.getActionId()) {
            case "depositbill": {
                if (!EmptyUtil.isNoEmpty((Object)returnData)) break;
                Object id = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
                ((IBillModel)this.getModel()).load(id);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"depositbill", (Object)((ListSelectedRowCollection)returnData).get(0).getBillNo());
                this.getView().updateView();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "handInstPlan_callBackId": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ispassVoid", "true");
                    this.getView().invokeOperation("calinstplan", option);
                    break;
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"handinstplan", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("revenue_entry".equals(entryName)) {
            for (int rowIndex : e.getRowIndexs()) {
                String repayState = (String)this.getModel().getValue("revenuestate", rowIndex);
                if (!"1".equals(repayState)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u72b6\u6001\u4e3a\u201c\u5df2\u6267\u884c\u201d\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DptRevenuePlanEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private void openDepositBill() {
        String formId = this.getView().getFormShowParameter().getFormId();
        ListShowParameter paramter = formId.startsWith("cim_") ? ShowFormHelper.createShowListForm((String)"cim_deposit", (boolean)false, (int)0, (boolean)true) : ShowFormHelper.createShowListForm((String)"ifm_deposit", (boolean)false, (int)0, (boolean)true);
        QFilter qFilter = new QFilter("bizstatus", "!=", (Object)FinServiceStatusEnum.subscribe_end.getValue());
        Set authedOrgIds = DepositHelper.getRevPlanAuthedOrgIds((String)this.getView().getFormShowParameter().getAppId(), (String)formId);
        QFilter orgQFilter = new QFilter("org.id", "in", (Object)authedOrgIds);
        qFilter.and(orgQFilter);
        QFilter finOrgFilter = formId.startsWith("cim_") ? new QFilter("finorginfo.finorgtype.type", "=", (Object)"1").and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).or(new QFilter("finorginfo.finorgtype.type", "!=", (Object)"1")) : new QFilter("finorginfo.finorgtype.type", "=", (Object)"1");
        qFilter.and(finOrgFilter);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        paramter.getListFilterParameter().setFilter(qFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "depositbill");
        paramter.setCloseCallBack(closeCallBack);
        paramter.setCustomParam("dataInclude", (Object)"fixedAndNotice");
        this.getView().showForm((FormShowParameter)paramter);
    }

    private void setCanEditByIntState() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("revenue_entry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)entrys.get(i);
            if (repayPlan.getInt("revenuestate") != 1) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"revenuedate", "revenuecalamount", "revenuedesc"});
        }
    }

    private void beforeDoSystemCalc(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean isHandinstPlan = (Boolean)this.getModel().getValue("handinstplan");
        if (!"true".equals(formOperate.getOption().getVariableValue("ispassVoid", "")) && !isHandinstPlan) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u73b0\u6709\u7684\u6536\u76ca\u8ba1\u5212\u4fe1\u606f\uff0c\u518d\u5e26\u51fa\u7cfb\u7edf\u6d4b\u7b97\u7684\u6536\u76ca\u8ba1\u5212\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"DptRevenuePlanEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("handInstPlan_callBackId", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private boolean validateDepositBillNull() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("depositbill"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5b58\u6b3e\u7f16\u53f7\u3002", (String)"DptRevenuePlanEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void calIntByPlan() {
        DepositHelper.resetRevenueProjectEntry((DynamicObject)this.getModel().getDataEntity(true));
        this.getView().updateView("revenue_entry");
    }
}

