/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import java.util.Optional;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.formplugin.deposit.AbstractDepositList;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenuePlanList
extends AbstractDepositList {
    @Override
    public String[] chooseInvestType() {
        return new String[]{InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue(), InvestTypeEnum.notice.getValue()};
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        Set authedOrgIds = DepositHelper.getRevPlanAuthedOrgIds((String)this.getView().getFormShowParameter().getAppId(), (String)formId);
        e.getQFilters().add(new QFilter("org.id", "in", (Object)authedOrgIds));
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "check_loan": {
                BillShowParameter param = new BillShowParameter();
                Long selectedId = this.getSelectedId();
                if (!EmptyUtil.isNoEmpty((Long)selectedId)) break;
                param.setPkId((Object)selectedId);
                param.setFormId(this.getBillFormId(selectedId));
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setBillStatus(BillOperationStatus.VIEW);
                param.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private String getBillFormId(Long selectedId) {
        String formId = "";
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle((String)"cim_deposit", (String)"investvarieties,finorginfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId)});
        boolean isSettCenter = DepositHelper.isSettleCenterBill((DynamicObject)depositBill);
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        formId = isSettCenter ? (InvestTypeEnum.isNotice((String)investType) ? "ifm_notice_deposit" : "ifm_deposit") : (InvestTypeEnum.isNotice((String)investType) ? "cim_noticedeposit" : "cim_deposit");
        return formId;
    }
}

