/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finbase;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemRevenueBaseEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit finBillNo = (BasedataEdit)this.getControl("finbillno");
        finBillNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit finAccount = (TextEdit)this.getControl("recaccount");
        finAccount.addButtonClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "finbillno": {
                this.FinBillNoChgEvt();
                break;
            }
            case "recaccount": {
                this.isClearFinAccountF7();
            }
        }
    }

    private void FinBillNoChgEvt() {
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            if (!this.checkRedeem(finBillNoF7)) {
                this.getModel().setValue("finbillno", null);
                return;
            }
            this.getModel().deleteEntryData("billhead_lk");
            DataEntityPropertyCollection propertys = finBillNoF7.getDataEntityType().getProperties();
            DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty prop : propertys) {
                if (!this.copyPropertys().contains(prop.getName()) || !props.containsKey((Object)prop.getName()) && !"name".equals(prop.getName())) continue;
                if ("name".equals(prop.getName())) {
                    this.getModel().setValue("productname", finBillNoF7.get(prop.getName()));
                    continue;
                }
                this.getModel().setValue(prop.getName(), finBillNoF7.get(prop.getName()));
            }
            QFilter qFilter = new QFilter("finbillno", "=", finBillNoF7.getPkValue());
            if (OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
                qFilter.and("id", "!=", this.getModel().getValue("id"));
            }
            DynamicObjectCollection lastBill = QueryServiceHelper.query((String)CimEntityEnum.cim_redeem.getValue(), (String)"count", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)1);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"count", (Object)1);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)lastBill)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"count", (Object)(((DynamicObject)lastBill.get(0)).getInt("count") + 1));
            }
        }
    }

    private boolean checkRedeem(DynamicObject finBillNoF7) {
        QFilter idFilter = new QFilter("finbillno", "=", finBillNoF7.getPkValue());
        QFilter auditFilter = idFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter beBankFilter = new QFilter("finbillno", "=", finBillNoF7.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and("bebankstatus", "not in", (Object)new String[]{BebankStatusEnum.TF.getValue(), BebankStatusEnum.TS.getValue()});
        QFilter qFilter = auditFilter.or(beBankFilter);
        boolean existsRed = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])qFilter.toArray());
        if (existsRed) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7533\u8d2d\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u8d4e\u56de\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8d4e\u56de\u6536\u76ca\u64cd\u4f5c\u3002", (String)"RedeemRevenueBaseEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void isClearFinAccountF7() {
        if (!this.getPageCache().getAll().containsKey("finclick")) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"recaccountf7", null);
        } else {
            this.getPageCache().remove("finclick");
        }
    }

    protected List copyPropertys() {
        return Arrays.asList("currency", "name", "productno", "finorginfo", "finaccount", "redeemway", "redeempattern", "revenuetype", "bonusway", "revenueproject", "finaccountf7", "investvarieties", "basis", "securitiesaccno");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "finbillno": {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)org)) {
                    evt.setCancel(true);
                    TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"org");
                    break;
                }
                Long orgId = org.getLong("id");
                qFilters.add(new QFilter("org", "=", (Object)orgId));
                qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        if (evt.getSource() instanceof Control && "recaccount".equals(key = ((Control)evt.getSource()).getKey())) {
            this.showF7AccountBank(key);
        }
    }

    private void showF7AccountBank(String key) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter statusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        QFilter qFilter = statusFilter.and(acctFilter);
        if (this.isOnline()) {
            qFilter.and("issetbankinterface", "=", (Object)"1");
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)"recaccount", (CharSequence)e.getActionId()) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            ListSelectedRow selectedRow = rows.get(0);
            String number = selectedRow.getNumber();
            this.getModel().setValue(e.getActionId(), (Object)number);
            this.getModel().setValue("recaccountf7", selectedRow.getPrimaryKeyValue());
            this.getPageCache().put("finclick", "true");
        }
    }

    private boolean isOnline() {
        String formId = ((BillView)this.getView()).getFormId();
        if ("cim_redeem".equals(formId)) {
            String tradeChannel = (String)this.getModel().getValue("tradechannel");
            return TradeChannelEnum.ONLINE.getValue().equals(tradeChannel);
        }
        return false;
    }
}

